/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.breakpad;

import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.api.FirebaseSymbolFileService;
import com.google.firebase.crashlytics.buildtools.ndk.internal.breakpad.BreakpadRecords;
import java.io.File;
import java.io.IOException;

public class BreakpadSymbolFileService
extends FirebaseSymbolFileService {
    private static final String BREAKPAD_UPLOAD_REQUEST_FORMAT = "%s/v1/project/-/app/%s/upload/breakpad/%s";

    public BreakpadSymbolFileService() {
        super(BREAKPAD_UPLOAD_REQUEST_FORMAT);
    }

    @Override
    protected String extractUuid(File symbolFile) throws IOException {
        BreakpadRecords breakpadRecords = BreakpadRecords.createFromBreakpadFile(symbolFile);
        String uuid = breakpadRecords.getCodeId();
        if (uuid == null) {
            Buildtools.logD("Could not find valid INFO record for Breakpad file. Using MODULE ID instead.");
            uuid = breakpadRecords.getModuleId();
        }
        return uuid;
    }
}

