/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.mappingfiles;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class XmlResourceUtils {
    private static final String MAPPING_FILE_ID_ATTRIBUTE = "com.google.firebase.crashlytics.mapping_file_id";
    private static final String XML_STRING_TAG = "string";
    private static final String XML_NAME_ATTRIBUTE = "name";
    private static final String XML_ITEM_TAG = "item";
    private static final String XML_TYPE_TAG = "type";
    static final String STRING_RESOURCE_FORMAT = "<string name=\"com.google.firebase.crashlytics.mapping_file_id\" tools:ignore=\"UnusedResources,TypographyDashes\" translatable=\"false\">%s</string>";

    XmlResourceUtils() {
    }

    public static Element getMappingFileIdElement(Document doc) {
        return XmlResourceUtils.getResourceElement(doc, MAPPING_FILE_ID_ATTRIBUTE);
    }

    public static Element getResourceElement(Document doc, String elementName) {
        NodeList strings = doc.getElementsByTagName(XML_STRING_TAG);
        Element element = null;
        for (int i = 0; i < strings.getLength(); ++i) {
            Element el = (Element)strings.item(i);
            if (!el.hasAttribute(XML_NAME_ATTRIBUTE) || !el.getAttribute(XML_NAME_ATTRIBUTE).equals(elementName)) continue;
            element = el;
            break;
        }
        if (element == null) {
            NodeList items = doc.getElementsByTagName(XML_ITEM_TAG);
            for (int i = 0; i < items.getLength(); ++i) {
                Element el = (Element)items.item(i);
                if (!el.hasAttribute(XML_NAME_ATTRIBUTE) || !el.getAttribute(XML_NAME_ATTRIBUTE).equals(elementName) || !el.hasAttribute(XML_TYPE_TAG) || !el.getAttribute(XML_TYPE_TAG).equals(XML_STRING_TAG)) continue;
                element = el;
                break;
            }
        }
        return element;
    }

    public static InputStream createResourceFileStream(String mappingFileId) {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<resources xmlns:tools=\"http://schemas.android.com/tools\">\n<!--\n  This file is automatically generated by Crashlytics to uniquely \n  identify the mapping file for your Android application.\n\n  Do NOT modify or commit to source control!\n-->\n" + String.format(STRING_RESOURCE_FORMAT, mappingFileId) + "\n</resources>\n";
        return new ByteArrayInputStream(xml.getBytes());
    }
}

