/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.api.net.proxy;

import com.google.firebase.crashlytics.buildtools.Buildtools;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;

public class ProxySettings {
    private final String _proxyHost;
    private final Integer _proxyPort;
    private final String _proxyUser;
    private final String _proxyPassword;

    public ProxySettings(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword) {
        this._proxyHost = proxyHost;
        this._proxyPort = proxyPort;
        this._proxyUser = proxyUser;
        this._proxyPassword = proxyPassword;
    }

    public RequestConfig getConfig() {
        if (this._proxyHost == null || this._proxyPort == null) {
            return RequestConfig.DEFAULT;
        }
        Buildtools.logD("Crashlytics using custom proxy settings: " + this._proxyHost + ":" + this._proxyPort);
        HttpHost proxy = new HttpHost(this._proxyHost, this._proxyPort.intValue());
        return RequestConfig.custom().setProxy(proxy).build();
    }

    public HttpClient getClientFor() throws IOException {
        if (this._proxyHost == null || this._proxyPort == null || this._proxyUser == null || this._proxyPassword == null) {
            return HttpClients.createDefault();
        }
        Buildtools.logD("Crashlytics using proxy auth:" + this._proxyUser);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this._proxyUser, this._proxyPassword);
        AuthScope authScope = new AuthScope(this._proxyHost, this._proxyPort.intValue());
        credsProvider.setCredentials(authScope, (Credentials)credentials);
        return HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
    }
}

