/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.api.net.proxy;

import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.api.net.proxy.ProtocolScheme;
import com.google.firebase.crashlytics.buildtools.api.net.proxy.ProxyFactory;
import com.google.firebase.crashlytics.buildtools.api.net.proxy.ProxySettings;
import java.io.IOException;

public class DefaultProxyFactory
implements ProxyFactory {
    private static final ProxySettings DEFAULT_PROXY_SETTINGS = new ProxySettings(null, null, null, null);
    private static final String OVERRIDE_DEBUG_MSG_FMT = "Found proxy override specified in %s. [host=%s; port=%d; username=%s; pw=HIDDEN]";

    @Override
    public ProxySettings create(ProtocolScheme scheme) throws IOException {
        ProxySettings overrideProxySettings = this.createFromProperties(scheme);
        if (overrideProxySettings == null) {
            overrideProxySettings = this.createFromEnvironment(scheme);
        }
        return overrideProxySettings == null ? DEFAULT_PROXY_SETTINGS : overrideProxySettings;
    }

    private ProxySettings createFromProperties(ProtocolScheme scheme) throws NumberFormatException {
        String proxyHost = null;
        String proxyUser = null;
        String proxyPassword = null;
        String proxyPortString = null;
        switch (scheme) {
            case HTTP: {
                proxyHost = System.getProperty("http.proxyHost");
                proxyPortString = System.getProperty("http.proxyPort");
                proxyUser = System.getProperty("http.proxyUser");
                proxyPassword = System.getProperty("http.proxyPassword");
                break;
            }
            case HTTPS: {
                proxyHost = System.getProperty("https.proxyHost");
                proxyPortString = System.getProperty("https.proxyPort");
                proxyUser = System.getProperty("https.proxyUser");
                proxyPassword = System.getProperty("https.proxyPassword");
                break;
            }
        }
        if (proxyHost == null && proxyPortString == null && proxyUser == null && proxyPassword == null) {
            return null;
        }
        Integer proxyPort = null;
        if (proxyPortString != null) {
            proxyPort = Integer.parseInt(proxyPortString);
        }
        Buildtools.logD(String.format(OVERRIDE_DEBUG_MSG_FMT, "properties", proxyHost, proxyPort, proxyUser));
        return new ProxySettings(proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    private ProxySettings createFromEnvironment(ProtocolScheme scheme) throws NumberFormatException {
        String proxyString = null;
        switch (scheme) {
            case HTTP: {
                proxyString = System.getenv().get("HTTP_PROXY");
                break;
            }
            case HTTPS: {
                proxyString = System.getenv().get("HTTPS_PROXY");
                break;
            }
        }
        if (proxyString == null) {
            return null;
        }
        String[] proxyValues = proxyString.split(":");
        if (proxyValues.length != 3) {
            throw new IllegalArgumentException("Could not parse proxy string from environment variable value: " + proxyString + "; expected: http[s]://host:port");
        }
        String proxyHost = proxyValues[1].substring(2);
        Integer proxyPort = Integer.parseInt(proxyValues[2]);
        Buildtools.logD(String.format(OVERRIDE_DEBUG_MSG_FMT, "environment variable", proxyHost, proxyPort, null));
        return new ProxySettings(proxyHost, proxyPort, null, null);
    }
}

