/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.api;

import com.google.firebase.crashlytics.buildtools.api.SymbolFileService;
import com.google.firebase.crashlytics.buildtools.api.WebApi;
import com.google.firebase.crashlytics.buildtools.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;

public abstract class FirebaseSymbolFileService
implements SymbolFileService {
    private final String uploadRequestFormat;

    protected FirebaseSymbolFileService(String uploadRequestFormat) {
        this.uploadRequestFormat = uploadRequestFormat;
    }

    protected abstract String extractUuid(File var1) throws IOException;

    @Override
    public void uploadNativeSymbolFile(WebApi webApi, File symbolFile, String googleAppId) throws IOException {
        File parent = symbolFile.getParentFile();
        File gZippedSymbolFile = parent == null ? new File(FilenameUtils.removeExtension((String)symbolFile.getName()) + ".gz") : new File(parent, FilenameUtils.removeExtension((String)symbolFile.getName()) + ".gz");
        FileUtils.gZipFile(symbolFile, gZippedSymbolFile);
        URL url = new URL(String.format(this.uploadRequestFormat, webApi.getCodeMappingApiUrl(), googleAppId, this.extractUuid(symbolFile)));
        webApi.uploadFile(url, gZippedSymbolFile);
        gZippedSymbolFile.delete();
    }
}

