/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools;

import com.google.firebase.crashlytics.buildtools.AppBuildInfo;
import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.CrashlyticsOptions;
import com.google.firebase.crashlytics.buildtools.Obfuscator;
import com.google.firebase.crashlytics.buildtools.api.SymbolFileService;
import com.google.firebase.crashlytics.buildtools.log.CrashlyticsLogger;
import com.google.firebase.crashlytics.buildtools.ndk.NativeSymbolGenerator;
import com.google.firebase.crashlytics.buildtools.ndk.internal.breakpad.BreakpadSymbolFileService;
import com.google.firebase.crashlytics.buildtools.ndk.internal.breakpad.BreakpadSymbolGenerator;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CsymSymbolFileService;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.NdkCSymGenerator;
import com.google.firebase.crashlytics.buildtools.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

public class CommandLineHelper {
    private static final String[] VALID_COMMANDS = new String[]{"help", "injectMappingFileIdIntoResource", "uploadMappingFile", "generateNativeSymbols", "uploadNativeSymbols"};
    private final CommandLine cmd;

    public static void main(String[] args) {
        boolean verbose = false;
        try {
            CrashlyticsLogger logger = Buildtools.getLogger();
            boolean quiet = false;
            for (String arg : args) {
                if (arg.equals("-verbose")) {
                    verbose = true;
                    break;
                }
                if (!arg.equals("-quiet")) continue;
                quiet = true;
            }
            if (verbose) {
                Buildtools.getLogger().setLevel(CrashlyticsLogger.Level.VERBOSE);
            } else if (quiet) {
                Buildtools.getLogger().setLevel(CrashlyticsLogger.Level.ERROR);
            }
            Options options = CrashlyticsOptions.createOptions();
            CommandLine cmd = new DefaultParser().parse(options, args);
            if (cmd.hasOption("help")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(Buildtools.class.getName(), options);
                return;
            }
            CommandLineHelper cli = new CommandLineHelper(cmd);
            cli.executeCommand();
        }
        catch (Exception e) {
            String msg = "Crashlytics execution failed." + (!verbose ? " Run with -verbose for additional output." : "");
            Buildtools.logE(msg, e);
            System.exit(-1);
        }
    }

    private void configureWebApi() {
        Buildtools.setWebApi(Buildtools.createWebApi());
        Package packageInfo = CommandLineHelper.class.getPackage();
        String clientName = packageInfo.getImplementationTitle();
        String clientVersion = packageInfo.getImplementationVersion();
        if (this.cmd.hasOption("clientName")) {
            clientName = this.cmd.getOptionValue("clientName");
        }
        if (this.cmd.hasOption("clientVersion")) {
            clientVersion = this.cmd.getOptionValue("clientVersion");
        }
        Buildtools.getInstance().setBuildtoolsClientInfo(clientName, clientVersion);
    }

    public CommandLineHelper(CommandLine cmd) {
        this.cmd = cmd;
    }

    public void executeCommand() throws IOException {
        this.configureWebApi();
        int commandCount = 0;
        for (String validCommand : VALID_COMMANDS) {
            if (!this.cmd.hasOption(validCommand)) continue;
            ++commandCount;
        }
        if (commandCount != 1) {
            throw new IllegalArgumentException("Exactly ONE valid command required. Use '-help' valid arguments.");
        }
        if (this.cmd.hasOption("injectMappingFileIdIntoResource")) {
            this.executeInjectMappingFileId();
        } else if (this.cmd.hasOption("uploadMappingFile")) {
            this.executeUploadMappingFile();
        } else if (this.cmd.hasOption("generateNativeSymbols")) {
            this.executeGenerateSymbols();
        } else if (this.cmd.hasOption("uploadNativeSymbols")) {
            this.executeUploadSymbols();
        }
    }

    private void executeInjectMappingFileId() throws IOException {
        String resourceFilePath = CommandLineHelper.getOptionValueOrThrow(this.cmd, "injectMappingFileIdIntoResource");
        if (this.cmd.hasOption("mappingFileId")) {
            String mappingFileId = CommandLineHelper.getOptionValueOrThrow(this.cmd, "mappingFileId");
            Buildtools.getInstance().injectMappingFileIdIntoResource(new File(resourceFilePath), mappingFileId);
        } else {
            Buildtools.getInstance().injectMappingFileIdIntoResource(new File(resourceFilePath));
        }
    }

    private void executeUploadMappingFile() throws IOException {
        File mappingFile = new File(CommandLineHelper.getOptionValueOrThrow(this.cmd, "uploadMappingFile"));
        String googleAppId = CommandLineHelper.getOptionValueOrThrow(this.cmd, "googleAppId");
        String androidApplicationId = this.cmd.getOptionValue("androidApplicationId", null);
        AppBuildInfo appInfo = new AppBuildInfo(androidApplicationId, googleAppId, null);
        Obfuscator obfuscator = new Obfuscator(Obfuscator.Vendor.PROGUARD, "0.0.0");
        if (this.cmd.hasOption("mappingFileId") && !this.cmd.hasOption("resourceFile")) {
            String mappingFileId = CommandLineHelper.getOptionValueOrThrow(this.cmd, "mappingFileId");
            Buildtools.getInstance().uploadMappingFile(mappingFile, mappingFileId, appInfo, obfuscator);
        } else if (this.cmd.hasOption("resourceFile") && !this.cmd.hasOption("mappingFileId")) {
            File resourceFile = new File(CommandLineHelper.getOptionValueOrThrow(this.cmd, "resourceFile"));
            Buildtools.getInstance().uploadMappingFile(mappingFile, resourceFile, appInfo, obfuscator);
        } else {
            throw new IllegalArgumentException("When executing uploadMappingFile, use either mappingFileId or resourceFile (but not both).");
        }
    }

    private void executeGenerateSymbols() throws IOException {
        boolean useDirs;
        String unstrippedLib = this.cmd.getOptionValue("unstrippedLibrary");
        String unstrippedLibsDir = this.cmd.getOptionValue("unstrippedLibrariesDir");
        boolean useSingleLib = unstrippedLib != null;
        boolean bl = useDirs = unstrippedLibsDir != null;
        if (!Boolean.logicalXor(useSingleLib, useDirs)) {
            throw new IllegalArgumentException("generateNativeSymbols requires either 1) unstrippedLibrary or 2) unstrippedLibrariesDir");
        }
        File csymDir = new File(CommandLineHelper.getOptionValueOrThrow(this.cmd, "symbolFileCacheDir"));
        FileUtils.verifyDirectory(csymDir);
        File path = useSingleLib ? new File(unstrippedLib) : new File(unstrippedLibsDir);
        NativeSymbolGenerator symbolGenerator = CommandLineHelper.createSymbolGenerator(this.cmd);
        Buildtools.getInstance().generateNativeSymbolFiles(path, csymDir, symbolGenerator);
    }

    private void executeUploadSymbols() throws IOException {
        File csymDir = new File(CommandLineHelper.getOptionValueOrThrow(this.cmd, "symbolFileCacheDir"));
        FileUtils.verifyDirectory(csymDir);
        String googleAppId = CommandLineHelper.getOptionValueOrThrow(this.cmd, "googleAppId");
        SymbolFileService symbolFileService = CommandLineHelper.createSymbolFileService(this.cmd);
        Buildtools.getInstance().uploadNativeSymbolFiles(csymDir, googleAppId, symbolFileService);
    }

    private static String getOptionValueOrThrow(CommandLine cmd, String optionKey) throws IllegalArgumentException {
        String val = cmd.getOptionValue(optionKey);
        if (val == null) {
            throw new IllegalArgumentException("Required argument missing: " + optionKey);
        }
        return val;
    }

    private static NativeSymbolGenerator createSymbolGenerator(CommandLine cmd) throws IllegalArgumentException, IOException {
        String symbolGenMode = cmd.getOptionValue("symbolGenerator", "breakpad");
        if ("breakpad".equals(symbolGenMode)) {
            File dumpSymsBin = CommandLineHelper.resolveDumpSymsBinary(cmd);
            return new BreakpadSymbolGenerator(dumpSymsBin);
        }
        if ("csym".equals(symbolGenMode)) {
            return new NdkCSymGenerator();
        }
        CommandLineHelper.throwInvalidSymbolGeneratorMode(symbolGenMode);
        return null;
    }

    private static SymbolFileService createSymbolFileService(CommandLine cmd) throws IllegalArgumentException {
        String symbolGenMode = cmd.getOptionValue("symbolGenerator", "breakpad");
        if ("breakpad".equals(symbolGenMode)) {
            return new BreakpadSymbolFileService();
        }
        if ("csym".equals(symbolGenMode)) {
            return new CsymSymbolFileService();
        }
        CommandLineHelper.throwInvalidSymbolGeneratorMode(symbolGenMode);
        return null;
    }

    private static File resolveDumpSymsBinary(CommandLine cmd) throws IllegalArgumentException, IOException {
        File toReturn;
        if (cmd.hasOption("dumpSymsBinary")) {
            toReturn = new File(cmd.getOptionValue("dumpSymsBinary"));
            if (toReturn == null) {
                throw new IllegalArgumentException("Option dumpSymsBinary specified without a value.");
            }
        } else {
            File defaultBinaryDir = new File(".crashlytics");
            if (!defaultBinaryDir.isDirectory()) {
                if (defaultBinaryDir.isFile()) {
                    throw new IOException("Could not create Crashlytics directory, a file already exists at that location: " + defaultBinaryDir.getAbsolutePath());
                }
                defaultBinaryDir.mkdir();
            }
            toReturn = BreakpadSymbolGenerator.extractDefaultDumpSymsBinary(defaultBinaryDir);
        }
        return toReturn;
    }

    private static void throwInvalidSymbolGeneratorMode(String symbolGenMode) throws IllegalArgumentException {
        throw new IllegalArgumentException("Invalid argument for symbolGenerator (" + symbolGenMode + "), must be one of [" + "breakpad" + ", " + "csym" + "]");
    }
}

