/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor;

import com.google.common.base.Charsets;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DebugAbbrevEntry;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.AttributesReader;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.CompilationUnitContext;
import com.google.firebase.crashlytics.buildtools.utils.io.ByteReader;
import java.io.IOException;
import java.util.List;

public class SkipAttributesReader
implements AttributesReader<Void> {
    private final ByteReader reader;
    private final CompilationUnitContext.Header cuHeader;

    public SkipAttributesReader(ByteReader reader, CompilationUnitContext.Header cuHeader) {
        this.reader = reader;
        this.cuHeader = cuHeader;
    }

    @Override
    public Void readAttributes(List<DebugAbbrevEntry.Attribute> attributes) throws IOException {
        for (DebugAbbrevEntry.Attribute attribute : attributes) {
            SkipAttributesReader.skipDebugInfoEntryAttribute(this.reader, attribute, this.cuHeader);
        }
        return null;
    }

    private static void skipDebugInfoEntryAttribute(ByteReader reader, DebugAbbrevEntry.Attribute attribute, CompilationUnitContext.Header cuHeader) throws IOException {
        switch (attribute.form) {
            case ADDR: {
                reader.readLong(cuHeader.addressSize);
                break;
            }
            case FLAG: 
            case DATA1: 
            case REF1: {
                reader.readBytes(1);
                break;
            }
            case REF2: 
            case DATA2: {
                reader.readBytes(2);
                break;
            }
            case REF4: 
            case DATA4: {
                reader.readBytes(4);
                break;
            }
            case REF8: 
            case DATA8: 
            case REF_SIG8: {
                reader.readBytes(8);
                break;
            }
            case UDATA: 
            case REF_UDATA: {
                reader.readULEB128();
                break;
            }
            case REF_ADDR: {
                reader.readBytes(cuHeader.version < 3 ? cuHeader.addressSize : cuHeader.referenceSize);
                break;
            }
            case SEC_OFFSET: 
            case STRP: {
                reader.readBytes(cuHeader.referenceSize);
                break;
            }
            case BLOCK1: {
                SkipAttributesReader.readBytesWithBlockSize(reader, 1);
                break;
            }
            case BLOCK2: {
                SkipAttributesReader.readBytesWithBlockSize(reader, 2);
                break;
            }
            case BLOCK4: {
                SkipAttributesReader.readBytesWithBlockSize(reader, 4);
                break;
            }
            case BLOCK: 
            case EXPRLOC: {
                SkipAttributesReader.readBytesWithBlockSize(reader);
                break;
            }
            case SDATA: {
                reader.readSLEB128();
                break;
            }
            case STRING: {
                reader.readNullTerminatedString(Charsets.UTF_8);
                break;
            }
        }
    }

    private static byte[] readBytesWithBlockSize(ByteReader reader, int numBytes) throws IOException {
        int blockSize = reader.readInt(numBytes);
        return reader.readBytes(blockSize);
    }

    private static byte[] readBytesWithBlockSize(ByteReader reader) throws IOException {
        int blockSize = reader.readULEB128();
        return reader.readBytes(blockSize);
    }
}

