/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ReferenceBytesConverter {
    private final ByteOrder byteOrder;

    public ReferenceBytesConverter(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public long asLongValue(byte[] referenceBytes) {
        return ReferenceBytesConverter.referenceBytesAsLong(referenceBytes, this.byteOrder);
    }

    private static long referenceBytesAsLong(byte[] data, ByteOrder byteOrder) {
        int dataLen = data.length;
        byte[] padded = new byte[8];
        int dest = byteOrder == ByteOrder.BIG_ENDIAN ? 8 - dataLen : 0;
        System.arraycopy(data, 0, padded, dest, dataLen);
        return ByteBuffer.wrap(padded).order(byteOrder).getLong();
    }
}

