/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.api;

import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.api.WebApi;
import com.google.firebase.crashlytics.buildtools.api.net.proxy.ProtocolScheme;
import com.google.firebase.crashlytics.buildtools.api.net.proxy.ProxyFactory;
import com.google.firebase.crashlytics.buildtools.api.net.proxy.ProxySettings;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;

public class RestfulWebApi
implements WebApi {
    private final ProxyFactory _proxyFactory;
    private String _userAgent;
    private String _clientVersion = null;
    private String _clientType = null;
    private final String _baseApiUrl;
    private final String _codeMappingApiUrl;

    public String toString() {
        return " ClientType: " + this._clientType + " (" + this._clientVersion + ")";
    }

    public RestfulWebApi(String baseApiUrl, String codeMappingApiUrl, ProxyFactory proxyFactory) {
        this._proxyFactory = proxyFactory;
        this._baseApiUrl = baseApiUrl;
        this._codeMappingApiUrl = codeMappingApiUrl;
    }

    @Override
    public synchronized void setUserAgent(String userAgent) {
        this._userAgent = userAgent;
    }

    @Override
    public synchronized void setClientType(String clientType) {
        this._clientType = clientType;
    }

    @Override
    public synchronized void setClientVersion(String clientVersion) {
        this._clientVersion = clientVersion;
    }

    private void sendFile(URL url, File file, Map<String, String> headers) throws IOException {
        HttpPut httpPut;
        Buildtools.logD("PUT file: " + file + " to URL: " + url);
        try {
            httpPut = new HttpPut(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            httpPut.setHeader(header.getKey(), header.getValue());
        }
        this.applyCommonHeadersTo((HttpRequestBase)httpPut);
        FileEntity fileToUpload = new FileEntity(file);
        httpPut.setEntity((HttpEntity)fileToUpload);
        ProxySettings settings = this._proxyFactory.create(ProtocolScheme.getType(url));
        HttpClient client = settings.getClientFor();
        httpPut.setConfig(settings.getConfig());
        Buildtools.logD("PUT headers:");
        for (Header header : httpPut.getAllHeaders()) {
            Buildtools.logD("\t" + header.getName() + " = " + header.getValue());
        }
        HttpResponse response = client.execute((HttpUriRequest)httpPut);
        int result = response.getStatusLine().getStatusCode();
        Buildtools.logD("PUT response: [reqId=" + RestfulWebApi.getRequestId(response) + "] " + result);
        boolean success = RestfulWebApi.isSuccess(result);
        if (!success) {
            throw new IOException("Unknown error while sending file, check network [" + file + "; response: " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine() + "]");
        }
    }

    @Override
    public void uploadFile(URL url, File file) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.sendFile(url, file, headers);
    }

    @Override
    public void applyCommonHeadersTo(HttpRequestBase request) {
        if (this._userAgent != null) {
            request.setHeader("User-Agent", this._userAgent);
        }
        if (this._clientType != null) {
            request.setHeader("X-CRASHLYTICS-API-CLIENT-TYPE", this._clientType);
        }
        if (this._clientVersion != null) {
            request.setHeader("X-CRASHLYTICS-API-CLIENT-VERSION", this._clientVersion);
        }
    }

    @Override
    public String getBaseApiUrl() {
        return this._baseApiUrl;
    }

    @Override
    public String getCodeMappingApiUrl() {
        return this._codeMappingApiUrl;
    }

    private static String getRequestId(HttpResponse response) {
        Header requestIdHeader = response.getFirstHeader("X-Request-Id");
        return requestIdHeader == null ? "null" : requestIdHeader.getValue();
    }

    private static boolean isSuccess(int resultCode) {
        return resultCode >= 200 && resultCode < 300;
    }
}

