/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.elf;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.firebase.crashlytics.buildtools.ndk.internal.elf.ElfSectionHeader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ElfSectionHeaders {
    public static final String SECTION_DEBUG_INFO = ".debug_info";
    public static final String SECTION_DEBUG_ABBREV = ".debug_abbrev";
    public static final String SECTION_DEBUG_STR = ".debug_str";
    public static final String SECTION_DEBUG_RANGES = ".debug_ranges";
    public static final String SECTION_DEBUG_LINE = ".debug_line";
    private final List<ElfSectionHeader> _sectionHeaders;
    private final Map<String, ElfSectionHeader> _nameIndex;

    public ElfSectionHeaders(List<ElfSectionHeader> headers) {
        this._sectionHeaders = headers;
        this._nameIndex = ElfSectionHeaders.indexByName(headers);
    }

    public Optional<ElfSectionHeader> getHeaderByName(String name) {
        return Optional.fromNullable((Object)this._nameIndex.get(name));
    }

    public Optional<ElfSectionHeader> getHeaderByIndex(int index) {
        return index < 0 || index >= this._sectionHeaders.size() ? Optional.absent() : Optional.of((Object)this._sectionHeaders.get(index));
    }

    public Optional<ElfSectionHeader> findHeader(Predicate<ElfSectionHeader> predicate) {
        return Iterables.tryFind(this._sectionHeaders, predicate);
    }

    public List<ElfSectionHeader> getList() {
        return this._sectionHeaders;
    }

    public boolean hasDebugInfo() {
        return this.getHeaderByName(SECTION_DEBUG_INFO).isPresent();
    }

    private static Map<String, ElfSectionHeader> indexByName(List<ElfSectionHeader> headers) {
        LinkedHashMap index = Maps.newLinkedHashMap();
        for (ElfSectionHeader header : headers) {
            index.put(header.shNameString, header);
        }
        return index;
    }
}

