/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.csym;

import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.ndk.NativeSymbolGenerator;
import com.google.firebase.crashlytics.buildtools.ndk.internal.CodeMappingException;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSym;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSymException;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSymFactory;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSymFileWriter;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.ElfCSymFactory;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.StandardCSymFileWriter;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class NdkCSymGenerator
implements NativeSymbolGenerator {
    public static final String CSYM_SUFFIX = ".cSYM";
    private static final String NDKOUT_INCORRECT_CONFIG_MSG = "Is the -androidNdkOut setting configured correctly?";
    private static final String LIB_PREFIX = "lib";
    private static final String SO_FILE_SUFFIX = ".so";
    private static IOFileFilter SO_FILE_FILTER = FileFilterUtils.suffixFileFilter((String)".so", (IOCase)IOCase.INSENSITIVE);
    private final File outputDir;

    public NdkCSymGenerator(File outputDir) {
        this.outputDir = outputDir;
    }

    @Override
    public void generateSymbols(File path) throws IOException, CodeMappingException {
        if (path == null) {
            return;
        }
        ElfCSymFactory cSymFactory = new ElfCSymFactory(true);
        StandardCSymFileWriter cSymFileWriter = new StandardCSymFileWriter();
        if (path.isDirectory()) {
            this.generateSymbolFilesFromDirectory(path, this.outputDir, cSymFactory, cSymFileWriter);
        } else if (path.isFile()) {
            this.generateSymbolFileFromFile(path, this.outputDir, cSymFactory, cSymFileWriter);
        }
    }

    void generateSymbolFilesFromDirectory(File libPath, File outputDir, CSymFactory cSymFactory, CSymFileWriter cSymFileWriter) throws IOException, CodeMappingException {
        String soDirPath = libPath.getCanonicalPath();
        if (!libPath.isDirectory()) {
            throw new CodeMappingException(String.format("Specified path is not a directory: '%s'. %s", soDirPath, NDKOUT_INCORRECT_CONFIG_MSG));
        }
        Collection soFiles = FileUtils.listFiles((File)libPath, (IOFileFilter)SO_FILE_FILTER, (IOFileFilter)TrueFileFilter.INSTANCE);
        if (soFiles.isEmpty()) {
            Buildtools.logW(String.format("Crashlytics found no object files in %s. %s", soDirPath, NDKOUT_INCORRECT_CONFIG_MSG), null);
            return;
        }
        Buildtools.logD("Crashlytics generating cSYM files from object files in " + soDirPath + ":");
        com.google.firebase.crashlytics.buildtools.utils.FileUtils.verifyDirectory(outputDir);
        for (File soFile : soFiles) {
            this.generateSymbolFileFromFile(soFile, outputDir, cSymFactory, cSymFileWriter);
        }
    }

    void generateSymbolFileFromFile(File file, File outputDir, CSymFactory cSymFactory, CSymFileWriter cSymFileWriter) throws IOException, CodeMappingException {
        CSym cSym;
        Buildtools.logD("Generating native symbol file from: " + file);
        if (!file.isFile()) {
            throw new CodeMappingException("Specified path is not a file: " + file);
        }
        com.google.firebase.crashlytics.buildtools.utils.FileUtils.verifyDirectory(outputDir);
        try {
            cSym = cSymFactory.createCSymFromFile(file);
        }
        catch (CSymException e) {
            throw new CodeMappingException(e);
        }
        if (cSym.getUUID() == null || cSym.getUUID().equals("")) {
            Buildtools.logD("Crashlytics could not generate a UUID for " + file + ", skipping.");
        }
        if (cSym.getSymbols().isEmpty()) {
            Buildtools.logD("Crashlytics found no symbols for " + file + ", skipping.");
            return;
        }
        String filename = NdkCSymGenerator.getCSymFilename(cSym, file.getName());
        cSymFileWriter.writeCSymFile(cSym, new File(outputDir, filename));
    }

    private static String getCSymFilename(CSym cSym, String binFilename) {
        String moduleName = FilenameUtils.removeExtension((String)binFilename);
        if (moduleName.startsWith(LIB_PREFIX)) {
            moduleName = moduleName.substring(LIB_PREFIX.length());
        }
        return String.format("%s-%s-%s%s", moduleName, cSym.getArchitecture(), cSym.getUUID(), CSYM_SUFFIX);
    }
}

