/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.android.project;

import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.android.project.BuildIdReader;
import com.google.firebase.crashlytics.buildtools.android.project.ResourceXmlHelper;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XmlBuildIdReader
implements BuildIdReader {
    private final File _resourceFile;
    private final DocumentBuilder _docBuilder;

    public static XmlBuildIdReader create(File resourceFile) {
        try {
            return new XmlBuildIdReader(resourceFile, DocumentBuilderFactory.newInstance().newDocumentBuilder());
        }
        catch (ParserConfigurationException e) {
            Buildtools.logE("Crashlytics experienced an unrecoverable parser configuration exception", e);
            throw new RuntimeException(e);
        }
    }

    private XmlBuildIdReader(File resourceFile, DocumentBuilder builder) {
        this._resourceFile = resourceFile;
        this._docBuilder = builder;
    }

    @Override
    public String getBuildId() throws IOException {
        if (!this._resourceFile.exists()) {
            return null;
        }
        String toReturn = null;
        try {
            Document doc = this._docBuilder.parse(this._resourceFile);
            Element buildIdElement = ResourceXmlHelper.getBuildIdElement(doc);
            if (buildIdElement != null) {
                toReturn = buildIdElement.getTextContent();
            }
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        return toReturn;
    }
}

