/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools;

import com.google.firebase.crashlytics.buildtools.AppBuildInfo;
import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.CrashlyticsOptions;
import com.google.firebase.crashlytics.buildtools.Obfuscator;
import com.google.firebase.crashlytics.buildtools.log.CrashlyticsLogger;
import com.google.firebase.crashlytics.buildtools.utils.FileUtils;
import com.google.firebase.crashlytics.buildtools.utils.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.Options;

public class CommandLineHelper {
    private static String[] VALID_COMMANDS = new String[]{"help", "injectMappingFileIdIntoResource", "uploadMappingFile", "generateNativeSymbols", "uploadNativeSymbols"};
    private final Properties cliArgs;

    public static void main(String[] args) {
        try {
            CrashlyticsLogger logger = Buildtools.getLogger();
            boolean quiet = false;
            boolean verbose = false;
            for (String arg : args) {
                if (arg.equals("-verbose")) {
                    verbose = true;
                    break;
                }
                if (!arg.equals("-quiet")) continue;
                quiet = true;
            }
            if (verbose) {
                Buildtools.getLogger().setLevel(CrashlyticsLogger.Level.VERBOSE);
            } else if (quiet) {
                Buildtools.getLogger().setLevel(CrashlyticsLogger.Level.ERROR);
            }
            Options options = CrashlyticsOptions.createOptions();
            Properties properties = PropertiesUtils.processArgs(CommandLineHelper.class.getName(), args, options);
            Buildtools.logD("Invoked Crashlytics Buildtools with arguments: " + PropertiesUtils.toString(properties).replaceAll("\n", "\n\t"));
            CommandLineHelper cli = new CommandLineHelper(properties);
            cli.doMain();
        }
        catch (Exception e) {
            Buildtools.logE(e.getMessage(), e);
        }
    }

    public CommandLineHelper(Properties cliArgs) {
        this.cliArgs = cliArgs;
    }

    public void configureWebApi() {
        Buildtools.setWebApi(Buildtools.createWebApi());
        Package packageInfo = CommandLineHelper.class.getPackage();
        String toolId = packageInfo.getImplementationTitle();
        String toolVersion = packageInfo.getImplementationVersion();
        Buildtools.getInstance().setBuildtoolsClientInfo(toolId, toolVersion);
    }

    private void doMain() throws IOException {
        this.configureWebApi();
        int commandCount = 0;
        for (String validCommand : VALID_COMMANDS) {
            if (!this.cliArgs.containsKey(validCommand)) continue;
            ++commandCount;
        }
        if (commandCount != 1) {
            throw new IllegalArgumentException("Exactly ONE valid command required. Use '-help' valid arguments.");
        }
        if (this.cliArgs.containsKey("injectMappingFileIdIntoResource")) {
            this.executeInjectMappingFileId();
        } else if (this.cliArgs.containsKey("uploadMappingFile")) {
            this.executeUploadMappingFile();
        } else if (this.cliArgs.containsKey("generateNativeSymbols")) {
            this.executeGenerateSymbols();
        } else if (this.cliArgs.containsKey("uploadNativeSymbols")) {
            this.executeUploadSymbols();
        }
    }

    private void executeInjectMappingFileId() throws IOException {
        String resourceFilePath = CommandLineHelper.getPropertyOrThrow(this.cliArgs, "injectMappingFileIdIntoResource");
        String mappingFileId = CommandLineHelper.getPropertyOrThrow(this.cliArgs, "mappingFileId");
        Buildtools.getInstance().injectMappingFileIdIntoResource(new File(resourceFilePath), mappingFileId);
    }

    private void executeUploadMappingFile() throws IOException {
        String mappingFilePath = CommandLineHelper.getPropertyOrThrow(this.cliArgs, "uploadMappingFile");
        String mappingFileId = CommandLineHelper.getPropertyOrThrow(this.cliArgs, "mappingFileId");
        String androidApplicationId = CommandLineHelper.getPropertyOrThrow(this.cliArgs, "androidApplicationId");
        String googleAppId = CommandLineHelper.getPropertyOrThrow(this.cliArgs, "googleAppId");
        AppBuildInfo appInfo = new AppBuildInfo(androidApplicationId, googleAppId, null);
        Obfuscator obfuscator = new Obfuscator(Obfuscator.Vendor.PROGUARD, "0.0.0");
        Buildtools.getInstance().uploadMappingFile(new File(mappingFilePath), mappingFileId, appInfo, obfuscator);
    }

    private void executeGenerateSymbols() throws IOException {
        boolean useDirs;
        String strippedLib = this.cliArgs.getProperty("strippedLibrary");
        String unstrippedLib = this.cliArgs.getProperty("unstrippedLibrary");
        String strippedLibsDir = this.cliArgs.getProperty("strippedLibrariesDir");
        String unstrippedLibsDir = this.cliArgs.getProperty("unstrippedLibrariesDir");
        boolean useSingleLib = strippedLib != null && unstrippedLib != null;
        boolean bl = useDirs = strippedLibsDir != null && unstrippedLibsDir != null;
        if (!Boolean.logicalXor(useSingleLib, useDirs) && (Boolean.logicalXor(strippedLib == null, unstrippedLib == null) || Boolean.logicalXor(strippedLibsDir == null, unstrippedLibsDir == null))) {
            throw new IllegalArgumentException("generateNativeSymbols requires either 1) unstrippedLibrary and strippedLibrary; or 2) strippedLibrariesDirand strippedLibrariesDir");
        }
        File csymDir = new File(CommandLineHelper.getPropertyOrThrow(this.cliArgs, "symbolFileCacheDir"));
        FileUtils.verifyDirectory(csymDir);
        if (useSingleLib) {
            Buildtools.getInstance().generateSymbolsFromFile(new File(unstrippedLib), new File(strippedLib), csymDir);
        } else if (useDirs) {
            Buildtools.getInstance().generateSymbolsFromDirectory(new File(unstrippedLibsDir), new File(strippedLibsDir), csymDir);
        }
    }

    private void executeUploadSymbols() throws IOException {
        File csymDir = new File(CommandLineHelper.getPropertyOrThrow(this.cliArgs, "symbolFileCacheDir"));
        FileUtils.verifyDirectory(csymDir);
        Buildtools.getInstance().uploadNativeSymbolFiles(csymDir, this.createAppBuildInfoOrThrow());
    }

    private static String getPropertyOrThrow(Properties props, String propKey) throws IllegalArgumentException {
        String toReturn = props.getProperty(propKey);
        if (toReturn == null) {
            throw new IllegalArgumentException("Required argument missing: " + propKey);
        }
        return toReturn;
    }

    private AppBuildInfo createAppBuildInfoOrThrow() throws IllegalArgumentException {
        String androidApplicationId = CommandLineHelper.getPropertyOrThrow(this.cliArgs, "androidApplicationId");
        String googleAppId = CommandLineHelper.getPropertyOrThrow(this.cliArgs, "googleAppId");
        return new AppBuildInfo(androidApplicationId, googleAppId, null);
    }
}

