/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzecm;
import com.google.android.gms.internal.zzecn;
import com.google.android.gms.internal.zzeco;
import com.google.android.gms.internal.zzecp;
import com.google.android.gms.internal.zzecq;
import com.google.android.gms.internal.zzect;
import com.google.android.gms.internal.zzecy;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crash.zzd;
import com.google.firebase.crash.zze;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@UsedByReflection(value="FirebaseApp")
public class FirebaseCrash {
    private static volatile FirebaseCrash zzmum;
    private final Context mContext;
    private final ExecutorService zzmun;
    private final FirebaseApp zzmpb;
    private final zzb zzmuo;
    private final CountDownLatch zzmup = new CountDownLatch(1);
    private zzecy zzmuq;

    @Hide
    private FirebaseCrash(@NonNull FirebaseApp firebaseApp, @NonNull ExecutorService executorService) {
        this.zzmpb = firebaseApp;
        this.zzmun = executorService;
        this.mContext = this.zzmpb.getApplicationContext();
        this.zzmuo = new zzb(null);
    }

    final void zza(@Nullable zzect zzect2) {
        if (zzect2 == null) {
            this.zzmun.shutdownNow();
        } else {
            this.zzmuq = zzecy.zzez(this.mContext);
            this.zzmuo.zzb(zzect2);
            FirebaseCrash firebaseCrash = this;
            if (firebaseCrash.zzmuq != null && !firebaseCrash.zzbuv()) {
                firebaseCrash.zzmuq.zza(firebaseCrash.mContext, firebaseCrash.zzmun, firebaseCrash.zzmuo);
                Log.d((String)"FirebaseCrash", (String)"Firebase Analytics Listener for Firebase Crash is initialized");
            }
        }
        this.zzmup.countDown();
    }

    private final void zzbut() {
        try {
            this.zzmup.await(20000L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.e((String)"FirebaseCrash", (String)"Failed waiting for crash api to load.", (Throwable)interruptedException);
            return;
        }
    }

    @Hide
    public static FirebaseCrash zzbuu() {
        if (zzmum != null) {
            return zzmum;
        }
        return FirebaseCrash.getInstance(FirebaseApp.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Hide
    @Keep
    @UsedByReflection(value="FirebaseApp")
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        if (zzmum != null) return zzmum;
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            com.google.firebase.crash.zzc zzc2;
            if (zzmum != null) return zzmum;
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            FirebaseCrash firebaseCrash = new FirebaseCrash(firebaseApp, threadPoolExecutor);
            com.google.firebase.crash.zzc zzc3 = zzc2 = new com.google.firebase.crash.zzc(firebaseApp, null);
            FirebaseCrash firebaseCrash2 = firebaseCrash;
            Thread.setDefaultUncaughtExceptionHandler(new zzc(firebaseCrash2, Thread.getDefaultUncaughtExceptionHandler()));
            com.google.firebase.crash.zzb zzb2 = new com.google.firebase.crash.zzb(firebaseCrash2);
            com.google.firebase.crash.zzc zzc4 = zzc3;
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            Future<zzect> future = executorService.submit(new zzd(zzc4));
            executorService.submit(new zze(zzc4, future, 10000L, zzb2));
            executorService.shutdown();
            firebaseCrash2.zzmun.execute(new com.google.firebase.crash.zza(firebaseCrash2));
            zzmum = firebaseCrash;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzmum;
        }
    }

    @Hide
    public final boolean zzbuv() {
        return this.zzmun.isShutdown();
    }

    public static void log(String string) {
        FirebaseCrash.zzbuu().zzpk(string);
    }

    public static void logcat(int n, String string, String string2) {
        String string3 = string2;
        String string4 = string;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbuu();
        if (string3 != null) {
            if (string4 == null) {
                string4 = "";
            }
            Log.println((int)n, (String)string4, (String)string3);
            firebaseCrash.zzpk(string3);
        }
    }

    public static void report(Throwable throwable) {
        Throwable throwable2 = throwable;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbuu();
        if (throwable2 == null || firebaseCrash.zzbuv()) {
            return;
        }
        firebaseCrash.zzmun.submit(new zzecm(firebaseCrash.mContext, firebaseCrash.zzmuo, throwable2, firebaseCrash.zzmuq));
    }

    public static void setCrashCollectionEnabled(boolean bl) {
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbuu();
        if (!firebaseCrash.zzbuv()) {
            firebaseCrash.zzmun.submit(new zzecq(firebaseCrash.mContext, firebaseCrash.zzmuo, bl));
        }
    }

    public static boolean isCrashCollectionEnabled() {
        return FirebaseCrash.zzbuu().zzbuw();
    }

    private final boolean zzbuw() {
        if (this.zzbuv()) {
            return false;
        }
        this.zzbut();
        zzect zzect2 = this.zzmuo.zzbux();
        if (zzect2 != null) {
            try {
                return zzect2.zzbuw();
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        return false;
    }

    private final void zzpk(String string) {
        if (string == null || this.zzbuv()) {
            return;
        }
        this.zzmun.submit(new zzecn(this.mContext, this.zzmuo, string));
    }

    @Nullable
    final Future<?> zzi(Throwable throwable) {
        if (throwable == null || this.zzbuv()) {
            return null;
        }
        return this.zzmun.submit(new zzeco(this.mContext, this.zzmuo, throwable, this.zzmuq));
    }

    @Hide
    final void zzcp(boolean bl) {
        if (this.zzbuv()) {
            return;
        }
        this.zzmun.submit(new zzecp(this.mContext, this.zzmuo, bl));
    }

    static /* synthetic */ void zza(FirebaseCrash firebaseCrash) {
        firebaseCrash.zzbut();
    }

    final class zzc
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler zzmuu;
        private /* synthetic */ FirebaseCrash zzmur;

        public zzc(@Nullable FirebaseCrash firebaseCrash, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.zzmur = firebaseCrash;
            this.zzmuu = uncaughtExceptionHandler;
        }

        @Override
        public final void uncaughtException(Thread thread, Throwable throwable) {
            Log.e((String)"UncaughtException", (String)"", (Throwable)throwable);
            if (!this.zzmur.zzbuv()) {
                try {
                    Future<?> future = this.zzmur.zzi(throwable);
                    if (future != null) {
                        future.get(10000L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"UncaughtException", (String)"Ouch! My own exception handler threw an exception.", (Throwable)exception);
                }
            }
            if (this.zzmuu != null) {
                this.zzmuu.uncaughtException(thread, throwable);
            }
        }
    }

    static final class zzb
    implements zza {
        private final Object zzmus = new Object();
        private zzect zzmut;

        private zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public final zzect zzbux() {
            Object object = this.zzmus;
            synchronized (object) {
                return this.zzmut;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void zzb(@Nullable zzect zzect2) {
            Object object = this.zzmus;
            synchronized (object) {
                this.zzmut = zzect2;
                return;
            }
        }

        /* synthetic */ zzb(com.google.firebase.crash.zza zza2) {
            this();
        }
    }

    @Hide
    public static interface zza {
        @Nullable
        public zzect zzbux();
    }
}

