/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigContainer {
    static final String CONFIGS_KEY = "configs_key";
    static final String FETCH_TIME_KEY = "fetch_time_key";
    static final String ABT_EXPERIMENTS_KEY = "abt_experiments_key";
    static final String PERSONALIZATION_METADATA_KEY = "personalization_metadata_key";
    static final String TEMPLATE_VERSION_NUMBER_KEY = "template_version_number_key";
    static final String ROLLOUT_METADATA_KEY = "rollout_metadata_key";
    public static final String ROLLOUT_METADATA_AFFECTED_KEYS = "affectedParameterKeys";
    public static final String ROLLOUT_METADATA_ID = "rolloutId";
    public static final String ROLLOUT_METADATA_VARIANT_ID = "variantId";
    private static final Date DEFAULTS_FETCH_TIME = new Date(0L);
    private JSONObject containerJson;
    private JSONObject configsJson;
    private Date fetchTime;
    private JSONArray abtExperiments;
    private JSONObject personalizationMetadata;
    private long templateVersionNumber;
    private JSONArray rolloutMetadata;

    private ConfigContainer(JSONObject configsJson, Date fetchTime, JSONArray abtExperiments, JSONObject personalizationMetadata, long templateVersionNumber, JSONArray rolloutMetadata) throws JSONException {
        JSONObject containerJson = new JSONObject();
        containerJson.put(CONFIGS_KEY, (Object)configsJson);
        containerJson.put(FETCH_TIME_KEY, fetchTime.getTime());
        containerJson.put(ABT_EXPERIMENTS_KEY, (Object)abtExperiments);
        containerJson.put(PERSONALIZATION_METADATA_KEY, (Object)personalizationMetadata);
        containerJson.put(TEMPLATE_VERSION_NUMBER_KEY, templateVersionNumber);
        containerJson.put(ROLLOUT_METADATA_KEY, (Object)rolloutMetadata);
        this.configsJson = configsJson;
        this.fetchTime = fetchTime;
        this.abtExperiments = abtExperiments;
        this.personalizationMetadata = personalizationMetadata;
        this.templateVersionNumber = templateVersionNumber;
        this.rolloutMetadata = rolloutMetadata;
        this.containerJson = containerJson;
    }

    static ConfigContainer copyOf(JSONObject containerJson) throws JSONException {
        JSONArray rolloutMetadataJSON;
        JSONObject personalizationMetadataJSON = containerJson.optJSONObject(PERSONALIZATION_METADATA_KEY);
        if (personalizationMetadataJSON == null) {
            personalizationMetadataJSON = new JSONObject();
        }
        if ((rolloutMetadataJSON = containerJson.optJSONArray(ROLLOUT_METADATA_KEY)) == null) {
            rolloutMetadataJSON = new JSONArray();
        }
        return new ConfigContainer(containerJson.getJSONObject(CONFIGS_KEY), new Date(containerJson.getLong(FETCH_TIME_KEY)), containerJson.getJSONArray(ABT_EXPERIMENTS_KEY), personalizationMetadataJSON, containerJson.optLong(TEMPLATE_VERSION_NUMBER_KEY), rolloutMetadataJSON);
    }

    private static ConfigContainer deepCopyOf(JSONObject containerJson) throws JSONException {
        JSONObject deepCopyJson = new JSONObject(containerJson.toString());
        return ConfigContainer.copyOf(deepCopyJson);
    }

    public JSONObject getConfigs() {
        return this.configsJson;
    }

    public Date getFetchTime() {
        return this.fetchTime;
    }

    public JSONArray getAbtExperiments() {
        return this.abtExperiments;
    }

    public JSONObject getPersonalizationMetadata() {
        return this.personalizationMetadata;
    }

    public long getTemplateVersionNumber() {
        return this.templateVersionNumber;
    }

    public JSONArray getRolloutMetadata() {
        return this.rolloutMetadata;
    }

    public String toString() {
        return this.containerJson.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigContainer)) {
            return false;
        }
        ConfigContainer that = (ConfigContainer)o;
        return this.containerJson.toString().equals(that.toString());
    }

    private Map<String, Map<String, String>> createRolloutParameterKeyMap() throws JSONException {
        HashMap<String, Map<String, String>> rolloutMetadataMap = new HashMap<String, Map<String, String>>();
        for (int i = 0; i < this.getRolloutMetadata().length(); ++i) {
            JSONObject rolloutMetadata = this.getRolloutMetadata().getJSONObject(i);
            String rolloutId = rolloutMetadata.getString(ROLLOUT_METADATA_ID);
            String variantId = rolloutMetadata.getString(ROLLOUT_METADATA_VARIANT_ID);
            JSONArray parameterKeys = rolloutMetadata.getJSONArray(ROLLOUT_METADATA_AFFECTED_KEYS);
            for (int j = 0; j < parameterKeys.length(); ++j) {
                Map parameterKeyRolloutMetadata;
                String parameterKey = parameterKeys.getString(j);
                if (!rolloutMetadataMap.containsKey(parameterKey)) {
                    rolloutMetadataMap.put(parameterKey, new HashMap());
                }
                if ((parameterKeyRolloutMetadata = (Map)rolloutMetadataMap.get(parameterKey)) == null) continue;
                parameterKeyRolloutMetadata.put(rolloutId, variantId);
            }
        }
        return rolloutMetadataMap;
    }

    public Set<String> getChangedParams(ConfigContainer other) throws JSONException {
        JSONObject otherConfig = ConfigContainer.deepCopyOf(other.containerJson).getConfigs();
        Map<String, Map<String, String>> rolloutMetadataMap = this.createRolloutParameterKeyMap();
        Map<String, Map<String, String>> otherRolloutMetadataMap = other.createRolloutParameterKeyMap();
        HashSet<String> changed = new HashSet<String>();
        Iterator keys = this.getConfigs().keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!other.getConfigs().has(key)) {
                changed.add(key);
                continue;
            }
            if (!this.getConfigs().get(key).equals(other.getConfigs().get(key))) {
                changed.add(key);
                continue;
            }
            if (this.getPersonalizationMetadata().has(key) && !other.getPersonalizationMetadata().has(key) || !this.getPersonalizationMetadata().has(key) && other.getPersonalizationMetadata().has(key)) {
                changed.add(key);
                continue;
            }
            if (this.getPersonalizationMetadata().has(key) && other.getPersonalizationMetadata().has(key) && !this.getPersonalizationMetadata().getJSONObject(key).toString().equals(other.getPersonalizationMetadata().getJSONObject(key).toString())) {
                changed.add(key);
                continue;
            }
            if (rolloutMetadataMap.containsKey(key) != otherRolloutMetadataMap.containsKey(key)) {
                changed.add(key);
                continue;
            }
            if (rolloutMetadataMap.containsKey(key) && otherRolloutMetadataMap.containsKey(key) && !rolloutMetadataMap.get(key).equals(otherRolloutMetadataMap.get(key))) {
                changed.add(key);
                continue;
            }
            otherConfig.remove(key);
        }
        Iterator remainingOtherKeys = otherConfig.keys();
        while (remainingOtherKeys.hasNext()) {
            changed.add((String)remainingOtherKeys.next());
        }
        return changed;
    }

    public int hashCode() {
        return this.containerJson.hashCode();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ConfigContainer otherContainer) {
        return new Builder(otherContainer);
    }

    public static class Builder {
        private JSONObject builderConfigsJson;
        private Date builderFetchTime;
        private JSONArray builderAbtExperiments;
        private JSONObject builderPersonalizationMetadata;
        private long builderTemplateVersionNumber;
        private JSONArray builderRolloutMetadata;

        private Builder() {
            this.builderConfigsJson = new JSONObject();
            this.builderFetchTime = DEFAULTS_FETCH_TIME;
            this.builderAbtExperiments = new JSONArray();
            this.builderPersonalizationMetadata = new JSONObject();
            this.builderTemplateVersionNumber = 0L;
            this.builderRolloutMetadata = new JSONArray();
        }

        public Builder(ConfigContainer otherContainer) {
            this.builderConfigsJson = otherContainer.getConfigs();
            this.builderFetchTime = otherContainer.getFetchTime();
            this.builderAbtExperiments = otherContainer.getAbtExperiments();
            this.builderPersonalizationMetadata = otherContainer.getPersonalizationMetadata();
            this.builderTemplateVersionNumber = otherContainer.getTemplateVersionNumber();
            this.builderRolloutMetadata = otherContainer.getRolloutMetadata();
        }

        public Builder replaceConfigsWith(Map<String, String> configsMap) {
            this.builderConfigsJson = new JSONObject(configsMap);
            return this;
        }

        public Builder replaceConfigsWith(JSONObject configsJson) {
            try {
                this.builderConfigsJson = new JSONObject(configsJson.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return this;
        }

        public Builder withFetchTime(Date fetchTime) {
            this.builderFetchTime = fetchTime;
            return this;
        }

        public Builder withAbtExperiments(JSONArray abtExperiments) {
            try {
                this.builderAbtExperiments = new JSONArray(abtExperiments.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return this;
        }

        public Builder withPersonalizationMetadata(JSONObject personalizationMetadata) {
            try {
                this.builderPersonalizationMetadata = new JSONObject(personalizationMetadata.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return this;
        }

        public Builder withTemplateVersionNumber(long templateVersionNumber) {
            this.builderTemplateVersionNumber = templateVersionNumber;
            return this;
        }

        public Builder withRolloutMetadata(JSONArray rolloutMetadata) {
            try {
                this.builderRolloutMetadata = new JSONArray(rolloutMetadata.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return this;
        }

        public ConfigContainer build() throws JSONException {
            return new ConfigContainer(this.builderConfigsJson, this.builderFetchTime, this.builderAbtExperiments, this.builderPersonalizationMetadata, this.builderTemplateVersionNumber, this.builderRolloutMetadata);
        }
    }
}

