/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import android.os.Bundle;
import androidx.annotation.NonNull;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.remoteconfig.internal.ConfigContainer;
import org.json.JSONObject;

public class Personalization {
    public static final String ANALYTICS_ORIGIN_PERSONALIZATION = "fp";
    public static final String ANALYTICS_PULL_EVENT = "_fpc";
    public static final String ARM_KEY = "_fpid";
    public static final String ARM_VALUE = "_fpct";
    static final String PERSONALIZATION_ID = "personalizationId";
    private final AnalyticsConnector analyticsConnector;

    public Personalization(@NonNull AnalyticsConnector analyticsConnector) {
        this.analyticsConnector = analyticsConnector;
    }

    public void logArmActive(@NonNull String key, @NonNull ConfigContainer configContainer) {
        JSONObject ids = configContainer.getPersonalizationMetadata();
        if (ids.length() < 1) {
            return;
        }
        JSONObject values = configContainer.getConfigs();
        if (values.length() < 1) {
            return;
        }
        JSONObject metadata = ids.optJSONObject(key);
        if (metadata == null) {
            return;
        }
        Bundle params = new Bundle();
        params.putString(ARM_KEY, metadata.optString(PERSONALIZATION_ID));
        params.putString(ARM_VALUE, values.optString(key));
        this.analyticsConnector.logEvent(ANALYTICS_ORIGIN_PERSONALIZATION, ANALYTICS_PULL_EVENT, params);
    }
}

