/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import android.util.Log;
import androidx.annotation.AnyThread;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.remoteconfig.internal.ConfigCacheClient$$Lambda$1;
import com.google.firebase.remoteconfig.internal.ConfigCacheClient$$Lambda$2;
import com.google.firebase.remoteconfig.internal.ConfigCacheClient$$Lambda$3;
import com.google.firebase.remoteconfig.internal.ConfigCacheClient$$Lambda$4;
import com.google.firebase.remoteconfig.internal.ConfigContainer;
import com.google.firebase.remoteconfig.internal.ConfigStorageClient;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@AnyThread
public class ConfigCacheClient {
    static final long DISK_READ_TIMEOUT_IN_SECONDS = 5L;
    @GuardedBy(value="ConfigCacheClient.class")
    private static final Map<String, ConfigCacheClient> clientInstances = new HashMap<String, ConfigCacheClient>();
    private final ExecutorService executorService;
    private final ConfigStorageClient storageClient;
    @GuardedBy(value="this")
    @Nullable
    private Task<ConfigContainer> cachedContainerTask;
    private static final Executor DIRECT_EXECUTOR = ConfigCacheClient$$Lambda$4.lambdaFactory$();

    private ConfigCacheClient(ExecutorService executorService, ConfigStorageClient storageClient) {
        this.executorService = executorService;
        this.storageClient = storageClient;
        this.cachedContainerTask = null;
    }

    @Nullable
    public ConfigContainer getBlocking() {
        return this.getBlocking(5L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    ConfigContainer getBlocking(long diskReadTimeoutInSeconds) {
        ConfigCacheClient configCacheClient = this;
        synchronized (configCacheClient) {
            if (this.cachedContainerTask != null && this.cachedContainerTask.isSuccessful()) {
                return (ConfigContainer)this.cachedContainerTask.getResult();
            }
        }
        try {
            return ConfigCacheClient.await(this.get(), diskReadTimeoutInSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Log.d((String)"FirebaseRemoteConfig", (String)"Reading from storage file failed.", (Throwable)e);
            return null;
        }
    }

    public Task<ConfigContainer> put(ConfigContainer configContainer) {
        return this.put(configContainer, true);
    }

    public Task<ConfigContainer> put(ConfigContainer configContainer, boolean shouldUpdateInMemoryContainer) {
        return Tasks.call((Executor)this.executorService, (Callable)ConfigCacheClient$$Lambda$1.lambdaFactory$(this, configContainer)).onSuccessTask((Executor)this.executorService, ConfigCacheClient$$Lambda$2.lambdaFactory$(this, shouldUpdateInMemoryContainer, configContainer));
    }

    public synchronized Task<ConfigContainer> get() {
        if (this.cachedContainerTask == null || this.cachedContainerTask.isComplete() && !this.cachedContainerTask.isSuccessful()) {
            ConfigStorageClient configStorageClient = this.storageClient;
            configStorageClient.getClass();
            this.cachedContainerTask = Tasks.call((Executor)this.executorService, (Callable)ConfigCacheClient$$Lambda$3.lambdaFactory$(configStorageClient));
        }
        return this.cachedContainerTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ConfigCacheClient configCacheClient = this;
        synchronized (configCacheClient) {
            this.cachedContainerTask = Tasks.forResult(null);
        }
        this.storageClient.clear();
    }

    private synchronized void updateInMemoryConfigContainer(ConfigContainer configContainer) {
        this.cachedContainerTask = Tasks.forResult((Object)configContainer);
    }

    @VisibleForTesting
    @Nullable
    synchronized Task<ConfigContainer> getCachedContainerTask() {
        return this.cachedContainerTask;
    }

    public static synchronized ConfigCacheClient getInstance(ExecutorService executorService, ConfigStorageClient storageClient) {
        String fileName = storageClient.getFileName();
        if (!clientInstances.containsKey(fileName)) {
            clientInstances.put(fileName, new ConfigCacheClient(executorService, storageClient));
        }
        return clientInstances.get(fileName);
    }

    @VisibleForTesting
    public static synchronized void clearInstancesForTest() {
        clientInstances.clear();
    }

    private static <TResult> TResult await(Task<TResult> task, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        AwaitListener waiter = new AwaitListener();
        task.addOnSuccessListener(DIRECT_EXECUTOR, waiter);
        task.addOnFailureListener(DIRECT_EXECUTOR, waiter);
        task.addOnCanceledListener(DIRECT_EXECUTOR, waiter);
        if (!waiter.await(timeout, unit)) {
            throw new TimeoutException("Task await timed out.");
        }
        if (task.isSuccessful()) {
            return (TResult)task.getResult();
        }
        throw new ExecutionException(task.getException());
    }

    static /* synthetic */ Task lambda$put$1(ConfigCacheClient this_, boolean shouldUpdateInMemoryContainer, ConfigContainer configContainer, Void unusedVoid) throws Exception {
        if (shouldUpdateInMemoryContainer) {
            this_.updateInMemoryConfigContainer(configContainer);
        }
        return Tasks.forResult((Object)configContainer);
    }

    static /* synthetic */ Void lambda$put$0(ConfigCacheClient this_, ConfigContainer configContainer) throws Exception {
        return this_.storageClient.write(configContainer);
    }

    private static class AwaitListener<TResult>
    implements OnSuccessListener<TResult>,
    OnFailureListener,
    OnCanceledListener {
        private final CountDownLatch latch = new CountDownLatch(1);

        private AwaitListener() {
        }

        public void onSuccess(TResult o) {
            this.latch.countDown();
        }

        public void onFailure(@NonNull Exception e) {
            this.latch.countDown();
        }

        public void onCanceled() {
            this.latch.countDown();
        }

        public void await() throws InterruptedException {
            this.latch.await();
        }

        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.latch.await(timeout, unit);
        }
    }
}

