/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.config;

import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public final class zzap
implements FirebaseRemoteConfigValue {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Pattern zzm = Pattern.compile("^(1|true|t|yes|y|on)$", 2);
    public static final Pattern zzn = Pattern.compile("^(0|false|f|no|n|off|)$", 2);
    private final byte[] zzba;
    private final int zzbb;

    public zzap(byte[] byArray, int n) {
        this.zzba = byArray;
        this.zzbb = n;
    }

    @Override
    public final long asLong() {
        if (this.zzbb == 0) {
            return 0L;
        }
        String string = this.asString().trim();
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.format("[Value: %s] cannot be converted to a %s.", string, "long"), numberFormatException);
        }
    }

    @Override
    public final double asDouble() {
        if (this.zzbb == 0) {
            return 0.0;
        }
        String string = this.asString().trim();
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.format("[Value: %s] cannot be converted to a %s.", string, "double"), numberFormatException);
        }
    }

    @Override
    public final String asString() {
        if (this.zzbb == 0) {
            return "";
        }
        if (this.zzba == null) {
            throw new IllegalArgumentException("Value is null, and cannot be converted to the desired type.");
        }
        return new String(this.zzba, UTF_8);
    }

    @Override
    public final byte[] asByteArray() {
        if (this.zzbb == 0) {
            return FirebaseRemoteConfig.DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        return this.zzba;
    }

    @Override
    public final boolean asBoolean() throws IllegalArgumentException {
        if (this.zzbb == 0) {
            return false;
        }
        String string = this.asString().trim();
        if (zzm.matcher(string).matches()) {
            return true;
        }
        if (zzn.matcher(string).matches()) {
            return false;
        }
        throw new IllegalArgumentException(String.format("[Value: %s] cannot be converted to a %s.", string, "boolean"));
    }

    @Override
    public final int getSource() {
        return this.zzbb;
    }
}

