/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.internal.zzbii;
import com.google.android.gms.internal.zzbim;
import com.google.android.gms.internal.zzbin;
import com.google.android.gms.internal.zzbio;
import com.google.android.gms.internal.zzbiz;
import com.google.android.gms.internal.zzdyx;
import com.google.android.gms.internal.zzfam;
import com.google.android.gms.internal.zzfan;
import com.google.android.gms.internal.zzfao;
import com.google.android.gms.internal.zzfap;
import com.google.android.gms.internal.zzfaq;
import com.google.android.gms.internal.zzfar;
import com.google.android.gms.internal.zzfas;
import com.google.android.gms.internal.zzfat;
import com.google.android.gms.internal.zzfau;
import com.google.android.gms.internal.zzfav;
import com.google.android.gms.internal.zzfaw;
import com.google.android.gms.internal.zzfax;
import com.google.android.gms.internal.zzfay;
import com.google.android.gms.internal.zzflj;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.zza;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig zzosa;
    private zzfap zzosb;
    private zzfap zzosc;
    private zzfap zzosd;
    private zzfas zzose;
    private final Context mContext;
    private final ReadWriteLock zzosf = new ReentrantReadWriteLock(true);

    private FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, zzfap zzfap2, zzfap zzfap3, zzfap zzfap4, zzfas zzfas2) {
        this.mContext = context;
        this.zzose = zzfas2 != null ? zzfas2 : new zzfas();
        this.zzose.zzco(this.zzfi(this.mContext));
        if (zzfap2 != null) {
            this.zzosb = zzfap2;
        }
        if (zzfap3 != null) {
            this.zzosc = zzfap3;
        }
        if (zzfap4 != null) {
            this.zzosd = zzfap4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (zzosa == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            if (zzosa == null) {
                zzfax zzfax2 = FirebaseRemoteConfig.zzfj(context);
                if (zzfax2 == null) {
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                    }
                    zzosa = new FirebaseRemoteConfig(context);
                } else {
                    zzfas zzfas2;
                    zzfas zzfas3;
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                    }
                    zzfap zzfap2 = FirebaseRemoteConfig.zza(zzfax2.zzotf);
                    zzfap zzfap3 = FirebaseRemoteConfig.zza(zzfax2.zzotg);
                    zzfap zzfap4 = FirebaseRemoteConfig.zza(zzfax2.zzoth);
                    zzfav zzfav2 = zzfax2.zzoti;
                    if (zzfav2 == null) {
                        zzfas3 = null;
                    } else {
                        zzfas zzfas4 = new zzfas();
                        zzfas4.zziy(zzfav2.zzota);
                        zzfas4.zzdd(zzfav2.zzotb);
                        zzfas4.zzcp(zzfav2.zzotc);
                        zzfas3 = zzfas2 = zzfas4;
                    }
                    if (zzfas3 != null) {
                        zzfas2.zzav(FirebaseRemoteConfig.zza(zzfax2.zzotj));
                    }
                    zzosa = new FirebaseRemoteConfig(context, zzfap2, zzfap3, zzfap4, zzfas2);
                }
            }
            return zzosa;
        }
        return zzosa;
    }

    private final long zzfi(Context context) {
        long l = 0L;
        try {
            l = this.mContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = context.getPackageName();
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    private static zzfax zzfj(Context context) {
        zzfax zzfax2;
        if (context == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("persisted_config");
            Object object = fileInputStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FirebaseRemoteConfig.zza((InputStream)object, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            object = byArray;
            zzflj zzflj2 = zzflj.zzo((byte[])byArray, (int)0, (int)((Object)object).length);
            zzfax2 = new zzfax();
            zzfax2.zza(zzflj2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return zzfax2;
    }

    private static Map<String, zzfam> zza(zzfay[] zzfayArray) {
        HashMap<String, zzfam> hashMap = new HashMap<String, zzfam>();
        if (zzfayArray == null) {
            return hashMap;
        }
        zzfay[] zzfayArray2 = zzfayArray;
        int n = zzfayArray.length;
        for (int i = 0; i < n; ++i) {
            zzfay zzfay2 = zzfayArray2[i];
            String string = zzfay2.zzkal;
            int n2 = zzfay2.resourceId;
            long l = zzfay2.zzotl;
            hashMap.put(string, new zzfam(n2, l));
        }
        return hashMap;
    }

    private static zzfap zza(zzfat zzfat2) {
        Object object;
        if (zzfat2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        Object object2 = zzfat2.zzosw;
        int n = zzfat2.zzosw.length;
        for (int i = 0; i < n; ++i) {
            zzfaw zzfaw2 = object2[i];
            String string = zzfaw2.zzkal;
            object = new HashMap();
            zzfau[] zzfauArray = zzfaw2.zzote;
            int n2 = zzfaw2.zzote.length;
            for (int j = 0; j < n2; ++j) {
                zzfau zzfau2 = zzfauArray[j];
                object.put(zzfau2.key, zzfau2.zzosz);
            }
            hashMap.put(string, (Map<String, byte[]>)object);
        }
        object2 = zzfat2.zzosx;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Object object3 = object2;
        int n3 = ((zzfaw[])object2).length;
        for (int i = 0; i < n3; ++i) {
            object = object3[i];
            arrayList.add((byte[])object);
        }
        return new zzfap(hashMap, zzfat2.timestamp, arrayList);
    }

    private static long zza(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public boolean activateFetched() {
        this.zzosf.writeLock().lock();
        try {
            if (this.zzosb == null) {
                return false;
            }
            if (this.zzosc != null && this.zzosc.getTimestamp() >= this.zzosb.getTimestamp()) {
                return false;
            }
            long l = this.zzosb.getTimestamp();
            this.zzosc = this.zzosb;
            this.zzosc.setTimestamp(System.currentTimeMillis());
            this.zzosb = new zzfap(null, l, null);
            long l2 = this.zzose.zzcnp();
            this.zzose.zzcp(zzdyx.zza(l2, this.zzosc.zzaol()));
            long l3 = l2;
            List<byte[]> list = this.zzosc.zzaol();
            Context context = this.mContext;
            FirebaseRemoteConfig.zzs(new zzfan(context, list, l3));
            this.zzcnj();
            return true;
        }
        finally {
            this.zzosf.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.zzosf.readLock().lock();
        try {
            if (this.zzose != null && this.zzose.zzcnn() != null && this.zzose.zzcnn().get(string) != null && n == ((zzfam)(object = this.zzose.zzcnn().get(string))).getResourceId() && this.zzose.zzcno() == ((zzfam)object).zzcnk()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.zzosf.readLock().unlock();
        }
        object = new HashMap();
        try {
            XmlResourceParser xmlResourceParser = this.mContext.getResources().getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            zzfam zzfam2 = new zzfam(n, this.zzose.zzcno());
            this.zzose.zza(string, zzfam2);
            this.zzc((Map<String, Object>)object, string, false);
            return;
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
            return;
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zzc(map, string, true);
    }

    private final void zzc(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(zzfar.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(zzfar.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(zzfar.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(zzfar.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(zzfar.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(zzfar.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.zzosf.writeLock().lock();
        try {
            if (bl2) {
                if (this.zzosd == null || !this.zzosd.zzsk(string)) {
                    return;
                }
                this.zzosd.zzi(null, string);
                this.zzosd.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.zzosd == null) {
                    this.zzosd = new zzfap(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis(), null);
                }
                this.zzosd.zzi(hashMap, string);
                this.zzosd.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.zzose.zzsl(string);
            }
            this.zzcnj();
            return;
        }
        finally {
            this.zzosf.writeLock().unlock();
        }
    }

    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.zzosf.writeLock().lock();
        try {
            boolean bl = this.zzose.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.zzose.zzdd(bl2);
            if (bl != bl2) {
                this.zzcnj();
            }
            return;
        }
        finally {
            this.zzosf.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.zzosf.readLock().lock();
        try {
            if (this.zzosc != null && this.zzosc.zzbl(string, string2)) {
                byte[] byArray = this.zzosc.zzbm(string, string2);
                return byArray;
            }
            if (this.zzosd != null && this.zzosd.zzbl(string, string2)) {
                byte[] byArray = this.zzosd.zzbm(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.zzosf.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    public String getString(String string, String string2) {
        block5: {
            if (string2 == null) {
                return DEFAULT_VALUE_FOR_STRING;
            }
            this.zzosf.readLock().lock();
            try {
                if (this.zzosc == null || !this.zzosc.zzbl(string, string2)) break block5;
                String string3 = new String(this.zzosc.zzbm(string, string2), zzfar.UTF_8);
                this.zzosf.readLock().unlock();
                return string3;
            }
            catch (Throwable throwable) {
                this.zzosf.readLock().unlock();
                throw throwable;
            }
        }
        if (this.zzosd != null && this.zzosd.zzbl(string, string2)) {
            String string4 = new String(this.zzosd.zzbm(string, string2), zzfar.UTF_8);
            this.zzosf.readLock().unlock();
            return string4;
        }
        String string5 = DEFAULT_VALUE_FOR_STRING;
        this.zzosf.readLock().unlock();
        return string5;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.zzosf.readLock().lock();
        try {
            String string3;
            if (this.zzosc != null && this.zzosc.zzbl(string, string2)) {
                string3 = new String(this.zzosc.zzbm(string, string2), zzfar.UTF_8);
                if (zzfar.zzgmb.matcher(string3).matches()) {
                    return true;
                }
                if (zzfar.zzgmc.matcher(string3).matches()) {
                    return false;
                }
            }
            if (this.zzosd != null && this.zzosd.zzbl(string, string2)) {
                string3 = new String(this.zzosd.zzbm(string, string2), zzfar.UTF_8);
                if (zzfar.zzgmb.matcher(string3).matches()) {
                    return true;
                }
                if (zzfar.zzgmc.matcher(string3).matches()) {
                    return false;
                }
            }
            return false;
        }
        finally {
            this.zzosf.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new zzfar(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.zzosf.readLock().lock();
        try {
            if (this.zzosc != null && this.zzosc.zzbl(string, string2)) {
                zzfar zzfar2 = new zzfar(this.zzosc.zzbm(string, string2), 2);
                return zzfar2;
            }
            if (this.zzosd != null && this.zzosd.zzbl(string, string2)) {
                zzfar zzfar3 = new zzfar(this.zzosd.zzbm(string, string2), 1);
                return zzfar3;
            }
            zzfar zzfar4 = new zzfar(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return zzfar4;
        }
        finally {
            this.zzosf.readLock().unlock();
        }
    }

    public FirebaseRemoteConfigInfo getInfo() {
        zzfaq zzfaq2 = new zzfaq();
        this.zzosf.readLock().lock();
        try {
            long l = this.zzosb == null ? -1L : this.zzosb.getTimestamp();
            zzfaq2.zzcn(l);
            zzfaq2.zziy(this.zzose.getLastFetchStatus());
            zzfaq2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.zzose.isDeveloperModeEnabled()).build());
        }
        finally {
            this.zzosf.readLock().unlock();
        }
        return zzfaq2;
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.getKeysByPrefix(string, "configns:firebase");
    }

    public Set<String> getKeysByPrefix(String string, String string2) {
        this.zzosf.readLock().lock();
        try {
            if (this.zzosc == null) {
                TreeSet<String> treeSet = new TreeSet<String>();
                return treeSet;
            }
            Set<String> set = this.zzosc.zzbn(string, string2);
            return set;
        }
        finally {
            this.zzosf.readLock().unlock();
        }
    }

    private static void zzs(Runnable runnable) {
        AsyncTask.SERIAL_EXECUTOR.execute(runnable);
    }

    private final void zzcnj() {
        this.zzosf.readLock().lock();
        try {
            FirebaseRemoteConfig.zzs(new zzfao(this.mContext, this.zzosb, this.zzosc, this.zzosd, this.zzose));
            return;
        }
        finally {
            this.zzosf.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    public Task<Void> fetch(long l) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzosf.readLock().lock();
        try {
            int n;
            long l2;
            long l3;
            zzbin zzbin2 = new zzbin();
            zzbin2.zzaa(l);
            if (this.zzose.isDeveloperModeEnabled()) {
                zzbin2.zzx("_rcn_developer", "true");
            }
            zzbin2.zzcj(10300);
            if (this.zzosc != null && this.zzosc.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzosc.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbin2.zzcl(n);
            }
            if (this.zzosb != null && this.zzosb.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzosb.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbin2.zzck(n);
            }
            zzbim zzbim2 = zzbin2.zzaok();
            zzbiz zzbiz2 = new zzbiz(this.mContext);
            zzbii.zzglu.zza(zzbiz2.zzahw(), zzbim2).setResultCallback((ResultCallback)new zza(this, taskCompletionSource));
        }
        finally {
            this.zzosf.readLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final void zza(TaskCompletionSource<Void> taskCompletionSource, zzbio zzbio2) {
        if (zzbio2 == null || zzbio2.getStatus() == null) {
            this.zzose.zziy(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.zzcnj();
            return;
        }
        int n = zzbio2.getStatus().getStatusCode();
        this.zzosf.writeLock().lock();
        try {
            switch (n) {
                case 6500: 
                case 6501: 
                case 6503: 
                case 6504: {
                    this.zzose.zziy(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzcnj();
                    return;
                }
                case 6502: 
                case 6507: {
                    this.zzose.zziy(2);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzbio2.getThrottleEndTimeMillis())));
                    this.zzcnj();
                    return;
                }
                case -6508: 
                case -6506: {
                    this.zzose.zziy(-1);
                    if (this.zzosb != null && !this.zzosb.zzcnm()) {
                        Map<String, Set<String>> map = zzbio2.zzaom();
                        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                        for (String string : map.keySet()) {
                            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                            for (String string2 : map.get(string)) {
                                hashMap2.put(string2, zzbio2.zza(string2, null, string));
                            }
                            hashMap.put(string, hashMap2);
                        }
                        this.zzosb = new zzfap(hashMap, this.zzosb.getTimestamp(), zzbio2.zzaol());
                    }
                    taskCompletionSource.setResult(null);
                    this.zzcnj();
                    return;
                }
                case -6505: {
                    Map<String, Set<String>> map = zzbio2.zzaom();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                        for (String string3 : map.get(string)) {
                            hashMap3.put(string3, zzbio2.zza(string3, null, string));
                        }
                        hashMap.put(string, hashMap3);
                    }
                    this.zzosb = new zzfap(hashMap, System.currentTimeMillis(), zzbio2.zzaol());
                    this.zzose.zziy(-1);
                    taskCompletionSource.setResult(null);
                    this.zzcnj();
                    return;
                }
                default: {
                    if (zzbio2.getStatus().isSuccess()) {
                        Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                    }
                    this.zzose.zziy(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzcnj();
                    return;
                }
            }
        }
        finally {
            this.zzosf.writeLock().unlock();
        }
    }
}

