/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzd;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbik;
import com.google.android.gms.internal.zzbim;
import com.google.android.gms.internal.zzbio;
import com.google.android.gms.internal.zzbit;
import com.google.android.gms.internal.zzbjb;
import com.google.android.gms.internal.zzbjh;
import com.google.android.gms.internal.zzbjn;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;

@Hide
public final class zzbis
implements zzbik {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern zzgmb = Pattern.compile("^(1|true|t|yes|y|on)$", 2);
    private static final Pattern zzgmc = Pattern.compile("^(0|false|f|no|n|off|)$", 2);

    @Override
    public final PendingResult<zzbio> zza(GoogleApiClient googleApiClient, zzbim zzbim2) {
        if (googleApiClient == null || zzbim2 == null) {
            return null;
        }
        return googleApiClient.zzd((zzm)new zzbit(this, googleApiClient, zzbim2));
    }

    private static Status zzcm(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 6500: {
                string = "NOT_AUTHORIZED_TO_FETCH";
                break;
            }
            case 6501: {
                string = "ANOTHER_FETCH_INFLIGHT";
                break;
            }
            case 6502: {
                string = "FETCH_THROTTLED";
                break;
            }
            case 6503: {
                string = "NOT_AVAILABLE";
                break;
            }
            case 6504: {
                string = "FAILURE_CACHE";
                break;
            }
            case -6505: {
                string = "SUCCESS_FRESH";
                break;
            }
            case -6506: {
                string = "SUCCESS_CACHE";
                break;
            }
            case 6507: {
                string = "FETCH_THROTTLED_STALE";
                break;
            }
            case -6508: {
                string = "SUCCESS_CACHE_STALE";
                break;
            }
            default: {
                string = CommonStatusCodes.getStatusCodeString((int)n2);
            }
        }
        return new Status(n, string);
    }

    private static HashMap<String, TreeMap<String, byte[]>> zza(zzbjh zzbjh2) {
        if (zzbjh2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbjh2.zzaon();
        if (dataHolder == null) {
            return null;
        }
        zzbjn zzbjn2 = (zzbjn)((Object)new zzd(dataHolder, zzbjn.CREATOR).get(0));
        zzbjh2.zzaop();
        HashMap<String, TreeMap<String, byte[]>> hashMap = new HashMap<String, TreeMap<String, byte[]>>();
        for (String string : zzbjn2.zzaor().keySet()) {
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            hashMap.put(string, treeMap);
            Bundle bundle = zzbjn2.zzaor().getBundle(string);
            for (String string2 : bundle.keySet()) {
                treeMap.put(string2, bundle.getByteArray(string2));
            }
        }
        return hashMap;
    }

    @Nullable
    static List<byte[]> zzb(@Nullable zzbjh zzbjh2) {
        if (zzbjh2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbjh2.zzaoo();
        if (dataHolder == null) {
            return null;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Iterator iterator = new zzd(dataHolder, zzbjb.CREATOR).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((zzbjb)((Object)iterator.next())).getPayload());
        }
        zzbjh2.zzaoq();
        return arrayList;
    }

    static /* synthetic */ Status zzcn(int n) {
        return zzbis.zzcm(n);
    }

    static /* synthetic */ HashMap zzc(zzbjh zzbjh2) {
        return zzbis.zza(zzbjh2);
    }
}

