/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.heartbeatinfo;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.Lazy;
import com.google.firebase.heartbeatinfo.DefaultHeartBeatInfo$$Lambda$1;
import com.google.firebase.heartbeatinfo.DefaultHeartBeatInfo$$Lambda$2;
import com.google.firebase.heartbeatinfo.DefaultHeartBeatInfo$$Lambda$3;
import com.google.firebase.heartbeatinfo.DefaultHeartBeatInfo$$Lambda$4;
import com.google.firebase.heartbeatinfo.DefaultHeartBeatInfo$$Lambda$5;
import com.google.firebase.heartbeatinfo.HeartBeatConsumer;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.heartbeatinfo.HeartBeatInfoStorage;
import com.google.firebase.heartbeatinfo.HeartBeatResult;
import com.google.firebase.heartbeatinfo.SdkHeartBeatResult;
import com.google.firebase.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultHeartBeatInfo
implements HeartBeatInfo {
    private Provider<HeartBeatInfoStorage> storageProvider;
    private final Set<HeartBeatConsumer> consumers;
    private final Executor backgroundExecutor;
    private static final ThreadFactory THREAD_FACTORY = DefaultHeartBeatInfo$$Lambda$5.lambdaFactory$();

    private DefaultHeartBeatInfo(Context context, Set<HeartBeatConsumer> consumers) {
        this((Provider<HeartBeatInfoStorage>)new Lazy(DefaultHeartBeatInfo$$Lambda$1.lambdaFactory$(context)), consumers, new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), THREAD_FACTORY));
    }

    @VisibleForTesting
    DefaultHeartBeatInfo(Provider<HeartBeatInfoStorage> testStorage, Set<HeartBeatConsumer> consumers, Executor executor) {
        this.storageProvider = testStorage;
        this.consumers = consumers;
        this.backgroundExecutor = executor;
    }

    @Override
    @NonNull
    public HeartBeatInfo.HeartBeat getHeartBeatCode(@NonNull String heartBeatTag) {
        long presentTime = System.currentTimeMillis();
        boolean shouldSendSdkHB = ((HeartBeatInfoStorage)this.storageProvider.get()).shouldSendSdkHeartBeat(heartBeatTag, presentTime);
        boolean shouldSendGlobalHB = ((HeartBeatInfoStorage)this.storageProvider.get()).shouldSendGlobalHeartBeat(presentTime);
        if (shouldSendSdkHB && shouldSendGlobalHB) {
            return HeartBeatInfo.HeartBeat.COMBINED;
        }
        if (shouldSendGlobalHB) {
            return HeartBeatInfo.HeartBeat.GLOBAL;
        }
        if (shouldSendSdkHB) {
            return HeartBeatInfo.HeartBeat.SDK;
        }
        return HeartBeatInfo.HeartBeat.NONE;
    }

    @Override
    public Task<List<HeartBeatResult>> getAndClearStoredHeartBeatInfo() {
        return Tasks.call((Executor)this.backgroundExecutor, (Callable)DefaultHeartBeatInfo$$Lambda$2.lambdaFactory$(this));
    }

    @Override
    public Task<Void> storeHeartBeatInfo(@NonNull String heartBeatTag) {
        if (this.consumers.size() <= 0) {
            return Tasks.forResult(null);
        }
        return Tasks.call((Executor)this.backgroundExecutor, (Callable)DefaultHeartBeatInfo$$Lambda$3.lambdaFactory$(this, heartBeatTag));
    }

    @NonNull
    public static Component<HeartBeatInfo> component() {
        return Component.builder(HeartBeatInfo.class).add(Dependency.required(Context.class)).add(Dependency.setOf(HeartBeatConsumer.class)).factory(DefaultHeartBeatInfo$$Lambda$4.lambdaFactory$()).build();
    }

    static /* synthetic */ HeartBeatInfo lambda$component$4(ComponentContainer c) {
        return new DefaultHeartBeatInfo((Context)c.get(Context.class), c.setOf(HeartBeatConsumer.class));
    }

    static /* synthetic */ Void lambda$storeHeartBeatInfo$3(DefaultHeartBeatInfo this_, String heartBeatTag) throws Exception {
        long presentTime = System.currentTimeMillis();
        boolean shouldSendSdkHB = ((HeartBeatInfoStorage)this_.storageProvider.get()).shouldSendSdkHeartBeat(heartBeatTag, presentTime);
        if (shouldSendSdkHB) {
            ((HeartBeatInfoStorage)this_.storageProvider.get()).storeHeartBeatInformation(heartBeatTag, presentTime);
        }
        return null;
    }

    static /* synthetic */ List lambda$getAndClearStoredHeartBeatInfo$2(DefaultHeartBeatInfo this_) throws Exception {
        ArrayList<HeartBeatResult> heartBeatResults = new ArrayList<HeartBeatResult>();
        boolean shouldSendGlobalHeartBeat = false;
        HeartBeatInfoStorage storage = (HeartBeatInfoStorage)this_.storageProvider.get();
        List<SdkHeartBeatResult> sdkHeartBeatResults = storage.getStoredHeartBeats(true);
        long lastGlobalHeartBeat = storage.getLastGlobalHeartBeat();
        for (SdkHeartBeatResult sdkHeartBeatResult : sdkHeartBeatResults) {
            shouldSendGlobalHeartBeat = HeartBeatInfoStorage.isSameDateUtc(lastGlobalHeartBeat, sdkHeartBeatResult.getMillis());
            HeartBeatInfo.HeartBeat heartBeat = shouldSendGlobalHeartBeat ? HeartBeatInfo.HeartBeat.COMBINED : HeartBeatInfo.HeartBeat.SDK;
            if (shouldSendGlobalHeartBeat) {
                lastGlobalHeartBeat = sdkHeartBeatResult.getMillis();
            }
            heartBeatResults.add(HeartBeatResult.create(sdkHeartBeatResult.getSdkName(), sdkHeartBeatResult.getMillis(), heartBeat));
        }
        if (lastGlobalHeartBeat > 0L) {
            storage.updateGlobalHeartBeat(lastGlobalHeartBeat);
        }
        return heartBeatResults;
    }

    static /* synthetic */ HeartBeatInfoStorage lambda$new$1(Context context) {
        return HeartBeatInfoStorage.getInstance(context);
    }

    static /* synthetic */ Thread lambda$static$0(Runnable r) {
        return new Thread(r, "heartbeat-information-executor");
    }
}

