/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import androidx.annotation.GuardedBy;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.components.EventBus$$Lambda$1;
import com.google.firebase.events.Event;
import com.google.firebase.events.EventHandler;
import com.google.firebase.events.Publisher;
import com.google.firebase.events.Subscriber;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

class EventBus
implements Subscriber,
Publisher {
    @GuardedBy(value="this")
    private final Map<Class<?>, ConcurrentHashMap<EventHandler<Object>, Executor>> handlerMap = new HashMap();
    @GuardedBy(value="this")
    private Queue<Event<?>> pendingEvents = new ArrayDeque();
    private final Executor defaultExecutor;

    EventBus(Executor defaultExecutor) {
        this.defaultExecutor = defaultExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(Event<?> event) {
        Preconditions.checkNotNull(event);
        EventBus eventBus = this;
        synchronized (eventBus) {
            if (this.pendingEvents != null) {
                this.pendingEvents.add(event);
                return;
            }
        }
        for (Map.Entry entry : this.getHandlers(event)) {
            Event<?> casted = event;
            ((Executor)entry.getValue()).execute(EventBus$$Lambda$1.lambdaFactory$(entry, casted));
        }
    }

    private synchronized Set<Map.Entry<EventHandler<Object>, Executor>> getHandlers(Event<?> event) {
        Map handlers = this.handlerMap.get(event.getType());
        return handlers == null ? Collections.emptySet() : handlers.entrySet();
    }

    @Override
    public synchronized <T> void subscribe(Class<T> type, Executor executor, EventHandler<? super T> handler) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(handler);
        Preconditions.checkNotNull((Object)executor);
        if (!this.handlerMap.containsKey(type)) {
            this.handlerMap.put(type, new ConcurrentHashMap());
        }
        EventHandler<? super T> casted = handler;
        this.handlerMap.get(type).put(casted, executor);
    }

    @Override
    public <T> void subscribe(Class<T> type, EventHandler<? super T> handler) {
        this.subscribe(type, this.defaultExecutor, handler);
    }

    @Override
    public synchronized <T> void unsubscribe(Class<T> type, EventHandler<? super T> handler) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(handler);
        if (!this.handlerMap.containsKey(type)) {
            return;
        }
        ConcurrentHashMap<EventHandler<Object>, Executor> handlers = this.handlerMap.get(type);
        EventHandler<? super T> casted = handler;
        handlers.remove(casted);
        if (handlers.isEmpty()) {
            this.handlerMap.remove(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enablePublishingAndFlushPending() {
        Queue<Event<?>> pending = null;
        EventBus eventBus = this;
        synchronized (eventBus) {
            if (this.pendingEvents != null) {
                pending = this.pendingEvents;
                this.pendingEvents = null;
            }
        }
        if (pending != null) {
            for (Event event : pending) {
                this.publish(event);
            }
        }
    }

    static /* synthetic */ void lambda$publish$0(Map.Entry handlerData, Event casted) {
        ((EventHandler)handlerData.getKey()).handle(casted);
    }
}

