/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.events.Event;
import com.google.firebase.events.Publisher;
import java.util.concurrent.atomic.AtomicBoolean;

public class DataCollectionConfigStorage {
    private static final String FIREBASE_APP_PREFS = "com.google.firebase.common.prefs:";
    @VisibleForTesting
    public static final String DATA_COLLECTION_DEFAULT_ENABLED = "firebase_data_collection_default_enabled";
    private final Context applicationContext;
    private final SharedPreferences sharedPreferences;
    private final Publisher publisher;
    private final AtomicBoolean dataCollectionDefaultEnabled;

    public DataCollectionConfigStorage(Context applicationContext, String persistenceKey, Publisher publisher) {
        this.applicationContext = DataCollectionConfigStorage.directBootSafe(applicationContext);
        this.sharedPreferences = applicationContext.getSharedPreferences(FIREBASE_APP_PREFS + persistenceKey, 0);
        this.publisher = publisher;
        this.dataCollectionDefaultEnabled = new AtomicBoolean(this.readAutoDataCollectionEnabled());
    }

    private static Context directBootSafe(Context applicationContext) {
        if (Build.VERSION.SDK_INT < 24 || ContextCompat.isDeviceProtectedStorage((Context)applicationContext)) {
            return applicationContext;
        }
        return ContextCompat.createDeviceProtectedStorageContext((Context)applicationContext);
    }

    public boolean isEnabled() {
        return this.dataCollectionDefaultEnabled.get();
    }

    public void setEnabled(boolean enabled) {
        if (this.dataCollectionDefaultEnabled.compareAndSet(!enabled, enabled)) {
            this.sharedPreferences.edit().putBoolean(DATA_COLLECTION_DEFAULT_ENABLED, enabled).apply();
            this.publisher.publish(new Event<DataCollectionDefaultChange>(DataCollectionDefaultChange.class, new DataCollectionDefaultChange(enabled)));
        }
    }

    private boolean readAutoDataCollectionEnabled() {
        if (this.sharedPreferences.contains(DATA_COLLECTION_DEFAULT_ENABLED)) {
            return this.sharedPreferences.getBoolean(DATA_COLLECTION_DEFAULT_ENABLED, true);
        }
        try {
            ApplicationInfo applicationInfo;
            PackageManager packageManager = this.applicationContext.getPackageManager();
            if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(this.applicationContext.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey(DATA_COLLECTION_DEFAULT_ENABLED)) {
                return applicationInfo.metaData.getBoolean(DATA_COLLECTION_DEFAULT_ENABLED);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return true;
    }
}

