/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import com.google.firebase.components.Component;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.DependencyCycleException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ComponentSorter {
    ComponentSorter() {
    }

    static List<Component<?>> sorted(List<Component<?>> components) {
        Set<ComponentNode> graph = ComponentSorter.toGraph(components);
        Set<ComponentNode> roots = ComponentSorter.getRoots(graph);
        ArrayList result = new ArrayList();
        while (!roots.isEmpty()) {
            ComponentNode node = roots.iterator().next();
            roots.remove(node);
            result.add(node.getComponent());
            for (ComponentNode dependent : node.getDependencies()) {
                dependent.removeDependent(node);
                if (!dependent.isRoot()) continue;
                roots.add(dependent);
            }
        }
        if (result.size() == components.size()) {
            Collections.reverse(result);
            return result;
        }
        ArrayList componentsInCycle = new ArrayList();
        for (ComponentNode node : graph) {
            if (node.isRoot() || node.isLeaf()) continue;
            componentsInCycle.add(node.getComponent());
        }
        throw new DependencyCycleException(componentsInCycle);
    }

    private static Set<ComponentNode> toGraph(List<Component<?>> components) {
        HashMap componentIndex = new HashMap(components.size());
        for (Component<?> component : components) {
            ComponentNode node = new ComponentNode(component);
            for (Class<?> anInterface : component.getProvidedInterfaces()) {
                if (componentIndex.put(anInterface, node) == null) continue;
                throw new IllegalArgumentException(String.format("Multiple components provide %s.", anInterface));
            }
        }
        for (ComponentNode componentNode : componentIndex.values()) {
            for (Dependency dependency : componentNode.getComponent().getDependencies()) {
                ComponentNode depComponent;
                if (!dependency.isDirectInjection() || (depComponent = (ComponentNode)componentIndex.get(dependency.getInterface())) == null) continue;
                componentNode.addDependency(depComponent);
                depComponent.addDependent(componentNode);
            }
        }
        return new HashSet<ComponentNode>(componentIndex.values());
    }

    private static Set<ComponentNode> getRoots(Set<ComponentNode> components) {
        HashSet<ComponentNode> roots = new HashSet<ComponentNode>();
        for (ComponentNode component : components) {
            if (!component.isRoot()) continue;
            roots.add(component);
        }
        return roots;
    }

    private static class ComponentNode {
        private final Component<?> component;
        private final Set<ComponentNode> dependencies = new HashSet<ComponentNode>();
        private final Set<ComponentNode> dependents = new HashSet<ComponentNode>();

        ComponentNode(Component<?> component) {
            this.component = component;
        }

        void addDependency(ComponentNode node) {
            this.dependencies.add(node);
        }

        void addDependent(ComponentNode node) {
            this.dependents.add(node);
        }

        Set<ComponentNode> getDependencies() {
            return this.dependencies;
        }

        void removeDependent(ComponentNode node) {
            this.dependents.remove(node);
        }

        Component<?> getComponent() {
            return this.component;
        }

        boolean isRoot() {
            return this.dependents.isEmpty();
        }

        boolean isLeaf() {
            return this.dependencies.isEmpty();
        }
    }
}

