/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzam;
import com.google.android.gms.common.util.zzw;

public final class FirebaseOptions {
    private final String zzbWQ;
    private final String zzamX;
    private final String zzbWR;
    private final String zzbWS;
    private final String zzbWT;
    private final String zzbWU;

    private FirebaseOptions(@NonNull String string, @NonNull String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6) {
        zzac.zza((!zzw.zzdz((String)string) ? 1 : 0) != 0, (Object)"ApplicationId must be set.");
        this.zzamX = string;
        this.zzbWQ = string2;
        this.zzbWR = string3;
        this.zzbWS = string4;
        this.zzbWT = string5;
        this.zzbWU = string6;
    }

    public static FirebaseOptions fromResource(Context context) {
        zzam zzam2 = new zzam(context);
        String string = zzam2.getString("google_app_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return new FirebaseOptions(string, zzam2.getString("google_api_key"), zzam2.getString("firebase_database_url"), zzam2.getString("ga_trackingId"), zzam2.getString("gcm_defaultSenderId"), zzam2.getString("google_storage_bucket"));
    }

    public String getApiKey() {
        return this.zzbWQ;
    }

    public String getApplicationId() {
        return this.zzamX;
    }

    public String getDatabaseUrl() {
        return this.zzbWR;
    }

    public String getGcmSenderId() {
        return this.zzbWT;
    }

    public String getStorageBucket() {
        return this.zzbWU;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseOptions)) {
            return false;
        }
        FirebaseOptions firebaseOptions = (FirebaseOptions)object;
        return zzaa.equal((Object)this.zzamX, (Object)firebaseOptions.zzamX) && zzaa.equal((Object)this.zzbWQ, (Object)firebaseOptions.zzbWQ) && zzaa.equal((Object)this.zzbWR, (Object)firebaseOptions.zzbWR) && zzaa.equal((Object)this.zzbWS, (Object)firebaseOptions.zzbWS) && zzaa.equal((Object)this.zzbWT, (Object)firebaseOptions.zzbWT) && zzaa.equal((Object)this.zzbWU, (Object)firebaseOptions.zzbWU);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzamX, this.zzbWQ, this.zzbWR, this.zzbWS, this.zzbWT, this.zzbWU});
    }

    public String toString() {
        return zzaa.zzv((Object)this).zzg("applicationId", (Object)this.zzamX).zzg("apiKey", (Object)this.zzbWQ).zzg("databaseUrl", (Object)this.zzbWR).zzg("gcmSenderId", (Object)this.zzbWT).zzg("storageBucket", (Object)this.zzbWU).toString();
    }

    public static final class Builder {
        private String zzbWQ;
        private String zzamX;
        private String zzbWR;
        private String zzbWS;
        private String zzbWT;
        private String zzbWU;

        public Builder() {
        }

        public Builder(FirebaseOptions firebaseOptions) {
            this.zzamX = firebaseOptions.zzamX;
            this.zzbWQ = firebaseOptions.zzbWQ;
            this.zzbWR = firebaseOptions.zzbWR;
            this.zzbWS = firebaseOptions.zzbWS;
            this.zzbWT = firebaseOptions.zzbWT;
            this.zzbWU = firebaseOptions.zzbWU;
        }

        public Builder setApiKey(@NonNull String string) {
            this.zzbWQ = zzac.zzh((String)string, (Object)"ApiKey must be set.");
            return this;
        }

        public Builder setApplicationId(@NonNull String string) {
            this.zzamX = zzac.zzh((String)string, (Object)"ApplicationId must be set.");
            return this;
        }

        public Builder setDatabaseUrl(@Nullable String string) {
            this.zzbWR = string;
            return this;
        }

        public Builder setGcmSenderId(@Nullable String string) {
            this.zzbWT = string;
            return this;
        }

        public Builder setStorageBucket(@Nullable String string) {
            this.zzbWU = string;
            return this;
        }

        public FirebaseOptions build() {
            return new FirebaseOptions(this.zzamX, this.zzbWQ, this.zzbWR, this.zzbWS, this.zzbWT, this.zzbWU);
        }
    }
}

