/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.firebase-auth-api.zzage;
import com.google.android.gms.internal.firebase-auth-api.zzagr;
import com.google.android.gms.internal.firebase-auth-api.zzzh;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.internal.zzac;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="DefaultAuthUserInfoCreator")
public final class zzz
extends AbstractSafeParcelable
implements UserInfo {
    public static final Parcelable.Creator<zzz> CREATOR = new zzac();
    @SafeParcelable.Field(id=1, getter="getUid")
    @NonNull
    private String zza;
    @SafeParcelable.Field(id=2, getter="getProviderId")
    @NonNull
    private String zzb;
    @SafeParcelable.Field(id=3, getter="getDisplayName")
    @Nullable
    private String zzc;
    @SafeParcelable.Field(id=4, getter="getPhotoUrlString")
    @Nullable
    private String zzd;
    @Nullable
    private Uri zze;
    @SafeParcelable.Field(id=5, getter="getEmail")
    @Nullable
    private String zzf;
    @SafeParcelable.Field(id=6, getter="getPhoneNumber")
    @Nullable
    private String zzg;
    @SafeParcelable.Field(id=7, getter="isEmailVerified")
    private boolean zzh;
    @SafeParcelable.Field(id=8, getter="getRawUserInfo")
    @Nullable
    private String zzi;

    @Override
    @Nullable
    public final Uri getPhotoUrl() {
        if (!TextUtils.isEmpty((CharSequence)this.zzd) && this.zze == null) {
            this.zze = Uri.parse((String)this.zzd);
        }
        return this.zze;
    }

    @Nullable
    public static zzz zza(@NonNull String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string2 = jSONObject.optString("userId");
            String string3 = jSONObject.optString("providerId");
            String string4 = jSONObject.optString("email");
            String string5 = jSONObject.optString("phoneNumber");
            String string6 = jSONObject.optString("displayName");
            String string7 = jSONObject.optString("photoUrl");
            boolean bl = jSONObject.optBoolean("isEmailVerified");
            String string8 = jSONObject.optString("rawUserInfo");
            return new zzz(string2, string3, string4, string5, string6, string7, bl, string8);
        }
        catch (JSONException jSONException) {
            Log.d((String)"DefaultAuthUserInfo", (String)"Failed to unpack UserInfo from JSON");
            throw new zzzh(jSONException);
        }
    }

    @Override
    @Nullable
    public final String getDisplayName() {
        return this.zzc;
    }

    @Override
    @Nullable
    public final String getEmail() {
        return this.zzf;
    }

    @Override
    @Nullable
    public final String getPhoneNumber() {
        return this.zzg;
    }

    @Override
    @NonNull
    public final String getProviderId() {
        return this.zzb;
    }

    @Nullable
    public final String zza() {
        return this.zzi;
    }

    @Override
    @NonNull
    public final String getUid() {
        return this.zza;
    }

    @Nullable
    public final String zzb() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.putOpt("userId", (Object)this.zza);
            jSONObject.putOpt("providerId", (Object)this.zzb);
            jSONObject.putOpt("displayName", (Object)this.zzc);
            jSONObject.putOpt("photoUrl", (Object)this.zzd);
            jSONObject.putOpt("email", (Object)this.zzf);
            jSONObject.putOpt("phoneNumber", (Object)this.zzg);
            jSONObject.putOpt("isEmailVerified", (Object)this.zzh);
            jSONObject.putOpt("rawUserInfo", (Object)this.zzi);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            Log.d((String)"DefaultAuthUserInfo", (String)"Failed to jsonify this object");
            throw new zzzh(jSONException);
        }
    }

    public zzz(zzagr zzagr2) {
        Preconditions.checkNotNull((Object)zzagr2);
        this.zza = zzagr2.zzd();
        this.zzb = Preconditions.checkNotEmpty((String)zzagr2.zzf());
        this.zzc = zzagr2.zzb();
        Uri uri = zzagr2.zza();
        if (uri != null) {
            this.zzd = uri.toString();
            this.zze = uri;
        }
        this.zzf = zzagr2.zzc();
        this.zzg = zzagr2.zze();
        this.zzh = false;
        this.zzi = zzagr2.zzg();
    }

    public zzz(zzage zzage2, String string) {
        Preconditions.checkNotNull((Object)zzage2);
        Preconditions.checkNotEmpty((String)string);
        this.zza = Preconditions.checkNotEmpty((String)zzage2.zzi());
        this.zzb = string;
        this.zzf = zzage2.zzh();
        this.zzc = zzage2.zzg();
        Uri uri = zzage2.zzc();
        if (uri != null) {
            this.zzd = uri.toString();
            this.zze = uri;
        }
        this.zzh = zzage2.zzm();
        this.zzi = null;
        this.zzg = zzage2.zzj();
    }

    @SafeParcelable.Constructor
    public zzz(@SafeParcelable.Param(id=1) @NonNull String string, @SafeParcelable.Param(id=2) @NonNull String string2, @SafeParcelable.Param(id=5) @Nullable String string3, @SafeParcelable.Param(id=4) @Nullable String string4, @SafeParcelable.Param(id=3) @Nullable String string5, @SafeParcelable.Param(id=6) @Nullable String string6, @SafeParcelable.Param(id=7) boolean bl, @SafeParcelable.Param(id=8) @Nullable String string7) {
        this.zza = string;
        this.zzb = string2;
        this.zzf = string3;
        this.zzg = string4;
        this.zzc = string5;
        this.zzd = string6;
        if (!TextUtils.isEmpty((CharSequence)this.zzd)) {
            this.zze = Uri.parse((String)this.zzd);
        }
        this.zzh = bl;
        this.zzi = string7;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzz zzz2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)zzz2.getUid(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzz2.getProviderId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzz2.getDisplayName(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)zzz2.zzd, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)zzz2.getEmail(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)zzz2.getPhoneNumber(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)7, (boolean)zzz2.isEmailVerified());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)zzz2.zzi, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Override
    public final boolean isEmailVerified() {
        return this.zzh;
    }
}

