/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.firebase-auth-api.zzadg;
import com.google.android.gms.internal.firebase-auth-api.zzahr;
import com.google.android.gms.internal.firebase-auth-api.zzal;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.zze;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;

public final class zzbm {
    @VisibleForTesting
    private static long zza = 3600000L;
    private static final zzal<String> zzb = zzal.zza("firebaseAppName", "firebaseUserUid", "operation", "tenantId", "verifyAssertionRequest", "statusCode", "statusMessage", "timestamp");
    private static final zzbm zzc = new zzbm();
    private Task<AuthResult> zzd;
    private Task<String> zze;
    private long zzf = 0L;

    @Nullable
    public final Task<AuthResult> zza() {
        if (DefaultClock.getInstance().currentTimeMillis() - this.zzf < zza) {
            return this.zzd;
        }
        return null;
    }

    @Nullable
    public final Task<String> zzb() {
        if (DefaultClock.getInstance().currentTimeMillis() - this.zzf < zza) {
            return this.zze;
        }
        return null;
    }

    public static zzbm zzc() {
        return zzc;
    }

    private zzbm() {
    }

    private static void zza(SharedPreferences sharedPreferences) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        zzal<String> zzal2 = zzb;
        int n = zzal2.size();
        for (int i = 0; i < n; ++i) {
            Object e = zzal2.get(i);
            String string = (String)e;
            editor.remove(string);
        }
        editor.commit();
    }

    public final void zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        zzbm.zza(context.getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0));
        this.zzd = null;
        this.zzf = 0L;
    }

    public final void zza(@UnknownInitialization FirebaseAuth firebaseAuth) {
        Preconditions.checkNotNull((Object)firebaseAuth);
        SharedPreferences sharedPreferences = firebaseAuth.getApp().getApplicationContext().getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0);
        String string = sharedPreferences.getString("firebaseAppName", "");
        if (!firebaseAuth.getApp().getName().equals(string)) {
            return;
        }
        if (sharedPreferences.contains("verifyAssertionRequest")) {
            zzahr zzahr2 = (zzahr)SafeParcelableSerializer.deserializeFromString((String)sharedPreferences.getString("verifyAssertionRequest", ""), zzahr.CREATOR);
            String string2 = sharedPreferences.getString("operation", "");
            String string3 = sharedPreferences.getString("tenantId", null);
            String string4 = sharedPreferences.getString("firebaseUserUid", "");
            this.zzf = sharedPreferences.getLong("timestamp", 0L);
            if (string3 != null) {
                firebaseAuth.setTenantId(string3);
                zzahr2.zzb(string3);
            }
            switch (string2) {
                case "com.google.firebase.auth.internal.NONGMSCORE_SIGN_IN": {
                    this.zzd = firebaseAuth.signInWithCredential(com.google.firebase.auth.zze.zza(zzahr2));
                    break;
                }
                case "com.google.firebase.auth.internal.NONGMSCORE_LINK": {
                    if (firebaseAuth.getCurrentUser().getUid().equals(string4)) {
                        this.zzd = firebaseAuth.zza(firebaseAuth.getCurrentUser(), com.google.firebase.auth.zze.zza(zzahr2));
                        break;
                    }
                    this.zzd = null;
                    break;
                }
                case "com.google.firebase.auth.internal.NONGMSCORE_REAUTHENTICATE": {
                    if (firebaseAuth.getCurrentUser().getUid().equals(string4)) {
                        this.zzd = firebaseAuth.zzc(firebaseAuth.getCurrentUser(), com.google.firebase.auth.zze.zza(zzahr2));
                        break;
                    }
                    this.zzd = null;
                    break;
                }
                default: {
                    this.zzd = null;
                }
            }
            zzbm.zza(sharedPreferences);
            return;
        }
        if (sharedPreferences.contains("recaptchaToken")) {
            String string5 = sharedPreferences.getString("recaptchaToken", "");
            String string6 = sharedPreferences.getString("operation", "");
            this.zzf = sharedPreferences.getLong("timestamp", 0L);
            switch (string6) {
                case "com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA": {
                    this.zze = Tasks.forResult((Object)string5);
                    break;
                }
                default: {
                    this.zze = null;
                }
            }
            zzbm.zza(sharedPreferences);
            return;
        }
        if (sharedPreferences.contains("statusCode")) {
            int n = sharedPreferences.getInt("statusCode", 17062);
            String string7 = sharedPreferences.getString("statusMessage", "");
            Status status = new Status(n, string7);
            this.zzf = sharedPreferences.getLong("timestamp", 0L);
            zzbm.zza(sharedPreferences);
            this.zzd = Tasks.forException((Exception)zzadg.zza(status));
            return;
        }
    }

    public static void zza(Context context, Status status) {
        SharedPreferences.Editor editor = context.getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0).edit();
        editor.putInt("statusCode", status.getStatusCode());
        editor.putString("statusMessage", status.getStatusMessage());
        editor.putLong("timestamp", DefaultClock.getInstance().currentTimeMillis());
        editor.commit();
    }

    public static void zza(Context context, FirebaseAuth firebaseAuth) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)firebaseAuth);
        SharedPreferences.Editor editor = context.getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0).edit();
        editor.putString("firebaseAppName", firebaseAuth.getApp().getName());
        editor.commit();
    }

    public static void zza(Context context, FirebaseAuth firebaseAuth, FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)firebaseAuth);
        Preconditions.checkNotNull((Object)firebaseUser);
        SharedPreferences.Editor editor = context.getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0).edit();
        editor.putString("firebaseAppName", firebaseAuth.getApp().getName());
        editor.putString("firebaseUserUid", firebaseUser.getUid());
        editor.commit();
    }

    public static void zza(Context context, zzahr zzahr2, String string, @Nullable String string2) {
        SharedPreferences.Editor editor = context.getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0).edit();
        editor.putString("verifyAssertionRequest", SafeParcelableSerializer.serializeToString((SafeParcelable)zzahr2));
        editor.putString("operation", string);
        editor.putString("tenantId", string2);
        editor.putLong("timestamp", DefaultClock.getInstance().currentTimeMillis());
        editor.commit();
    }

    public static void zza(Context context, String string, String string2) {
        SharedPreferences.Editor editor = context.getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0).edit();
        editor.putString("recaptchaToken", string);
        editor.putString("operation", string2);
        editor.putLong("timestamp", DefaultClock.getInstance().currentTimeMillis());
        editor.commit();
    }
}

