/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.internal.firebase-auth-api.zzx;
import com.google.android.gms.internal.firebase-auth-api.zzzh;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class zzbj {
    private static final Logger zza = new Logger("JSONParser", new String[0]);

    @VisibleForTesting
    private static List<Object> zza(JSONArray jSONArray) throws JSONException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            List<Object> list = jSONArray.get(i);
            if (list instanceof JSONArray) {
                list = zzbj.zza((JSONArray)list);
            } else if (list instanceof JSONObject) {
                list = zzbj.zza((JSONObject)list);
            }
            arrayList.add(list);
        }
        return arrayList;
    }

    @NonNull
    public static Map<String, Object> zza(String string) {
        Preconditions.checkNotEmpty((String)string);
        List<String> list = zzx.zza('.').zza(string);
        if (list.size() < 2) {
            String string2 = string;
            zza.e("Invalid idToken " + string2, new Object[0]);
            return new HashMap<String, Object>();
        }
        String string3 = list.get(1);
        try {
            Map<String, Object> map = zzbj.zzb(new String(Base64Utils.decodeUrlSafeNoPadding((String)string3), "UTF-8"));
            if (map == null) {
                return new HashMap<String, Object>();
            }
            return map;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            zza.e("Unable to decode token", (Throwable)unsupportedEncodingException, new Object[0]);
            return new HashMap<String, Object>();
        }
    }

    @Nullable
    public static Map<String, Object> zzb(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject != JSONObject.NULL) {
                return zzbj.zza(jSONObject);
            }
            return null;
        }
        catch (Exception exception) {
            Log.d((String)"JSONParser", (String)"Failed to parse JSONObject into Map.");
            throw new zzzh(exception);
        }
    }

    @VisibleForTesting
    private static Map<String, Object> zza(JSONObject jSONObject) throws JSONException {
        ArrayMap arrayMap = new ArrayMap();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List<Object> list = jSONObject.get(string);
            if (list instanceof JSONArray) {
                list = zzbj.zza((JSONArray)list);
            } else if (list instanceof JSONObject) {
                list = zzbj.zza((JSONObject)list);
            }
            arrayMap.put(string, list);
        }
        return arrayMap;
    }
}

