/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.firebase-auth-api.zzagl;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.FirebaseUserMetadata;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.MultiFactor;
import com.google.firebase.auth.MultiFactorInfo;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.internal.zzaf;
import com.google.firebase.auth.internal.zzag;
import com.google.firebase.auth.internal.zzah;
import com.google.firebase.auth.internal.zzbg;
import com.google.firebase.auth.internal.zzbl;
import com.google.firebase.auth.internal.zzz;
import com.google.firebase.auth.zzan;
import com.google.firebase.auth.zze;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@SafeParcelable.Class(creator="DefaultFirebaseUserCreator")
public class zzad
extends FirebaseUser {
    public static final Parcelable.Creator<zzad> CREATOR = new zzag();
    @SafeParcelable.Field(id=1, getter="getCachedTokenState")
    private zzagl zza;
    @SafeParcelable.Field(id=2, getter="getDefaultAuthUserInfo")
    private zzz zzb;
    @SafeParcelable.Field(id=3, getter="getFirebaseAppName")
    private String zzc;
    @SafeParcelable.Field(id=4, getter="getUserType")
    private String zzd;
    @SafeParcelable.Field(id=5, getter="getUserInfos")
    private List<zzz> zze;
    @SafeParcelable.Field(id=6, getter="getProviders")
    private List<String> zzf;
    @SafeParcelable.Field(id=7, getter="getCurrentVersion")
    private String zzg;
    @SafeParcelable.Field(id=8, getter="isAnonymous")
    private Boolean zzh;
    @SafeParcelable.Field(id=9, getter="getMetadata")
    private zzaf zzi;
    @SafeParcelable.Field(id=10, getter="isNewUser")
    private boolean zzj;
    @SafeParcelable.Field(id=11, getter="getDefaultOAuthCredential")
    private zze zzk;
    @SafeParcelable.Field(id=12, getter="getMultiFactorInfoList")
    private zzbl zzl;
    @SafeParcelable.Field(id=13, getter="getEnrolledPasskeys")
    private List<zzan> zzm;

    @Override
    @Nullable
    public Uri getPhotoUrl() {
        return this.zzb.getPhotoUrl();
    }

    @Override
    @NonNull
    public final FirebaseApp zza() {
        return FirebaseApp.getInstance((String)this.zzc);
    }

    @Nullable
    public final zze zzh() {
        return this.zzk;
    }

    public static FirebaseUser zza(FirebaseApp firebaseApp, FirebaseUser firebaseUser) {
        zzad zzad2 = new zzad(firebaseApp, firebaseUser.getProviderData());
        if (firebaseUser instanceof zzad) {
            zzad zzad3 = (zzad)firebaseUser;
            zzad2.zzg = zzad3.zzg;
            zzad2.zzd = zzad3.zzd;
            zzad2.zzi = (zzaf)((FirebaseUser)zzad3).getMetadata();
        } else {
            zzad2.zzi = null;
        }
        if (firebaseUser.zzc() != null) {
            ((FirebaseUser)zzad2).zza(firebaseUser.zzc());
        }
        if (!firebaseUser.isAnonymous()) {
            ((FirebaseUser)zzad2).zzb();
        }
        return zzad2;
    }

    @Override
    public final /* synthetic */ FirebaseUser zzb() {
        zzad zzad2 = this;
        this.zzh = false;
        return zzad2;
    }

    @Override
    @NonNull
    public final synchronized FirebaseUser zza(List<? extends UserInfo> list) {
        Preconditions.checkNotNull(list);
        this.zze = new ArrayList<zzz>(list.size());
        this.zzf = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            UserInfo userInfo = list.get(i);
            if (userInfo.getProviderId().equals("firebase")) {
                this.zzb = (zzz)userInfo;
            } else {
                this.zzf.add(userInfo.getProviderId());
            }
            this.zze.add((zzz)userInfo);
        }
        if (this.zzb == null) {
            this.zzb = this.zze.get(0);
        }
        return this;
    }

    @Override
    public FirebaseUserMetadata getMetadata() {
        return this.zzi;
    }

    @Override
    public /* synthetic */ MultiFactor getMultiFactor() {
        zzad zzad2 = this;
        return new zzah(zzad2);
    }

    @Override
    @NonNull
    public final zzagl zzc() {
        return this.zza;
    }

    public final zzad zza(String string) {
        this.zzg = string;
        return this;
    }

    @Override
    @NonNull
    public final String zzd() {
        return ((FirebaseUser)this).zzc().zzc();
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return this.zzb.getDisplayName();
    }

    @Override
    @Nullable
    public String getEmail() {
        return this.zzb.getEmail();
    }

    @Override
    @Nullable
    public String getPhoneNumber() {
        return this.zzb.getPhoneNumber();
    }

    @Override
    @NonNull
    public String getProviderId() {
        return this.zzb.getProviderId();
    }

    @Override
    @NonNull
    public final String zze() {
        return this.zza.zzf();
    }

    @Override
    @Nullable
    public String getTenantId() {
        String string = null;
        if (this.zza != null && this.zza.zzc() != null) {
            Map map = (Map)zzbg.zza(this.zza.zzc()).getClaims().get("firebase");
            string = map != null ? (String)map.get("tenant") : null;
        }
        return string;
    }

    @Override
    @NonNull
    public String getUid() {
        return this.zzb.getUid();
    }

    @Nullable
    public final List<MultiFactorInfo> zzi() {
        if (this.zzl != null) {
            return this.zzl.zza();
        }
        return new ArrayList<MultiFactorInfo>();
    }

    @Override
    public final List<zzan> zzf() {
        return this.zzm;
    }

    @Override
    @NonNull
    public List<? extends UserInfo> getProviderData() {
        return this.zze;
    }

    @Override
    @Nullable
    public final List<String> zzg() {
        return this.zzf;
    }

    public final List<zzz> zzj() {
        return this.zze;
    }

    public zzad(FirebaseApp firebaseApp, List<? extends UserInfo> list) {
        Preconditions.checkNotNull((Object)firebaseApp);
        this.zzc = firebaseApp.getName();
        this.zzd = "com.google.firebase.auth.internal.DefaultFirebaseUser";
        this.zzg = "2";
        ((FirebaseUser)this).zza(list);
    }

    @SafeParcelable.Constructor
    zzad(@SafeParcelable.Param(id=1) zzagl zzagl2, @SafeParcelable.Param(id=2) zzz zzz2, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) List<zzz> list, @SafeParcelable.Param(id=6) List<String> list2, @SafeParcelable.Param(id=7) String string3, @SafeParcelable.Param(id=8) Boolean bl, @SafeParcelable.Param(id=9) zzaf zzaf2, @SafeParcelable.Param(id=10) boolean bl2, @SafeParcelable.Param(id=11) zze zze2, @SafeParcelable.Param(id=12) zzbl zzbl2, @SafeParcelable.Param(id=13) List<zzan> list3) {
        this.zza = zzagl2;
        this.zzb = zzz2;
        this.zzc = string;
        this.zzd = string2;
        this.zze = list;
        this.zzf = list2;
        this.zzg = string3;
        this.zzh = bl;
        this.zzi = zzaf2;
        this.zzj = bl2;
        this.zzk = zze2;
        this.zzl = zzbl2;
        this.zzm = list3;
    }

    @Override
    public final void zza(zzagl zzagl2) {
        this.zza = (zzagl)Preconditions.checkNotNull((Object)zzagl2);
    }

    public final void zza(@Nullable zze zze2) {
        this.zzk = zze2;
    }

    @Override
    public final void zzb(List<zzan> arrayList) {
        this.zzm = arrayList == null ? new ArrayList() : arrayList;
    }

    public final void zza(boolean bl) {
        this.zzj = bl;
    }

    public final void zza(zzaf zzaf2) {
        this.zzi = zzaf2;
    }

    @Override
    public final void zzc(List<MultiFactorInfo> list) {
        this.zzl = zzbl.zza(list);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzad zzad2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)1, (Parcelable)((FirebaseUser)zzad2).zzc(), (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)zzad2.zzb, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzad2.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)zzad2.zzd, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)5, zzad2.zze, (boolean)false);
        SafeParcelWriter.writeStringList((Parcel)parcel2, (int)6, ((FirebaseUser)zzad2).zzg(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)zzad2.zzg, (boolean)false);
        SafeParcelWriter.writeBooleanObject((Parcel)parcel2, (int)8, (Boolean)((FirebaseUser)zzad2).isAnonymous(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)9, (Parcelable)((FirebaseUser)zzad2).getMetadata(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)10, (boolean)zzad2.zzj);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)11, (Parcelable)zzad2.zzk, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)12, (Parcelable)zzad2.zzl, (int)n, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)13, ((FirebaseUser)zzad2).zzf(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Override
    public boolean isAnonymous() {
        if (this.zzh == null || this.zzh.booleanValue()) {
            String string = "";
            if (this.zza != null) {
                GetTokenResult getTokenResult = zzbg.zza(this.zza.zzc());
                string = getTokenResult != null ? getTokenResult.getSignInProvider() : "";
            }
            this.zzh = ((FirebaseUser)this).getProviderData().size() <= 1 && (string == null || !string.equals("custom"));
        }
        return this.zzh;
    }

    @Override
    public boolean isEmailVerified() {
        return this.zzb.isEmailVerified();
    }

    public final boolean zzk() {
        return this.zzj;
    }
}

