/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.fragment.app.FragmentActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.util.AndroidUtilsLight;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.Hex;
import com.google.android.gms.internal.firebase-auth-api.zzadj;
import com.google.android.gms.internal.firebase-auth-api.zzadk;
import com.google.android.gms.internal.firebase-auth-api.zzadl;
import com.google.android.gms.internal.firebase-auth-api.zzadx;
import com.google.android.gms.internal.firebase-auth-api.zzafb;
import com.google.android.gms.internal.firebase-auth-api.zzb;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.appcheck.AppCheckTokenResult;
import com.google.firebase.appcheck.interop.InteropAppCheckTokenProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.internal.zzaq;
import com.google.firebase.auth.internal.zzbm;
import com.google.firebase.auth.internal.zzbn;
import com.google.firebase.auth.internal.zzbo;
import com.google.firebase.auth.internal.zzcd;
import com.google.firebase.auth.internal.zzcf;
import com.google.firebase.auth.internal.zzq;
import com.google.firebase.auth.internal.zzs;
import com.google.firebase.inject.Provider;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import java.util.UUID;

public class RecaptchaActivity
extends FragmentActivity
implements zzadl {
    private static final String zzb = RecaptchaActivity.class.getSimpleName();
    private static long zzc = 0L;
    private static final zzcf zzd = zzcf.zzc();
    private boolean zze = false;

    @Override
    @NonNull
    public final Context zza() {
        return this.getApplicationContext();
    }

    @VisibleForTesting
    @Nullable
    private final Uri.Builder zza(Uri.Builder builder, Intent intent, String string, String string2) {
        String string3 = intent.getStringExtra("com.google.firebase.auth.KEY_API_KEY");
        String string4 = UUID.randomUUID().toString();
        String string5 = intent.getStringExtra("com.google.firebase.auth.internal.CLIENT_VERSION");
        String string6 = intent.getStringExtra("com.google.firebase.auth.internal.FIREBASE_APP_NAME");
        FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string6);
        FirebaseAuth firebaseAuth = FirebaseAuth.getInstance(firebaseApp);
        zzq.zza().zza(this.getApplicationContext(), string, string4, "com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA", string6);
        String string7 = zzs.zza(this.getApplicationContext(), firebaseApp.getPersistenceKey()).zza();
        if (TextUtils.isEmpty((CharSequence)string7)) {
            Log.e((String)zzb, (String)"Could not generate an encryption key for reCAPTCHA - cancelling flow.");
            this.zza(zzaq.zza("Failed to generate/retrieve public encryption key for reCAPTCHA flow."));
            return null;
        }
        String string8 = !TextUtils.isEmpty((CharSequence)firebaseAuth.getLanguageCode()) ? firebaseAuth.getLanguageCode() : zzadx.zza();
        String string9 = string5;
        builder.appendQueryParameter("apiKey", string3).appendQueryParameter("authType", "verifyApp").appendQueryParameter("apn", string).appendQueryParameter("hl", string8).appendQueryParameter("eventId", string4).appendQueryParameter("v", "X" + string9).appendQueryParameter("eid", "p").appendQueryParameter("appName", string6).appendQueryParameter("sha1Cert", string2).appendQueryParameter("publicKey", string7);
        return builder;
    }

    @Override
    @Nullable
    public final Uri.Builder zza(@NonNull Intent intent, @NonNull String string, @NonNull String string2) {
        Uri.Builder builder = new Uri.Builder().scheme("https").appendPath("__").appendPath("auth").appendPath("handler");
        return this.zza(builder, intent, string, string2);
    }

    static /* synthetic */ Uri zza(Uri uri, Task task) throws Exception {
        Uri.Builder builder = uri.buildUpon();
        if (task.isSuccessful()) {
            String string;
            AppCheckTokenResult appCheckTokenResult = (AppCheckTokenResult)task.getResult();
            if (appCheckTokenResult.getError() != null) {
                string = String.valueOf(appCheckTokenResult.getError());
                Log.w((String)zzb, (String)("Error getting App Check token; using placeholder token instead. Error: " + string));
            }
            string = appCheckTokenResult.getToken();
            builder.fragment("fac=" + string);
        } else {
            String string = task.getException().getMessage();
            Log.e((String)zzb, (String)("Unexpected error getting App Check token: " + string));
        }
        return builder.build();
    }

    @Override
    @NonNull
    public final String zza(@NonNull String string) {
        return zzafb.zzb(string);
    }

    @Override
    @Nullable
    public final HttpURLConnection zza(@NonNull URL uRL) {
        try {
            return (HttpURLConnection)com.google.android.gms.internal.firebase-auth-api.zzb.zza().zza(uRL, "client-firebase-auth-api");
        }
        catch (IOException iOException) {
            zza.e("Error generating connection", new Object[0]);
            return null;
        }
    }

    private final void zzb() {
        zzc = 0L;
        this.zze = false;
        Intent intent = new Intent();
        intent.putExtra("com.google.firebase.auth.internal.EXTRA_CANCELED", true);
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        this.zza(intent);
        zzd.zza((Context)this);
        this.finish();
    }

    private final void zza(Status status) {
        zzc = 0L;
        this.zze = false;
        Intent intent = new Intent();
        zzcd.zza(intent, status);
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        this.zza(intent);
        zzd.zza((Context)this);
        this.finish();
    }

    @Override
    public final void zza(@NonNull String string, @Nullable Status status) {
        if (status == null) {
            this.zzb();
            return;
        }
        this.zza(status);
    }

    @Override
    public final void zza(@NonNull Uri uri, @NonNull String string, @NonNull Provider<InteropAppCheckTokenProvider> provider) {
        Task task;
        Provider<InteropAppCheckTokenProvider> provider2 = provider;
        Uri uri2 = uri;
        InteropAppCheckTokenProvider interopAppCheckTokenProvider = (InteropAppCheckTokenProvider)provider2.get();
        if (interopAppCheckTokenProvider != null) {
            Uri uri3 = uri2;
            task = interopAppCheckTokenProvider.getToken(false).continueWith((Continuation)new zzbn(uri3));
        } else {
            task = Tasks.forResult((Object)uri2);
        }
        String string2 = string;
        RecaptchaActivity recaptchaActivity = this;
        task.addOnCompleteListener((OnCompleteListener)new zzbo(recaptchaActivity, string2));
    }

    final /* synthetic */ void zza(String string, Task task) {
        RecaptchaActivity recaptchaActivity = this;
        Object object = new Intent("android.intent.action.VIEW");
        if (recaptchaActivity.getPackageManager().resolveActivity((Intent)object, 0) != null) {
            object = this.getPackageManager().queryIntentServices(new Intent("android.support.customtabs.action.CustomTabsService"), 0);
            if (object != null && !object.isEmpty()) {
                CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().build();
                customTabsIntent.intent.addFlags(0x40000000);
                customTabsIntent.intent.addFlags(0x10000000);
                customTabsIntent.launchUrl((Context)this, (Uri)task.getResult());
                return;
            }
            Intent intent = new Intent("android.intent.action.VIEW", (Uri)task.getResult());
            intent.putExtra("com.android.browser.application_id", string);
            intent.addFlags(0x40000000);
            intent.addFlags(0x10000000);
            this.startActivity(intent);
            return;
        }
        Log.e((String)zzb, (String)"Device cannot resolve intent for: android.intent.action.VIEW");
        zzadk.zzb(this, string);
    }

    protected void onCreate(@NonNull Bundle bundle) {
        super.onCreate(bundle);
        String string = this.getIntent().getAction();
        if (!"com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA".equals(string) && !"android.intent.action.VIEW".equals(string)) {
            String string2 = string;
            Log.e((String)zzb, (String)("Could not do operation - unknown action: " + string2));
            this.zzb();
            return;
        }
        long l = DefaultClock.getInstance().currentTimeMillis();
        if (l - zzc < 30000L) {
            Log.e((String)zzb, (String)"Could not start operation - already in progress");
            return;
        }
        zzc = l;
        if (bundle != null) {
            this.zze = bundle.getBoolean("com.google.firebase.auth.internal.KEY_ALREADY_STARTED_RECAPTCHA_FLOW");
        }
    }

    public void onNewIntent(@NonNull Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    protected void onResume() {
        super.onResume();
        if ("android.intent.action.VIEW".equals(this.getIntent().getAction())) {
            Intent intent = this.getIntent();
            RecaptchaActivity recaptchaActivity = this;
            if (intent.hasExtra("firebaseError")) {
                Status status = zzcd.zza(intent.getStringExtra("firebaseError"));
                recaptchaActivity.zza(status);
                return;
            }
            if (intent.hasExtra("link") && intent.hasExtra("eventId")) {
                String string;
                String string2 = intent.getStringExtra("link");
                String string3 = zzq.zza().zzb(recaptchaActivity.getApplicationContext(), recaptchaActivity.getPackageName(), intent.getStringExtra("eventId"));
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    Log.e((String)zzb, (String)"Failed to find registration for this event - failing to prevent session injection.");
                    recaptchaActivity.zza(zzaq.zza("Failed to find registration for this reCAPTCHA event"));
                }
                if (intent.getBooleanExtra("encryptionEnabled", true)) {
                    string2 = zzs.zza(recaptchaActivity.getApplicationContext(), FirebaseApp.getInstance((String)string3).getPersistenceKey()).zza(string2);
                }
                String string4 = string = Uri.parse((String)string2).getQueryParameter("recaptchaToken");
                RecaptchaActivity recaptchaActivity2 = recaptchaActivity;
                zzc = 0L;
                recaptchaActivity2.zze = false;
                Intent intent2 = new Intent();
                intent2.putExtra("com.google.firebase.auth.internal.RECAPTCHA_TOKEN", string4);
                intent2.putExtra("com.google.firebase.auth.internal.OPERATION", "com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA");
                intent2.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
                if (!recaptchaActivity2.zza(intent2)) {
                    String string5 = "com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA";
                    String string6 = string4;
                    zzbm.zza(recaptchaActivity2.getApplicationContext(), string6, string5);
                } else {
                    zzd.zza((Context)recaptchaActivity2);
                }
                recaptchaActivity2.finish();
                return;
            }
            recaptchaActivity.zzb();
            return;
        }
        if (!this.zze) {
            block12: {
                String string;
                Intent intent = this.getIntent();
                RecaptchaActivity recaptchaActivity = this;
                String string7 = recaptchaActivity.getPackageName();
                try {
                    string = Hex.bytesToStringUppercase((byte[])AndroidUtilsLight.getPackageCertificateHashBytes((Context)recaptchaActivity, (String)string7)).toLowerCase(Locale.US);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    String string8 = String.valueOf((Object)nameNotFoundException);
                    String string9 = string7;
                    Log.e((String)zzb, (String)("Could not get package signature: " + string9 + " " + string8));
                    zzadk.zzb(recaptchaActivity, string7);
                    break block12;
                }
                FirebaseApp firebaseApp = FirebaseApp.getInstance((String)intent.getStringExtra("com.google.firebase.auth.internal.FIREBASE_APP_NAME"));
                FirebaseAuth firebaseAuth = FirebaseAuth.getInstance(firebaseApp);
                if (!zzafb.zza(firebaseApp)) {
                    new zzadj(string7, string, intent, firebaseApp, recaptchaActivity).executeOnExecutor(firebaseAuth.zze(), new Void[0]);
                } else {
                    String string10 = zzafb.zza(firebaseApp.getOptions().getApiKey());
                    recaptchaActivity.zza(recaptchaActivity.zza(Uri.parse((String)string10).buildUpon(), recaptchaActivity.getIntent(), string7, string).build(), string7, firebaseAuth.zzc());
                }
            }
            this.zze = true;
            return;
        }
        this.zzb();
    }

    protected void onSaveInstanceState(@NonNull Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("com.google.firebase.auth.internal.KEY_ALREADY_STARTED_RECAPTCHA_FLOW", this.zze);
    }

    private final boolean zza(Intent intent) {
        return LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }
}

