/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.logging.Logger;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthOptions;
import com.google.firebase.auth.zzc;
import java.util.concurrent.TimeUnit;

public class PhoneAuthProvider {
    @NonNull
    public static final String PROVIDER_ID = "phone";
    @NonNull
    public static final String PHONE_SIGN_IN_METHOD = "phone";
    private final FirebaseAuth zza;

    @NonNull
    public static PhoneAuthCredential getCredential(@NonNull String string, @NonNull String string2) {
        return PhoneAuthCredential.zza(string, string2);
    }

    @Deprecated
    @NonNull
    public static PhoneAuthProvider getInstance() {
        return new PhoneAuthProvider(FirebaseAuth.getInstance(FirebaseApp.getInstance()));
    }

    @Deprecated
    @NonNull
    public static PhoneAuthProvider getInstance(@NonNull FirebaseAuth firebaseAuth) {
        return new PhoneAuthProvider(firebaseAuth);
    }

    private PhoneAuthProvider(FirebaseAuth firebaseAuth) {
        this.zza = firebaseAuth;
    }

    public static void verifyPhoneNumber(@NonNull PhoneAuthOptions phoneAuthOptions) {
        Preconditions.checkNotNull((Object)phoneAuthOptions);
        FirebaseAuth.zza(phoneAuthOptions);
    }

    @Deprecated
    public void verifyPhoneNumber(@NonNull String string, long l, @NonNull TimeUnit timeUnit, @NonNull Activity activity, @NonNull OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
        PhoneAuthProvider.verifyPhoneNumber(PhoneAuthOptions.newBuilder(this.zza).setPhoneNumber(string).setTimeout(l, timeUnit).setActivity(activity).setCallbacks(onVerificationStateChangedCallbacks).build());
    }

    @Deprecated
    public void verifyPhoneNumber(@NonNull String string, long l, @NonNull TimeUnit timeUnit, @NonNull Activity activity, @NonNull OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, @Nullable ForceResendingToken forceResendingToken) {
        PhoneAuthOptions.Builder builder = PhoneAuthOptions.newBuilder(this.zza).setPhoneNumber(string).setTimeout(l, timeUnit).setActivity(activity).setCallbacks(onVerificationStateChangedCallbacks);
        if (forceResendingToken != null) {
            builder.setForceResendingToken(forceResendingToken);
        }
        PhoneAuthProvider.verifyPhoneNumber(builder.build());
    }

    public static abstract class OnVerificationStateChangedCallbacks {
        private static final Logger zza = new Logger("PhoneAuthProvider", new String[0]);

        public void onCodeAutoRetrievalTimeOut(@NonNull String string) {
            zza.i("Sms auto retrieval timed-out.", new Object[0]);
        }

        public void onCodeSent(@NonNull String string, @NonNull ForceResendingToken forceResendingToken) {
        }

        public abstract void onVerificationCompleted(@NonNull PhoneAuthCredential var1);

        public abstract void onVerificationFailed(@NonNull FirebaseException var1);
    }

    @SafeParcelable.Class(creator="DefaultForceResendingTokenCreator")
    public static class ForceResendingToken
    extends AbstractSafeParcelable {
        @NonNull
        public static final Parcelable.Creator<ForceResendingToken> CREATOR = new zzc();

        @NonNull
        public static ForceResendingToken zza() {
            return new ForceResendingToken();
        }

        @SafeParcelable.Constructor
        ForceResendingToken() {
        }

        public void writeToParcel(@NonNull Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }
    }
}

