/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase-auth-api.zzabj;
import com.google.android.gms.internal.firebase-auth-api.zzadg;
import com.google.android.gms.internal.firebase-auth-api.zzadn;
import com.google.android.gms.internal.firebase-auth-api.zzadx;
import com.google.android.gms.internal.firebase-auth-api.zzaer;
import com.google.android.gms.internal.firebase-auth-api.zzafb;
import com.google.android.gms.internal.firebase-auth-api.zzag;
import com.google.android.gms.internal.firebase-auth-api.zzagh;
import com.google.android.gms.internal.firebase-auth-api.zzagl;
import com.google.android.gms.internal.firebase-auth-api.zzagm;
import com.google.android.gms.internal.firebase-auth-api.zzagz;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.android.recaptcha.RecaptchaAction;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.annotations.concurrent.Background;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.annotations.concurrent.Lightweight;
import com.google.firebase.annotations.concurrent.UiThread;
import com.google.firebase.appcheck.interop.InteropAppCheckTokenProvider;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.ActionCodeUrl;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuthSettings;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.MultiFactorAssertion;
import com.google.firebase.auth.MultiFactorInfo;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthOptions;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.PhoneMultiFactorAssertion;
import com.google.firebase.auth.PhoneMultiFactorInfo;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.TotpMultiFactorAssertion;
import com.google.firebase.auth.TotpSecret;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.auth.internal.zzad;
import com.google.firebase.auth.internal.zzae;
import com.google.firebase.auth.internal.zzao;
import com.google.firebase.auth.internal.zzaw;
import com.google.firebase.auth.internal.zzbg;
import com.google.firebase.auth.internal.zzbm;
import com.google.firebase.auth.internal.zzbv;
import com.google.firebase.auth.internal.zzbz;
import com.google.firebase.auth.internal.zzca;
import com.google.firebase.auth.internal.zzce;
import com.google.firebase.auth.internal.zzcf;
import com.google.firebase.auth.zzaa;
import com.google.firebase.auth.zzab;
import com.google.firebase.auth.zzac;
import com.google.firebase.auth.zzan;
import com.google.firebase.auth.zzh;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzk;
import com.google.firebase.auth.zzl;
import com.google.firebase.auth.zzm;
import com.google.firebase.auth.zzn;
import com.google.firebase.auth.zzo;
import com.google.firebase.auth.zzp;
import com.google.firebase.auth.zzq;
import com.google.firebase.auth.zzr;
import com.google.firebase.auth.zzs;
import com.google.firebase.auth.zzt;
import com.google.firebase.auth.zzu;
import com.google.firebase.auth.zzv;
import com.google.firebase.auth.zzw;
import com.google.firebase.auth.zzx;
import com.google.firebase.auth.zzy;
import com.google.firebase.auth.zzz;
import com.google.firebase.heartbeatinfo.HeartBeatController;
import com.google.firebase.inject.Provider;
import com.google.firebase.internal.InternalTokenResult;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class FirebaseAuth
implements InternalAuthProvider {
    private final FirebaseApp zza;
    private final List<IdTokenListener> zzb;
    private final List<com.google.firebase.auth.internal.IdTokenListener> zzc;
    private final List<AuthStateListener> zzd;
    private final zzabj zze;
    @Nullable
    private FirebaseUser zzf;
    private final zzae zzg;
    private final Object zzh;
    private String zzi;
    private final Object zzj;
    private String zzk;
    private zzbv zzl;
    private final RecaptchaAction zzm;
    private final RecaptchaAction zzn;
    private final RecaptchaAction zzo;
    private final RecaptchaAction zzp;
    @VisibleForTesting
    private final RecaptchaAction zzq;
    @VisibleForTesting
    private final RecaptchaAction zzr;
    private final @MonotonicNonNull zzca zzs;
    private final @MonotonicNonNull zzcf zzt;
    private final com.google.firebase.auth.internal.zza zzu;
    private final Provider<InteropAppCheckTokenProvider> zzv;
    private final Provider<HeartBeatController> zzw;
    private zzbz zzx;
    private final Executor zzy;
    private final Executor zzz;
    private final Executor zzaa;
    private String zzab;

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zza(this.zza, string, this.zzk);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzb(this.zza, string, this.zzk);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zze.zza(this.zza, string, string2, this.zzk);
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return new zzn(this, string, string2).zza(this, this.zzk, this.zzo, "EMAIL_PASSWORD_PROVIDER");
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zze.zza(firebaseUser, new zzr(this, firebaseUser));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull MultiFactorAssertion multiFactorAssertion, @Nullable String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)multiFactorAssertion);
        if (multiFactorAssertion instanceof PhoneMultiFactorAssertion) {
            return this.zze.zza(this.zza, (PhoneMultiFactorAssertion)multiFactorAssertion, firebaseUser, string, (com.google.firebase.auth.internal.zzj)new zza());
        }
        if (multiFactorAssertion instanceof TotpMultiFactorAssertion) {
            return this.zze.zza(this.zza, (TotpMultiFactorAssertion)multiFactorAssertion, firebaseUser, string, this.zzk, (com.google.firebase.auth.internal.zzj)new zza());
        }
        return Tasks.forException((Exception)zzadg.zza(new Status(17499)));
    }

    @Deprecated
    @NonNull
    public Task<SignInMethodQueryResult> fetchSignInMethodsForEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzc(this.zza, string, this.zzk);
    }

    @NonNull
    public Task<GetTokenResult> getAccessToken(boolean bl) {
        return this.zza(this.zzf, bl);
    }

    @NonNull
    public final Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzadg.zza(new Status(17495)));
        }
        zzagl zzagl2 = firebaseUser.zzc();
        if (zzagl2.zzg() && !bl) {
            return Tasks.forResult((Object)zzbg.zza(zzagl2.zzc()));
        }
        return this.zze.zza(this.zza, firebaseUser, zzagl2.zzd(), (zzce)((Object)new zzx(this)));
    }

    @Nullable
    public Task<AuthResult> getPendingAuthResult() {
        return this.zzt.zza();
    }

    @NonNull
    public final Task<zzagh> zza() {
        return this.zze.zza();
    }

    @NonNull
    public final Task<zzagm> zza(@NonNull String string) {
        return this.zze.zza(this.zzk, string);
    }

    @NonNull
    public Task<Void> initializeRecaptchaConfig() {
        if (this.zzl == null) {
            FirebaseAuth firebaseAuth = this;
            this.zzl = new zzbv(firebaseAuth.zza, firebaseAuth);
        }
        return this.zzl.zza(this.zzk, false).continueWithTask((Continuation)new zzaa(this));
    }

    @NonNull
    public final Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        Preconditions.checkNotNull((Object)firebaseUser);
        if (authCredential instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential.zza();
            FirebaseUser firebaseUser2 = firebaseUser;
            FirebaseAuth firebaseAuth = this;
            return new zzo(firebaseAuth, firebaseUser2, emailAuthCredential).zza(firebaseAuth, firebaseUser2.getTenantId(), firebaseAuth.zzo, "EMAIL_PASSWORD_PROVIDER");
        }
        return this.zze.zza(this.zza, firebaseUser, authCredential.zza(), null, (zzce)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        AuthCredential authCredential2 = authCredential.zza();
        if (authCredential2 instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential2;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zza(firebaseUser, emailAuthCredential, false);
            }
            if (this.zzb(Preconditions.checkNotEmpty((String)emailAuthCredential.zze()))) {
                return Tasks.forException((Exception)zzadg.zza(new Status(17072)));
            }
            return this.zza(firebaseUser, emailAuthCredential, true);
        }
        if (authCredential2 instanceof PhoneAuthCredential) {
            return this.zze.zza(this.zza, firebaseUser, (PhoneAuthCredential)authCredential2, this.zzk, (zzce)((Object)new zzb()));
        }
        return this.zze.zzb(this.zza, firebaseUser, authCredential2, firebaseUser.getTenantId(), (zzce)((Object)new zzb()));
    }

    @NonNull
    public final Task<AuthResult> zzc(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        AuthCredential authCredential2 = authCredential.zza();
        if (authCredential2 instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential2;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zza(emailAuthCredential.zzc(), Preconditions.checkNotEmpty((String)emailAuthCredential.zzd()), firebaseUser.getTenantId(), firebaseUser, true);
            }
            if (this.zzb(Preconditions.checkNotEmpty((String)emailAuthCredential.zze()))) {
                return Tasks.forException((Exception)zzadg.zza(new Status(17072)));
            }
            return this.zza(emailAuthCredential, firebaseUser, true);
        }
        if (authCredential2 instanceof PhoneAuthCredential) {
            return this.zze.zzb(this.zza, firebaseUser, (PhoneAuthCredential)authCredential2, this.zzk, (zzce)((Object)new zzb()));
        }
        return this.zze.zzc(this.zza, firebaseUser, authCredential2, firebaseUser.getTenantId(), (zzce)((Object)new zzb()));
    }

    private final Task<Void> zza(FirebaseUser firebaseUser, zzce zzce2) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zze.zza(this.zza, firebaseUser, zzce2);
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser) {
        return this.zza(firebaseUser, (zzce)((Object)new zzb()));
    }

    public final Task<AuthResult> zza(MultiFactorAssertion multiFactorAssertion, zzao zzao2, @Nullable FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)multiFactorAssertion);
        Preconditions.checkNotNull((Object)((Object)zzao2));
        if (multiFactorAssertion instanceof PhoneMultiFactorAssertion) {
            return this.zze.zza(this.zza, firebaseUser, (PhoneMultiFactorAssertion)multiFactorAssertion, Preconditions.checkNotEmpty((String)zzao2.zzc()), (com.google.firebase.auth.internal.zzj)new zza());
        }
        if (multiFactorAssertion instanceof TotpMultiFactorAssertion) {
            return this.zze.zza(this.zza, firebaseUser, (TotpMultiFactorAssertion)multiFactorAssertion, Preconditions.checkNotEmpty((String)zzao2.zzc()), this.zzk, (com.google.firebase.auth.internal.zzj)new zza());
        }
        throw new IllegalArgumentException("multiFactorAssertion must be either PhoneMultiFactorAssertion or TotpMultiFactorAssertion.");
    }

    @NonNull
    public Task<Void> revokeAccessToken(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        FirebaseUser firebaseUser = this.getCurrentUser();
        Preconditions.checkNotNull((Object)firebaseUser);
        return firebaseUser.getIdToken(false).continueWithTask((Continuation)new zzw(this, string));
    }

    @NonNull
    public final Task<Void> zza(@Nullable ActionCodeSettings actionCodeSettings, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        if (this.zzi != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.zzb();
            }
            actionCodeSettings.zza(this.zzi);
        }
        return this.zze.zza(this.zza, actionCodeSettings, string);
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.sendPasswordResetEmail(string, null);
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string, @Nullable ActionCodeSettings actionCodeSettings) {
        Preconditions.checkNotEmpty((String)string);
        if (actionCodeSettings == null) {
            actionCodeSettings = ActionCodeSettings.zzb();
        }
        if (this.zzi != null) {
            actionCodeSettings.zza(this.zzi);
        }
        actionCodeSettings.zza(1);
        ActionCodeSettings actionCodeSettings2 = actionCodeSettings;
        return new zzq(this, string, actionCodeSettings2).zza(this, this.zzk, this.zzm, "EMAIL_PASSWORD_PROVIDER");
    }

    @NonNull
    public Task<Void> sendSignInLinkToEmail(@NonNull String string, @NonNull ActionCodeSettings actionCodeSettings) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)actionCodeSettings));
        if (!actionCodeSettings.canHandleCodeInApp()) {
            throw new IllegalArgumentException("You must set canHandleCodeInApp in your ActionCodeSettings to true for Email-Link Sign-in.");
        }
        if (this.zzi != null) {
            actionCodeSettings.zza(this.zzi);
        }
        return new zzp(this, string, actionCodeSettings).zza(this, this.zzk, this.zzm, "EMAIL_PASSWORD_PROVIDER");
    }

    @NonNull
    public Task<Void> setFirebaseUIVersion(@Nullable String string) {
        return this.zze.zza(string);
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzf != null && this.zzf.isAnonymous()) {
            zzad zzad2 = (zzad)this.zzf;
            zzad2.zza(false);
            return Tasks.forResult((Object)new com.google.firebase.auth.internal.zzx(zzad2));
        }
        return this.zze.zza(this.zza, new zza(), this.zzk);
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        AuthCredential authCredential2 = authCredential.zza();
        if (authCredential2 instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential2;
            if (!emailAuthCredential.zzf()) {
                return this.zza(emailAuthCredential.zzc(), (String)Preconditions.checkNotNull((Object)emailAuthCredential.zzd()), this.zzk, null, false);
            }
            if (this.zzb(Preconditions.checkNotEmpty((String)emailAuthCredential.zze()))) {
                return Tasks.forException((Exception)zzadg.zza(new Status(17072)));
            }
            return this.zza(emailAuthCredential, null, false);
        }
        if (authCredential2 instanceof PhoneAuthCredential) {
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential2;
            return this.zze.zza(this.zza, phoneAuthCredential, this.zzk, (com.google.firebase.auth.internal.zzj)new zza());
        }
        return this.zze.zza(this.zza, authCredential2, this.zzk, (com.google.firebase.auth.internal.zzj)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zza(this.zza, string, this.zzk, (com.google.firebase.auth.internal.zzj)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zza(string, string2, this.zzk, null, false);
    }

    @NonNull
    public Task<AuthResult> signInWithEmailLink(@NonNull String string, @NonNull String string2) {
        return this.signInWithCredential(EmailAuthProvider.getCredentialWithLink(string, string2));
    }

    @NonNull
    public final Task<AuthResult> zza(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider, @NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)firebaseUser);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!this.zzt.zza(activity, (TaskCompletionSource<AuthResult>)taskCompletionSource, this, firebaseUser)) {
            return Tasks.forException((Exception)zzadg.zza(new Status(17057)));
        }
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        zzbm.zza(activity.getApplicationContext(), firebaseAuth, firebaseUser2);
        federatedAuthProvider.zza(activity);
        return taskCompletionSource.getTask();
    }

    @NonNull
    public final Task<AuthResult> zzb(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider, @NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)firebaseUser);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!this.zzt.zza(activity, (TaskCompletionSource<AuthResult>)taskCompletionSource, this, firebaseUser)) {
            return Tasks.forException((Exception)zzadg.zza(new Status(17057)));
        }
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        zzbm.zza(activity.getApplicationContext(), firebaseAuth, firebaseUser2);
        federatedAuthProvider.zzb(activity);
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<AuthResult> startActivityForSignInWithProvider(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider) {
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)activity);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!this.zzt.zza(activity, (TaskCompletionSource<AuthResult>)taskCompletionSource, this)) {
            return Tasks.forException((Exception)zzadg.zza(new Status(17057)));
        }
        FirebaseAuth firebaseAuth = this;
        zzbm.zza(activity.getApplicationContext(), firebaseAuth);
        federatedAuthProvider.zzc(activity);
        return taskCompletionSource.getTask();
    }

    public final Task<TotpSecret> zza(zzao zzao2) {
        Preconditions.checkNotNull((Object)((Object)zzao2));
        return this.zze.zza(zzao2, this.zzk).continueWithTask((Continuation)new zzt(this));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zza(this.zza, firebaseUser, string, this.zzk, (zzce)((Object)new zzb())).continueWithTask((Continuation)new zzs(this));
    }

    @NonNull
    public final Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zze.zzb(this.zza, firebaseUser, string, (zzce)((Object)new zzb()));
    }

    @NonNull
    public Task<Void> updateCurrentUser(@NonNull FirebaseUser firebaseUser) {
        if (firebaseUser == null) {
            throw new IllegalArgumentException("Cannot update current user with null user!");
        }
        String string = firebaseUser.getTenantId();
        if (string != null && !string.equals(this.zzk) || this.zzk != null && !this.zzk.equals(string)) {
            return Tasks.forException((Exception)zzadg.zza(new Status(17072)));
        }
        String string2 = firebaseUser.zza().getOptions().getApiKey();
        String string3 = this.zza.getOptions().getApiKey();
        if (firebaseUser.zzc().zzg() && string3.equals(string2)) {
            FirebaseUser firebaseUser2 = zzad.zza(this.zza, firebaseUser);
            this.zza(firebaseUser2, firebaseUser.zzc(), true);
            return Tasks.forResult(null);
        }
        return this.zza(firebaseUser, (zzce)((Object)new zzc(this)));
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzc(this.zza, firebaseUser, string, (zzce)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zzd(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzd(this.zza, firebaseUser, string, (zzce)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)phoneAuthCredential);
        return this.zze.zza(this.zza, firebaseUser, (PhoneAuthCredential)((AuthCredential)phoneAuthCredential).zza(), (zzce)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)userProfileChangeRequest));
        return this.zze.zza(this.zza, firebaseUser, userProfileChangeRequest, (zzce)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zza(@NonNull String string, @NonNull String string2, @Nullable ActionCodeSettings actionCodeSettings) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        if (actionCodeSettings == null) {
            actionCodeSettings = ActionCodeSettings.zzb();
        }
        if (this.zzi != null) {
            actionCodeSettings.zza(this.zzi);
        }
        return this.zze.zza(string, string2, actionCodeSettings);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzd(this.zza, string, this.zzk);
    }

    private final Task<Void> zza(FirebaseUser firebaseUser, EmailAuthCredential emailAuthCredential, boolean bl) {
        return new zzab(this, bl, firebaseUser, emailAuthCredential).zza(this, this.zzk, bl ? this.zzm : this.zzn, "EMAIL_PASSWORD_PROVIDER");
    }

    private final Task<AuthResult> zza(String string, String string2, @Nullable String string3, @Nullable FirebaseUser firebaseUser, boolean bl) {
        return new zzz(this, string, bl, firebaseUser, string2, string3).zza(this, string3, this.zzn, "EMAIL_PASSWORD_PROVIDER");
    }

    private final Task<AuthResult> zza(EmailAuthCredential emailAuthCredential, @Nullable FirebaseUser firebaseUser, boolean bl) {
        zzac zzac2 = new zzac(this, bl, firebaseUser, emailAuthCredential);
        RecaptchaAction recaptchaAction = this.zzm;
        return zzac2.zza(this, this.zzk, recaptchaAction, "EMAIL_PASSWORD_PROVIDER");
    }

    static /* bridge */ /* synthetic */ FirebaseApp zza(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zza;
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.zza;
    }

    @Keep
    @NonNull
    public static FirebaseAuth getInstance() {
        return (FirebaseAuth)FirebaseApp.getInstance().get(FirebaseAuth.class);
    }

    @Keep
    @NonNull
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseAuth)firebaseApp.get(FirebaseAuth.class);
    }

    @NonNull
    public FirebaseAuthSettings getFirebaseAuthSettings() {
        return this.zzg;
    }

    static /* bridge */ /* synthetic */ FirebaseUser zzb(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzf;
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzf;
    }

    static /* bridge */ /* synthetic */ PhoneAuthProvider.OnVerificationStateChangedCallbacks zza(FirebaseAuth firebaseAuth, String string, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
        return firebaseAuth.zza(string, onVerificationStateChangedCallbacks);
    }

    @VisibleForTesting
    final PhoneAuthProvider.OnVerificationStateChangedCallbacks zza(PhoneAuthOptions phoneAuthOptions, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, com.google.firebase.auth.internal.zzh zzh2) {
        if (phoneAuthOptions.zzj()) {
            return onVerificationStateChangedCallbacks;
        }
        return new zzl(this, phoneAuthOptions, zzh2, onVerificationStateChangedCallbacks);
    }

    private final PhoneAuthProvider.OnVerificationStateChangedCallbacks zza(@Nullable String string, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
        if (this.zzg.zzd() && string != null && string.equals(this.zzg.zza())) {
            PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks2 = onVerificationStateChangedCallbacks;
            FirebaseAuth firebaseAuth = this;
            onVerificationStateChangedCallbacks = new zzm(firebaseAuth, onVerificationStateChangedCallbacks2);
        }
        return onVerificationStateChangedCallbacks;
    }

    static /* bridge */ /* synthetic */ zzabj zzc(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zze;
    }

    static /* bridge */ /* synthetic */ zzae zzd(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzg;
    }

    public final synchronized zzbv zzb() {
        return this.zzl;
    }

    @VisibleForTesting
    private final synchronized zzbz zzj() {
        return FirebaseAuth.zzj(this);
    }

    private static zzbz zzj(@UnknownInitialization FirebaseAuth firebaseAuth) {
        if (firebaseAuth.zzx == null) {
            FirebaseApp firebaseApp = (FirebaseApp)Preconditions.checkNotNull((Object)firebaseAuth.zza);
            firebaseAuth.zzx = new zzbz(firebaseApp);
        }
        return firebaseAuth.zzx;
    }

    @NonNull
    public final Provider<InteropAppCheckTokenProvider> zzc() {
        return this.zzv;
    }

    @NonNull
    public final Provider<HeartBeatController> zzd() {
        return this.zzw;
    }

    static /* bridge */ /* synthetic */ String zze(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzi;
    }

    static /* bridge */ /* synthetic */ String zzf(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzk;
    }

    @Nullable
    public String getCustomAuthDomain() {
        return this.zzab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLanguageCode() {
        Object object = this.zzh;
        synchronized (object) {
            return this.zzi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getTenantId() {
        Object object = this.zzj;
        synchronized (object) {
            return this.zzk;
        }
    }

    @Nullable
    public String getUid(@UnknownInitialization FirebaseAuth this) {
        if (this.zzf == null) {
            return null;
        }
        return this.zzf.getUid();
    }

    static /* bridge */ /* synthetic */ List zzg(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzd;
    }

    static /* bridge */ /* synthetic */ List zzh(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzb;
    }

    static /* bridge */ /* synthetic */ List zzi(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzc;
    }

    @NonNull
    public final Executor zze() {
        return this.zzy;
    }

    @NonNull
    public final Executor zzf() {
        return this.zzz;
    }

    @NonNull
    public final Executor zzg() {
        return this.zzaa;
    }

    public FirebaseAuth(@NonNull FirebaseApp firebaseApp, @NonNull Provider<InteropAppCheckTokenProvider> provider, @NonNull Provider<HeartBeatController> provider2, @Background @NonNull Executor executor, @Blocking @NonNull Executor executor2, @Lightweight @NonNull Executor executor3, @Lightweight @NonNull ScheduledExecutorService scheduledExecutorService, @UiThread @NonNull Executor executor4) {
        ScheduledExecutorService scheduledExecutorService2 = scheduledExecutorService;
        Executor executor5 = executor2;
        FirebaseApp firebaseApp2 = firebaseApp;
        this(firebaseApp, new zzabj(firebaseApp2, executor5, scheduledExecutorService2), new zzca(firebaseApp.getApplicationContext(), firebaseApp.getPersistenceKey()), zzcf.zzc(), com.google.firebase.auth.internal.zza.zza(), provider, provider2, executor, executor2, executor3, executor4);
    }

    @VisibleForTesting
    private FirebaseAuth(FirebaseApp firebaseApp, zzabj zzabj2, zzca zzca2, zzcf zzcf2, com.google.firebase.auth.internal.zza zza2, Provider<InteropAppCheckTokenProvider> provider, Provider<HeartBeatController> provider2, @Background Executor executor, @Blocking Executor executor2, @Lightweight Executor executor3, @UiThread Executor executor4) {
        zzagl zzagl2;
        this.zzb = new CopyOnWriteArrayList<IdTokenListener>();
        this.zzc = new CopyOnWriteArrayList<com.google.firebase.auth.internal.IdTokenListener>();
        this.zzd = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzh = new Object();
        this.zzj = new Object();
        this.zzm = RecaptchaAction.custom((String)"getOobCode");
        this.zzn = RecaptchaAction.custom((String)"signInWithPassword");
        this.zzo = RecaptchaAction.custom((String)"signUpPassword");
        this.zzp = RecaptchaAction.custom((String)"sendVerificationCode");
        this.zzq = RecaptchaAction.custom((String)"mfaSmsEnrollment");
        this.zzr = RecaptchaAction.custom((String)"mfaSmsSignIn");
        this.zza = (FirebaseApp)Preconditions.checkNotNull((Object)firebaseApp);
        this.zze = (zzabj)Preconditions.checkNotNull((Object)zzabj2);
        this.zzs = (zzca)Preconditions.checkNotNull((Object)zzca2);
        this.zzg = new zzae();
        this.zzt = (zzcf)Preconditions.checkNotNull((Object)zzcf2);
        this.zzu = (com.google.firebase.auth.internal.zza)Preconditions.checkNotNull((Object)zza2);
        this.zzv = provider;
        this.zzw = provider2;
        this.zzy = executor2;
        this.zzz = executor3;
        this.zzaa = executor4;
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zzf = firebaseAuth.zzs.zza();
        if (firebaseAuth.zzf != null && (zzagl2 = firebaseAuth.zzs.zza(firebaseAuth.zzf)) != null) {
            FirebaseAuth.zza(firebaseAuth, firebaseAuth.zzf, zzagl2, false, false);
        }
        firebaseAuth.zzt.zza(firebaseAuth);
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzd.add(authStateListener);
        this.zzaa.execute(new zzu(this, authStateListener));
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzb.add(idTokenListener);
        this.zzaa.execute(new zzh(this, idTokenListener));
    }

    @KeepForSdk
    public void addIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener idTokenListener) {
        Preconditions.checkNotNull((Object)idTokenListener);
        this.zzc.add(idTokenListener);
        this.zzj().zza(this.zzc.size());
    }

    public final void zzh() {
        Preconditions.checkNotNull((Object)this.zzs);
        if (this.zzf != null) {
            FirebaseUser firebaseUser = this.zzf;
            zzca zzca2 = this.zzs;
            Preconditions.checkNotNull((Object)firebaseUser);
            zzca2.zza(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()));
            this.zzf = null;
        }
        this.zzs.zza("com.google.firebase.auth.FIREBASE_USER");
        FirebaseAuth.zzb(this, null);
        FirebaseAuth.zza(this, null);
    }

    public static void zza(@NonNull FirebaseException firebaseException, @NonNull PhoneAuthOptions phoneAuthOptions, @NonNull String string) {
        Object object = string;
        Log.e((String)"FirebaseAuth", (String)("Invoking verification failure callback for phone number/uid - " + (String)object));
        PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks = zzaer.zza(string, phoneAuthOptions.zze(), null);
        FirebaseException firebaseException2 = firebaseException;
        object = onVerificationStateChangedCallbacks;
        phoneAuthOptions.zzi().execute(new zzi((PhoneAuthProvider.OnVerificationStateChangedCallbacks)object, firebaseException2));
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzd.remove(authStateListener);
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzb.remove(idTokenListener);
    }

    @KeepForSdk
    public void removeIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener idTokenListener) {
        Preconditions.checkNotNull((Object)idTokenListener);
        this.zzc.remove(idTokenListener);
        this.zzj().zza(this.zzc.size());
    }

    public void setCustomAuthDomain(@NonNull String string) {
        String string2;
        String string3;
        Preconditions.checkNotEmpty((String)string);
        if (string.startsWith("chrome-extension://")) {
            this.zzab = string;
            return;
        }
        if (string.contains("://")) {
            string3 = string;
        } else {
            string2 = string;
            string3 = "http://" + string2;
        }
        String string4 = string3;
        try {
            URI uRI = new URI(string4);
            this.zzab = (String)Preconditions.checkNotNull((Object)uRI.getHost());
            return;
        }
        catch (URISyntaxException uRISyntaxException) {
            if (Log.isLoggable((String)"FirebaseAuth", (int)4)) {
                String string5 = uRISyntaxException.getMessage();
                string2 = string;
                Log.i((String)"FirebaseAuth", (String)("Error parsing URL: '" + string2 + "', " + string5));
            }
            this.zzab = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguageCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Object object = this.zzh;
        synchronized (object) {
            this.zzi = string;
            return;
        }
    }

    public final synchronized void zza(zzbv zzbv2) {
        this.zzl = zzbv2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTenantId(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Object object = this.zzj;
        synchronized (object) {
            this.zzk = string;
            return;
        }
    }

    public final void zza(FirebaseUser firebaseUser, zzagl zzagl2, boolean bl) {
        this.zza(firebaseUser, zzagl2, true, false);
    }

    @VisibleForTesting
    final void zza(FirebaseUser firebaseUser, zzagl zzagl2, boolean bl, boolean bl2) {
        FirebaseAuth.zza(this, firebaseUser, zzagl2, true, bl2);
    }

    public void signOut() {
        this.zzh();
        if (this.zzx != null) {
            this.zzx.zza();
        }
    }

    private static void zza(@UnknownInitialization FirebaseAuth firebaseAuth, @Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)("Notifying auth state listeners about user ( " + string + " )."));
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        firebaseAuth.zzaa.execute(new zzy(firebaseAuth));
    }

    private static void zzb(@UnknownInitialization FirebaseAuth firebaseAuth, @Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)("Notifying id token listeners about user ( " + string + " )."));
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        String string = firebaseUser != null ? firebaseUser.zzd() : null;
        InternalTokenResult internalTokenResult = new InternalTokenResult(string);
        firebaseAuth.zzaa.execute(new zzv(firebaseAuth, internalTokenResult));
    }

    @VisibleForTesting
    private static void zza(@UnknownInitialization FirebaseAuth firebaseAuth, FirebaseUser firebaseUser, zzagl zzagl2, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4;
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzagl2);
        boolean bl5 = firebaseAuth.zzf != null && firebaseUser.getUid().equals(firebaseAuth.zzf.getUid());
        if (!bl5 && bl2) {
            return;
        }
        if (firebaseAuth.zzf == null) {
            bl4 = true;
            bl3 = true;
        } else {
            String string;
            String string2 = firebaseAuth.zzf.zzc().zzc();
            boolean bl6 = !string2.equals(string = zzagl2.zzc());
            bl4 = !bl5 || bl6;
            bl3 = !bl5;
        }
        boolean bl7 = bl3;
        boolean bl8 = bl;
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth2 = firebaseAuth;
        Preconditions.checkNotNull((Object)firebaseUser2);
        if (firebaseAuth2.zzf == null || !firebaseUser2.getUid().equals(firebaseAuth2.getUid())) {
            firebaseAuth2.zzf = firebaseUser2;
        } else {
            firebaseAuth2.zzf.zza(firebaseUser2.getProviderData());
            if (!firebaseUser2.isAnonymous()) {
                firebaseAuth2.zzf.zzb();
            }
            List<MultiFactorInfo> list = firebaseUser2.getMultiFactor().getEnrolledFactors();
            List<zzan> list2 = firebaseUser2.zzf();
            firebaseAuth2.zzf.zzc(list);
            firebaseAuth2.zzf.zzb(list2);
        }
        if (bl8) {
            firebaseAuth2.zzs.zzb(firebaseAuth2.zzf);
        }
        if (bl4) {
            if (firebaseAuth.zzf != null) {
                firebaseAuth.zzf.zza(zzagl2);
            }
            FirebaseAuth.zzb(firebaseAuth, firebaseAuth.zzf);
        }
        if (bl7) {
            FirebaseAuth.zza(firebaseAuth, firebaseAuth.zzf);
        }
        if (bl) {
            firebaseAuth.zzs.zza(firebaseUser, zzagl2);
        }
        firebaseAuth2 = firebaseAuth;
        firebaseUser2 = firebaseAuth2.zzf;
        if (firebaseUser2 != null) {
            FirebaseAuth.zzj(firebaseAuth2).zza(firebaseUser2.zzc());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAppLanguage() {
        Object object = this.zzh;
        synchronized (object) {
            this.zzi = zzadx.zza();
            return;
        }
    }

    public void useEmulator(@NonNull String string, int n) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkArgument((n >= 0 && n <= 65535 ? 1 : 0) != 0, (Object)"Port number must be in the range 0-65535");
        zzafb.zza(this.zza, string, n);
    }

    public static void zza(@NonNull PhoneAuthOptions phoneAuthOptions) {
        if (phoneAuthOptions.zzm()) {
            PhoneMultiFactorInfo phoneMultiFactorInfo;
            String string;
            String string2;
            PhoneAuthOptions phoneAuthOptions2 = phoneAuthOptions;
            FirebaseAuth firebaseAuth = phoneAuthOptions.zzb();
            zzao zzao2 = (zzao)((Object)Preconditions.checkNotNull((Object)((Object)phoneAuthOptions2.zzc())));
            if (zzao2.zzd()) {
                string = string2 = Preconditions.checkNotEmpty((String)phoneAuthOptions2.zzh());
            } else {
                phoneMultiFactorInfo = (PhoneMultiFactorInfo)((Object)Preconditions.checkNotNull((Object)((Object)phoneAuthOptions2.zzf())));
                string2 = Preconditions.checkNotEmpty((String)((MultiFactorInfo)phoneMultiFactorInfo).getUid());
                string = phoneMultiFactorInfo.getPhoneNumber();
            }
            if (phoneAuthOptions2.zzd() == null || !zzaer.zza(string2, phoneAuthOptions2.zze(), phoneAuthOptions2.zza(), phoneAuthOptions2.zzi())) {
                phoneMultiFactorInfo = zzao2.zzd() ? firebaseAuth.zzq : firebaseAuth.zzr;
                firebaseAuth.zzu.zza(firebaseAuth, string, phoneAuthOptions2.zza(), firebaseAuth.zzi(), phoneAuthOptions2.zzj(), phoneAuthOptions2.zzl(), (RecaptchaAction)phoneMultiFactorInfo).addOnCompleteListener((OnCompleteListener)new zzj(firebaseAuth, phoneAuthOptions2, string2));
            }
            return;
        }
        PhoneAuthOptions phoneAuthOptions3 = phoneAuthOptions;
        FirebaseAuth firebaseAuth = phoneAuthOptions.zzb();
        String string = Preconditions.checkNotEmpty((String)phoneAuthOptions3.zzh());
        if (phoneAuthOptions3.zzd() != null || !zzaer.zza(string, phoneAuthOptions3.zze(), phoneAuthOptions3.zza(), phoneAuthOptions3.zzi())) {
            firebaseAuth.zzu.zza(firebaseAuth, string, phoneAuthOptions3.zza(), firebaseAuth.zzi(), phoneAuthOptions3.zzj(), phoneAuthOptions3.zzl(), firebaseAuth.zzp).addOnCompleteListener((OnCompleteListener)new zzk(firebaseAuth, phoneAuthOptions3, string));
        }
    }

    public final void zza(PhoneAuthOptions phoneAuthOptions, com.google.firebase.auth.internal.zzh zzh2) {
        long l = phoneAuthOptions.zzg();
        if (l < 0L || l > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        String string = Preconditions.checkNotEmpty((String)phoneAuthOptions.zzh());
        String string2 = zzh2.zzc();
        String string3 = zzh2.zzb();
        String string4 = zzh2.zzd();
        if (zzag.zzc(string2) && this.zzb() != null && this.zzb().zza("PHONE_PROVIDER")) {
            string2 = "NO_RECAPTCHA";
        }
        zzagz zzagz2 = new zzagz(string, l, phoneAuthOptions.zzd() != null, this.zzi, this.zzk, string4, string3, string2, this.zzi());
        PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks = this.zza(string, phoneAuthOptions.zze());
        if (TextUtils.isEmpty((CharSequence)zzh2.zzd())) {
            com.google.firebase.auth.internal.zzh zzh3 = com.google.firebase.auth.internal.zzh.zza().zzc(string4).zzb(string2).zza(string3).zza();
            onVerificationStateChangedCallbacks = this.zza(phoneAuthOptions, onVerificationStateChangedCallbacks, zzh3);
        }
        this.zze.zza(this.zza, zzagz2, onVerificationStateChangedCallbacks, phoneAuthOptions.zza(), phoneAuthOptions.zzi());
    }

    @VisibleForTesting
    final boolean zzi() {
        return zzadn.zza(this.getApp().getApplicationContext());
    }

    public boolean isSignInWithEmailLink(@NonNull String string) {
        return EmailAuthCredential.zza(string);
    }

    private final boolean zzb(String string) {
        ActionCodeUrl actionCodeUrl = ActionCodeUrl.parseLink(string);
        return actionCodeUrl != null && !TextUtils.equals((CharSequence)this.zzk, (CharSequence)actionCodeUrl.zza());
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull @UnknownInitialization FirebaseAuth var1);
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    @VisibleForTesting
    class zza
    implements com.google.firebase.auth.internal.zzj {
        zza() {
        }

        @Override
        public final void zza(zzagl zzagl2, FirebaseUser firebaseUser) {
            Preconditions.checkNotNull((Object)zzagl2);
            Preconditions.checkNotNull((Object)firebaseUser);
            firebaseUser.zza(zzagl2);
            FirebaseAuth.this.zza(firebaseUser, zzagl2, true);
        }
    }

    @VisibleForTesting
    final class zzb
    implements zzaw,
    com.google.firebase.auth.internal.zzj {
        zzb() {
        }

        @Override
        public final void zza(zzagl zzagl2, FirebaseUser firebaseUser) {
            Preconditions.checkNotNull((Object)zzagl2);
            Preconditions.checkNotNull((Object)firebaseUser);
            firebaseUser.zza(zzagl2);
            FirebaseAuth.this.zza(firebaseUser, zzagl2, true, true);
        }

        @Override
        public final void zza(Status status) {
            if (status.getStatusCode() == 17011 || status.getStatusCode() == 17021 || status.getStatusCode() == 17005 || status.getStatusCode() == 17091) {
                FirebaseAuth.this.signOut();
            }
        }
    }

    final class zzc
    extends zza
    implements zzaw,
    com.google.firebase.auth.internal.zzj {
        zzc(FirebaseAuth firebaseAuth) {
        }

        @Override
        public final void zza(Status status) {
        }
    }
}

