/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase-auth-api.zzap;
import java.util.HashMap;
import java.util.Set;

public class ActionCodeUrl {
    private static final zzap<String, Integer> zza;
    private final String zzb;
    private final String zzc;
    private final String zzd;
    @Nullable
    private final String zze;
    @Nullable
    private final String zzf;
    @Nullable
    private final String zzg;

    public int getOperation() {
        if (zza.containsKey(this.zzd)) {
            return zza.get(this.zzd);
        }
        return 3;
    }

    @Nullable
    public static ActionCodeUrl parseLink(@Nullable String string) {
        Preconditions.checkNotEmpty((String)string);
        try {
            return new ActionCodeUrl(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @NonNull
    public String getApiKey() {
        return this.zzb;
    }

    @Nullable
    public String getCode() {
        return this.zzc;
    }

    @Nullable
    public String getContinueUrl() {
        return this.zze;
    }

    @Nullable
    public String getLanguageCode() {
        return this.zzf;
    }

    @Nullable
    public final String zza() {
        return this.zzg;
    }

    @Nullable
    private static String zza(String string, String string2) {
        Uri uri = Uri.parse((String)string);
        try {
            Set set = uri.getQueryParameterNames();
            if (set.contains(string2)) {
                return uri.getQueryParameter(string2);
            }
            if (set.contains("link")) {
                return Uri.parse((String)Preconditions.checkNotEmpty((String)uri.getQueryParameter("link"))).getQueryParameter(string2);
            }
        }
        catch (NullPointerException | UnsupportedOperationException runtimeException) {}
        return null;
    }

    static {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("recoverEmail", 2);
        hashMap.put("resetPassword", 0);
        hashMap.put("signIn", 4);
        hashMap.put("verifyEmail", 1);
        hashMap.put("verifyBeforeChangeEmail", 5);
        hashMap.put("revertSecondFactorAddition", 6);
        zza = zzap.zza(hashMap);
    }

    private ActionCodeUrl(String string) {
        String string2 = ActionCodeUrl.zza(string, "apiKey");
        String string3 = ActionCodeUrl.zza(string, "oobCode");
        String string4 = ActionCodeUrl.zza(string, "mode");
        if (string2 == null || string3 == null || string4 == null) {
            throw new IllegalArgumentException(String.format("%s, %s and %s are required in a valid action code URL", "apiKey", "oobCode", "mode"));
        }
        this.zzb = Preconditions.checkNotEmpty((String)string2);
        this.zzc = Preconditions.checkNotEmpty((String)string3);
        this.zzd = Preconditions.checkNotEmpty((String)string4);
        this.zze = ActionCodeUrl.zza(string, "continueUrl");
        this.zzf = ActionCodeUrl.zza(string, "languageCode");
        this.zzg = ActionCodeUrl.zza(string, "tenantId");
    }
}

