/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzil;
import com.google.android.gms.internal.firebase-auth-api.zzrq;
import com.google.android.gms.internal.firebase-auth-api.zzyw;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;

public final class zzyx
implements zzrq {
    private static final zzil.zza zza = zzil.zza.zzb;
    private final ThreadLocal<Mac> zzb = new zzyw(this);
    private final String zzc;
    private final Key zzd;
    private final int zze;

    static /* bridge */ /* synthetic */ String zza(zzyx zzyx2) {
        return zzyx2.zzc;
    }

    static /* bridge */ /* synthetic */ Key zzb(zzyx zzyx2) {
        return zzyx2.zzd;
    }

    public zzyx(String string, Key key) throws GeneralSecurityException {
        if (!zza.zza()) {
            throw new GeneralSecurityException("Can not use HMAC in FIPS-mode, as BoringCrypto module is not available.");
        }
        this.zzc = string;
        this.zzd = key;
        if (key.getEncoded().length < 16) {
            throw new InvalidAlgorithmParameterException("key size too small, need at least 16 bytes");
        }
        switch (string) {
            case "HMACSHA1": {
                this.zze = 20;
                break;
            }
            case "HMACSHA224": {
                this.zze = 28;
                break;
            }
            case "HMACSHA256": {
                this.zze = 32;
                break;
            }
            case "HMACSHA384": {
                this.zze = 48;
                break;
            }
            case "HMACSHA512": {
                this.zze = 64;
                break;
            }
            default: {
                String string2 = string;
                throw new NoSuchAlgorithmException("unknown Hmac algorithm: " + string2);
            }
        }
        this.zzb.get();
    }

    @Override
    public final byte[] zza(byte[] byArray, int n) throws GeneralSecurityException {
        if (n > this.zze) {
            throw new InvalidAlgorithmParameterException("tag size too big");
        }
        this.zzb.get().update(byArray);
        return Arrays.copyOf(this.zzb.get().doFinal(), n);
    }
}

