/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.util.Arrays;

public final class zzmj {
    public static BigInteger zza(byte[] byArray) {
        return new BigInteger(1, byArray);
    }

    public static byte[] zza(BigInteger bigInteger) {
        if (bigInteger.signum() == -1) {
            throw new IllegalArgumentException("n must not be negative");
        }
        return bigInteger.toByteArray();
    }

    public static byte[] zza(BigInteger bigInteger, int n) throws GeneralSecurityException {
        if (bigInteger.signum() == -1) {
            throw new IllegalArgumentException("integer must be nonnegative");
        }
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == n) {
            return byArray;
        }
        if (byArray.length > n + 1) {
            throw new GeneralSecurityException("integer too large");
        }
        if (byArray.length == n + 1) {
            if (byArray[0] == 0) {
                return Arrays.copyOfRange(byArray, 1, byArray.length);
            }
            throw new GeneralSecurityException("integer too large");
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
        return byArray2;
    }
}

