/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzbp;
import com.google.android.gms.internal.firebase-auth-api.zzbq;
import com.google.android.gms.internal.firebase-auth-api.zzju;
import com.google.android.gms.internal.firebase-auth-api.zzke;
import com.google.android.gms.internal.firebase-auth-api.zzko;
import com.google.android.gms.internal.firebase-auth-api.zzkr;
import com.google.android.gms.internal.firebase-auth-api.zzmj;
import com.google.android.gms.internal.firebase-auth-api.zzmk;
import com.google.android.gms.internal.firebase-auth-api.zzyb;
import com.google.android.gms.internal.firebase-auth-api.zzyd;
import com.google.android.gms.internal.firebase-auth-api.zzza;
import com.google.android.gms.internal.firebase-auth-api.zzze;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.Arrays;

public final class zzjw
extends zzko {
    private final zzke zza;
    private final zzze zzb;

    @Override
    public final /* synthetic */ zzbp zzb() {
        return (zzke)((zzko)this).zzd();
    }

    public final zzju zzc() {
        return this.zza.zzb();
    }

    public static zzjw zza(zzke zzke2, zzze zzze2) throws GeneralSecurityException {
        int n;
        if (zzke2 == null) {
            throw new GeneralSecurityException("HPKE private key cannot be constructed without an HPKE public key");
        }
        if (zzze2 == null) {
            throw new GeneralSecurityException("HPKE private key cannot be constructed without secret");
        }
        Object object = zzze2;
        zzju.zzf zzf2 = zzke2.zzb().zze();
        int n2 = n = ((zzze)object).zza();
        Object object2 = String.valueOf(zzf2);
        Object object3 = "Encoded private key byte length for " + (String)object2 + " must be %d, not " + n2;
        if (zzf2 == zzju.zzf.zza) {
            if (n != 32) {
                throw new GeneralSecurityException(String.format((String)object3, 32));
            }
        } else if (zzf2 == zzju.zzf.zzb) {
            if (n != 48) {
                throw new GeneralSecurityException(String.format((String)object3, 48));
            }
        } else if (zzf2 == zzju.zzf.zzc) {
            if (n != 66) {
                throw new GeneralSecurityException(String.format((String)object3, 66));
            }
        } else if (zzf2 == zzju.zzf.zzd) {
            if (n != 32) {
                throw new GeneralSecurityException(String.format((String)object3, 32));
            }
        } else {
            object2 = String.valueOf(zzf2);
            throw new GeneralSecurityException("Unable to validate private key length for " + (String)object2);
        }
        byte[] byArray = zzze2.zza(zzbq.zza());
        object = zzke2.zzd().zzb();
        zzju.zzf zzf3 = zzf2 = zzke2.zzb().zze();
        if (zzf2 == zzju.zzf.zza || zzf3 == zzju.zzf.zzb || zzf3 == zzju.zzf.zzc) {
            ECPoint eCPoint;
            ECParameterSpec eCParameterSpec;
            zzf3 = zzf2;
            if (zzf3 == zzju.zzf.zza) {
                eCParameterSpec = zzmk.zza;
            } else if (zzf3 == zzju.zzf.zzb) {
                eCParameterSpec = zzmk.zzb;
            } else if (zzf3 == zzju.zzf.zzc) {
                eCParameterSpec = zzmk.zzc;
            } else {
                String string = String.valueOf(zzf3);
                throw new IllegalArgumentException("Unable to determine NIST curve params for " + string);
            }
            object3 = eCParameterSpec;
            object2 = eCParameterSpec.getOrder();
            BigInteger bigInteger = zzmj.zza(byArray);
            if (bigInteger.signum() <= 0 || bigInteger.compareTo((BigInteger)object2) >= 0) {
                throw new GeneralSecurityException("Invalid private key.");
            }
            ECPoint eCPoint2 = zzmk.zza(bigInteger, (ECParameterSpec)object3);
            if (!eCPoint2.equals(eCPoint = zzyb.zza(((ECParameterSpec)object3).getCurve(), zzyd.zza, (byte[])object))) {
                throw new GeneralSecurityException("Invalid private key for public key.");
            }
        } else if (zzf2 == zzju.zzf.zzd) {
            if (!Arrays.equals(zzza.zza(byArray), (byte[])object)) {
                throw new GeneralSecurityException("Invalid private key for public key.");
            }
        } else {
            String string = String.valueOf(zzf2);
            throw new IllegalArgumentException("Unable to validate key pair for " + string);
        }
        return new zzjw(zzke2, zzze2);
    }

    @Override
    public final /* synthetic */ zzkr zzd() {
        return this.zza;
    }

    public final zzze zze() {
        return this.zzb;
    }

    private zzjw(zzke zzke2, zzze zzze2) {
        this.zza = zzke2;
        this.zzb = zzze2;
    }
}

