/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzbp;
import com.google.android.gms.internal.firebase-auth-api.zzbq;
import com.google.android.gms.internal.firebase-auth-api.zzjp;
import com.google.android.gms.internal.firebase-auth-api.zzjv;
import com.google.android.gms.internal.firebase-auth-api.zzko;
import com.google.android.gms.internal.firebase-auth-api.zzkr;
import com.google.android.gms.internal.firebase-auth-api.zzmk;
import com.google.android.gms.internal.firebase-auth-api.zzza;
import com.google.android.gms.internal.firebase-auth-api.zzze;
import com.google.android.gms.internal.firebase-auth-api.zzzf;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class zzjs
extends zzko {
    private final zzjv zza;
    @Nullable
    private final zzzf zzb;
    @Nullable
    private final zzze zzc;

    @Override
    public final /* synthetic */ zzbp zzb() {
        return (zzjv)((zzko)this).zzd();
    }

    public final zzjp zzc() {
        return this.zza.zzb();
    }

    public static zzjs zza(zzjv zzjv2, zzze zzze2) throws GeneralSecurityException {
        if (zzjv2 == null) {
            throw new GeneralSecurityException("ECIES private key cannot be constructed without an ECIES public key");
        }
        if (zzjv2.zzd() == null) {
            throw new GeneralSecurityException("ECIES private key for X25519 curve cannot be constructed with NIST-curve public key");
        }
        if (zzze2 == null) {
            throw new GeneralSecurityException("ECIES private key cannot be constructed without secret");
        }
        byte[] byArray = zzjv2.zzd().zzb();
        byte[] byArray2 = zzze2.zza(zzbq.zza());
        if (byArray2.length != 32) {
            throw new GeneralSecurityException("Private key bytes length for X25519 curve must be 32");
        }
        if (!Arrays.equals(zzza.zza(byArray2), byArray)) {
            throw new GeneralSecurityException("Invalid private key for public key.");
        }
        return new zzjs(zzjv2, null, zzze2);
    }

    public static zzjs zza(zzjv zzjv2, zzzf zzzf2) throws GeneralSecurityException {
        if (zzjv2 == null) {
            throw new GeneralSecurityException("ECIES private key cannot be constructed without an ECIES public key");
        }
        if (zzjv2.zze() == null) {
            throw new GeneralSecurityException("ECIES private key for NIST curve cannot be constructed with X25519-curve public key");
        }
        if (zzzf2 == null) {
            throw new GeneralSecurityException("ECIES private key cannot be constructed without secret");
        }
        zzjp.zzc zzc2 = zzjv2.zzb().zzd();
        ECPoint eCPoint = zzjv2.zze();
        BigInteger bigInteger = zzzf2.zza(zzbq.zza());
        BigInteger bigInteger2 = zzjs.zza(zzc2).getOrder();
        if (bigInteger.signum() <= 0 || bigInteger.compareTo(bigInteger2) >= 0) {
            throw new GeneralSecurityException("Invalid private value");
        }
        if (!zzmk.zza(bigInteger, zzjs.zza(zzc2)).equals(eCPoint)) {
            throw new GeneralSecurityException("Invalid private value");
        }
        return new zzjs(zzjv2, zzzf2, null);
    }

    @Override
    public final /* synthetic */ zzkr zzd() {
        return this.zza;
    }

    @Nullable
    public final zzzf zze() {
        return this.zzb;
    }

    @Nullable
    public final zzze zzf() {
        return this.zzc;
    }

    private static ECParameterSpec zza(zzjp.zzc zzc2) {
        if (zzc2 == zzjp.zzc.zza) {
            return zzmk.zza;
        }
        if (zzc2 == zzjp.zzc.zzb) {
            return zzmk.zzb;
        }
        if (zzc2 == zzjp.zzc.zzc) {
            return zzmk.zzc;
        }
        String string = String.valueOf(zzc2);
        throw new IllegalArgumentException("Unable to determine NIST curve type for " + string);
    }

    private zzjs(zzjv zzjv2, @Nullable zzzf zzzf2, @Nullable zzze zzze2) {
        this.zza = zzjv2;
        this.zzb = zzzf2;
        this.zzc = zzze2;
    }
}

