/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzbg;
import com.google.android.gms.internal.firebase-auth-api.zzbq;
import com.google.android.gms.internal.firebase-auth-api.zzdx;
import com.google.android.gms.internal.firebase-auth-api.zzij;
import com.google.android.gms.internal.firebase-auth-api.zzpe;
import com.google.android.gms.internal.firebase-auth-api.zzpr;
import com.google.android.gms.internal.firebase-auth-api.zzxv;
import com.google.android.gms.internal.firebase-auth-api.zzyt;
import com.google.android.gms.internal.firebase-auth-api.zzzb;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzik
implements zzbg {
    private static final byte[] zza = zzyt.zza("7a806c");
    private static final byte[] zzb = zzyt.zza("46bb91c3c5");
    private static final byte[] zzc = zzyt.zza("36864200e0eaf5284d884a0e77d31646");
    private static final byte[] zzd = zzyt.zza("bae8e37fc83441b16034566b");
    private static final byte[] zze = zzyt.zza("af60eb711bd85bc1e4d3e0a462e074eea428a8");
    private static final ThreadLocal<Cipher> zzf = new zzij();
    private final SecretKey zzg;
    private final byte[] zzh;

    public static zzbg zza(zzdx zzdx2) throws GeneralSecurityException {
        return new zzik(zzdx2.zze().zza(zzbq.zza()), zzdx2.zzd().zzb());
    }

    private static AlgorithmParameterSpec zza(byte[] byArray, int n, int n2) throws GeneralSecurityException {
        return new GCMParameterSpec(128, byArray, 0, n2);
    }

    private static Cipher zza() throws GeneralSecurityException {
        Cipher cipher = zzf.get();
        if (cipher == null) {
            throw new GeneralSecurityException("AES GCM SIV cipher is not available or is invalid.");
        }
        return cipher;
    }

    private zzik(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        this.zzh = byArray2;
        zzzb.zza(byArray.length);
        this.zzg = new SecretKeySpec(byArray, "AES");
    }

    static /* synthetic */ boolean zza(Cipher cipher) {
        return zzik.zzb(cipher);
    }

    private static boolean zzb(Cipher cipher) {
        try {
            byte[] byArray = zzd;
            AlgorithmParameterSpec algorithmParameterSpec = zzik.zza(zzd, 0, byArray.length);
            cipher.init(2, (Key)new SecretKeySpec(zzc, "AES"), algorithmParameterSpec);
            cipher.updateAAD(zzb);
            return MessageDigest.isEqual(cipher.doFinal(zze, 0, zze.length), zza);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (this.zzh.length == 0) {
            return this.zzc(byArray, byArray2);
        }
        if (!zzpr.zza(this.zzh, byArray)) {
            throw new GeneralSecurityException("Decryption failed (OutputPrefix mismatch).");
        }
        byte[] byArray3 = Arrays.copyOfRange(byArray, this.zzh.length, byArray.length);
        return this.zzc(byArray3, byArray2);
    }

    @Override
    public final byte[] zzb(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n;
        byte[] byArray3 = byArray2;
        byte[] byArray4 = byArray;
        zzik zzik2 = this;
        Cipher cipher = zzik.zza();
        if (byArray4.length > 2147483619) {
            throw new GeneralSecurityException("plaintext too long");
        }
        byte[] byArray5 = new byte[12 + byArray4.length + 16];
        byte[] byArray6 = zzpe.zza(12);
        System.arraycopy(byArray6, 0, byArray5, 0, 12);
        byte[] byArray7 = byArray6;
        AlgorithmParameterSpec algorithmParameterSpec = zzik.zza(byArray6, 0, byArray7.length);
        cipher.init(1, (Key)zzik2.zzg, algorithmParameterSpec);
        if (byArray3 != null && byArray3.length != 0) {
            cipher.updateAAD(byArray3);
        }
        if ((n = cipher.doFinal(byArray4, 0, byArray4.length, byArray5, 12)) != byArray4.length + 16) {
            int n2 = n - byArray4.length;
            throw new GeneralSecurityException(String.format("encryption failed; GCM tag must be %s bytes, but got only %s bytes", 16, n2));
        }
        byte[] byArray8 = byArray5;
        if (this.zzh.length == 0) {
            return byArray8;
        }
        return zzxv.zza(new byte[][]{this.zzh, byArray8});
    }

    private final byte[] zzc(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        Cipher cipher = zzik.zza();
        if (byArray.length < 28) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        AlgorithmParameterSpec algorithmParameterSpec = zzik.zza(byArray, 0, 12);
        cipher.init(2, (Key)this.zzg, algorithmParameterSpec);
        if (byArray2 != null && byArray2.length != 0) {
            cipher.updateAAD(byArray2);
        }
        return cipher.doFinal(byArray, 12, byArray.length - 12);
    }
}

