/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzbg;
import com.google.android.gms.internal.firebase-auth-api.zzbq;
import com.google.android.gms.internal.firebase-auth-api.zzee;
import com.google.android.gms.internal.firebase-auth-api.zzhb;
import com.google.android.gms.internal.firebase-auth-api.zzil;
import com.google.android.gms.internal.firebase-auth-api.zzpe;
import com.google.android.gms.internal.firebase-auth-api.zzpr;
import com.google.android.gms.internal.firebase-auth-api.zzyt;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzhc
implements zzbg {
    private static final zzil.zza zza = zzil.zza.zza;
    private static final byte[] zzb = zzyt.zza("808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9f");
    private static final byte[] zzc = zzyt.zza("070000004041424344454647");
    private static final byte[] zzd = zzyt.zza("a0784d7a4716f3feb4f64e7f4b39bf04");
    private static final ThreadLocal<Cipher> zze = new zzhb();
    private final SecretKey zzf;
    private final byte[] zzg;

    public static zzbg zza(zzee zzee2) throws GeneralSecurityException {
        return new zzhc(zzee2.zzd().zza(zzbq.zza()), zzee2.zzc().zzb());
    }

    @Nullable
    static Cipher zza() {
        return zze.get();
    }

    private zzhc(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (!zza.zza()) {
            throw new GeneralSecurityException("Can not use ChaCha20Poly1305 in FIPS-mode.");
        }
        if (!zzhc.zzb()) {
            throw new GeneralSecurityException("JCE does not support algorithm: ChaCha20-Poly1305");
        }
        if (byArray.length != 32) {
            throw new InvalidKeyException("The key length in bytes must be 32.");
        }
        this.zzf = new SecretKeySpec(byArray, "ChaCha20");
        this.zzg = byArray2;
    }

    static /* synthetic */ boolean zza(Cipher cipher) {
        return zzhc.zzb(cipher);
    }

    public static boolean zzb() {
        return zze.get() != null;
    }

    private static boolean zzb(Cipher cipher) {
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(zzc);
            cipher.init(2, (Key)new SecretKeySpec(zzb, "ChaCha20"), ivParameterSpec);
            if (cipher.doFinal(zzd).length != 0) {
                return false;
            }
            cipher.init(2, (Key)new SecretKeySpec(zzb, "ChaCha20"), ivParameterSpec);
            return cipher.doFinal(zzd).length == 0;
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byArray == null) {
            throw new NullPointerException("ciphertext is null");
        }
        if (byArray.length < this.zzg.length + 12 + 16) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        if (!zzpr.zza(this.zzg, byArray)) {
            throw new GeneralSecurityException("Decryption failed (OutputPrefix mismatch).");
        }
        byte[] byArray3 = new byte[12];
        System.arraycopy(byArray, this.zzg.length, byArray3, 0, 12);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
        Cipher cipher = zze.get();
        cipher.init(2, (Key)this.zzf, ivParameterSpec);
        if (byArray2 != null && byArray2.length != 0) {
            cipher.updateAAD(byArray2);
        }
        int n = this.zzg.length + 12;
        int n2 = byArray.length - this.zzg.length - 12;
        return cipher.doFinal(byArray, n, n2);
    }

    @Override
    public final byte[] zzb(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n;
        if (byArray == null) {
            throw new NullPointerException("plaintext is null");
        }
        byte[] byArray3 = zzpe.zza(12);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
        Cipher cipher = zze.get();
        cipher.init(1, (Key)this.zzf, ivParameterSpec);
        if (byArray2 != null && byArray2.length != 0) {
            cipher.updateAAD(byArray2);
        }
        if ((n = cipher.getOutputSize(byArray.length)) > Integer.MAX_VALUE - this.zzg.length - 12) {
            throw new GeneralSecurityException("plaintext too long");
        }
        int n2 = this.zzg.length + 12 + n;
        byte[] byArray4 = Arrays.copyOf(this.zzg, n2);
        System.arraycopy(byArray3, 0, byArray4, this.zzg.length, 12);
        if (cipher.doFinal(byArray, 0, byArray.length, byArray4, this.zzg.length + 12) != n) {
            throw new GeneralSecurityException("not enough data written");
        }
        return byArray4;
    }
}

