/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzaip;
import com.google.android.gms.internal.firebase-auth-api.zzajk;
import com.google.android.gms.internal.firebase-auth-api.zzajy;
import com.google.android.gms.internal.firebase-auth-api.zzakf;
import com.google.android.gms.internal.firebase-auth-api.zzbg;
import com.google.android.gms.internal.firebase-auth-api.zzbk;
import com.google.android.gms.internal.firebase-auth-api.zzbp;
import com.google.android.gms.internal.firebase-auth-api.zzbr;
import com.google.android.gms.internal.firebase-auth-api.zzbu;
import com.google.android.gms.internal.firebase-auth-api.zzbv;
import com.google.android.gms.internal.firebase-auth-api.zzby;
import com.google.android.gms.internal.firebase-auth-api.zzbz;
import com.google.android.gms.internal.firebase-auth-api.zzca;
import com.google.android.gms.internal.firebase-auth-api.zzcb;
import com.google.android.gms.internal.firebase-auth-api.zzce;
import com.google.android.gms.internal.firebase-auth-api.zzch;
import com.google.android.gms.internal.firebase-auth-api.zzck;
import com.google.android.gms.internal.firebase-auth-api.zzcn;
import com.google.android.gms.internal.firebase-auth-api.zzco;
import com.google.android.gms.internal.firebase-auth-api.zzcs;
import com.google.android.gms.internal.firebase-auth-api.zzmq;
import com.google.android.gms.internal.firebase-auth-api.zznc;
import com.google.android.gms.internal.firebase-auth-api.zzng;
import com.google.android.gms.internal.firebase-auth-api.zzof;
import com.google.android.gms.internal.firebase-auth-api.zzoy;
import com.google.android.gms.internal.firebase-auth-api.zzoz;
import com.google.android.gms.internal.firebase-auth-api.zzpc;
import com.google.android.gms.internal.firebase-auth-api.zzuo;
import com.google.android.gms.internal.firebase-auth-api.zzvq;
import com.google.android.gms.internal.firebase-auth-api.zzvv;
import com.google.android.gms.internal.firebase-auth-api.zzwa;
import com.google.android.gms.internal.firebase-auth-api.zzws;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class zzbt {
    private final zzwa zza;
    private final List<zzca> zzb;
    private final zzng zzc;

    private static zzbp zza(zzwa.zzb zzb2) throws GeneralSecurityException {
        Object object = zzb2;
        int n = ((zzwa.zzb)object).zza();
        Object object2 = ((zzwa.zzb)object).zzf() == zzws.zzd ? null : Integer.valueOf(n);
        zzpc zzpc2 = zzpc.zza(((zzwa.zzb)object).zzb().zzf(), ((zzwa.zzb)object).zzb().zze(), ((zzwa.zzb)object).zzb().zzb(), ((zzwa.zzb)object).zzf(), (Integer)object2);
        object2 = zzcn.zza();
        zzpc zzpc3 = zzpc2;
        object = zzof.zza();
        if (!((zzof)object).zzb(zzpc3)) {
            return new zznc(zzpc3, (zzcn)object2);
        }
        return ((zzof)object).zza(zzpc3, (zzcn)object2);
    }

    private static zzbr zza(zzvv zzvv2) throws GeneralSecurityException {
        switch (zzvv2) {
            case zzb: {
                return zzbr.zza;
            }
            case zzc: {
                return zzbr.zzb;
            }
            case zzd: {
                return zzbr.zzc;
            }
        }
        throw new GeneralSecurityException("Unknown key status");
    }

    static final zzbt zza(zzwa zzwa2) throws GeneralSecurityException {
        zzbt.zzd(zzwa2);
        List<zzca> list = zzbt.zzc(zzwa2);
        return new zzbt(zzwa2, list);
    }

    public static final zzbt zza(zzbu zzbu2) throws GeneralSecurityException {
        zzch zzch2;
        zzch zzch3 = zzch2 = zzbu2.zza();
        return new zzbv().zza(new zzby(zzch3, null).zzb().zza()).zza();
    }

    public final zzbt zza() throws GeneralSecurityException {
        if (this.zza == null) {
            throw new GeneralSecurityException("cleartext keyset is not available");
        }
        zzwa.zza zza2 = zzwa.zzc();
        ArrayList<zzca> arrayList = new ArrayList<zzca>(this.zzb.size());
        int n = 0;
        for (zzca zzca2 : this.zzb) {
            zzwa.zzb zzb2;
            zzca zzca3;
            Object object;
            if (zzca2 != null && zzca2.zzb() instanceof zzck) {
                object = ((zzck)((Object)zzca2.zzb())).zzb();
                zzca3 = new zzca((zzbp)object, zzca2.zzc(), zzca2.zza(), zzca2.zzd(), null);
                zzb2 = zzbt.zzb((zzbp)object, zzca2.zzc(), zzca2.zza());
            } else {
                object = this.zza.zza(n);
                zzvq zzvq2 = ((zzwa.zzb)object).zzb();
                if (zzvq2.zzb() != zzvq.zzb.zzc) {
                    throw new GeneralSecurityException("The keyset contains a non-private key");
                }
                zzvq zzvq3 = zzco.zza(zzvq2.zzf(), zzvq2.zze());
                zzb2 = (zzwa.zzb)((zzajy)((zzwa.zzb.zza)((zzajy.zza)((zzajy)object).zzn())).zza(zzvq3).zze());
                try {
                    zzbp zzbp2 = zzbt.zza(zzb2);
                    int n2 = zzb2.zza();
                    zzca3 = new zzca(zzbp2, zzbt.zza(zzb2.zzc()), n2, n2 == this.zza.zzb(), null);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    zzca3 = null;
                }
            }
            zza2.zza(zzb2);
            arrayList.add(zzca3);
            ++n;
        }
        zza2.zza(this.zza.zzb());
        return new zzbt((zzwa)((zzajy)zza2.zze()), arrayList, this.zzc);
    }

    public static final zzbt zza(zzcb zzcb2, zzbg zzbg2, byte[] byArray) throws GeneralSecurityException, IOException {
        zzuo zzuo2;
        zzuo zzuo3 = zzuo2 = zzcb2.zza();
        if (zzuo2 == null || zzuo3.zzc().zzb() == 0) {
            throw new GeneralSecurityException("empty keyset");
        }
        return zzbt.zza(zzbt.zza(zzuo2, zzbg2, byArray));
    }

    static /* synthetic */ zzwa.zzb zza(zzbp zzbp2, zzbr zzbr2, int n) {
        return zzbt.zzb(zzbp2, zzbr2, n);
    }

    private static zzwa.zzb zzb(zzbp zzbp2, zzbr zzbr2, int n) throws GeneralSecurityException {
        zzvv zzvv2;
        zzpc zzpc2 = zzof.zza().zza(zzbp2, zzpc.class, zzcn.zza());
        Integer n2 = zzpc2.zze();
        if (n2 != null && n2 != n) {
            throw new GeneralSecurityException("Wrong ID set for key with ID requirement");
        }
        zzbr zzbr3 = zzbr2;
        if (zzbr.zza.equals(zzbr3)) {
            zzvv2 = zzvv.zzb;
        } else if (zzbr.zzb.equals(zzbr3)) {
            zzvv2 = zzvv.zzc;
        } else if (zzbr.zzc.equals(zzbr3)) {
            zzvv2 = zzvv.zzd;
        } else {
            throw new IllegalStateException("Unknown key status");
        }
        zzpc zzpc3 = zzpc2;
        zzvv zzvv3 = zzvv2;
        int n3 = n;
        return (zzwa.zzb)((zzajy)zzwa.zzb.zzd().zza(zzvq.zza().zza(zzpc3.zzf()).zza(zzpc3.zzd()).zza(zzpc3.zza())).zza(zzvv3).zza(n3).zza(zzpc3.zzb()).zze());
    }

    private static zzwa zza(zzuo zzuo2, zzbg zzbg2, byte[] byArray) throws GeneralSecurityException {
        try {
            zzwa zzwa2 = zzwa.zza(zzbg2.zza(zzuo2.zzc().zzd(), byArray), zzajk.zza());
            zzbt.zzd(zzwa2);
            return zzwa2;
        }
        catch (zzakf zzakf2) {
            throw new GeneralSecurityException("invalid keyset, corrupted key material");
        }
    }

    final zzwa zzb() {
        return this.zza;
    }

    public final <P> P zza(zzbk zzbk2, Class<P> clazz) throws GeneralSecurityException {
        if (!(zzbk2 instanceof zzmq)) {
            throw new GeneralSecurityException("Currently only subclasses of InternalConfiguration are accepted");
        }
        zzmq zzmq2 = (zzmq)zzbk2;
        Class<?> clazz2 = zzmq2.zza(clazz);
        if (clazz2 == null) {
            String string = clazz.getName();
            throw new GeneralSecurityException("No wrapper found for " + string);
        }
        return this.zza(zzmq2, clazz, clazz2);
    }

    private final <B, P> P zza(zzmq zzmq2, Class<P> clazz, Class<B> clazz2) throws GeneralSecurityException {
        zzcs.zzb(this.zza);
        zzoy<B> zzoy2 = zzoz.zza(clazz2);
        zzoy2.zza(this.zzc);
        for (int i = 0; i < this.zzb.size(); ++i) {
            B b;
            zzwa.zzb zzb2 = this.zza.zza(i);
            if (!zzb2.zzc().equals(zzvv.zzb)) continue;
            zzca zzca2 = this.zzb.get(i);
            if (zzca2 == null) {
                String string = zzb2.zzb().zzf();
                int n = i;
                throw new GeneralSecurityException("Key parsing of key with index " + n + " and type_url " + string + " failed, unable to get primitive");
            }
            zzbp zzbp2 = zzca2.zzb();
            try {
                b = zzmq2.zza(zzbp2, clazz2);
            }
            catch (GeneralSecurityException generalSecurityException) {
                String string = zzb2.zzb().zzf();
                String string2 = String.valueOf(clazz2);
                throw new GeneralSecurityException("Unable to get primitive " + string2 + " for key of type " + string + ", see https://developers.google.com/tink/faq/registration_errors", generalSecurityException);
            }
            if (zzb2.zza() == this.zza.zzb()) {
                zzoy2.zzb(b, zzbp2, zzb2);
                continue;
            }
            zzoy2.zza(b, zzbp2, zzb2);
        }
        return zzmq2.zza(zzoy2.zza(), clazz);
    }

    public final String toString() {
        return zzcs.zza(this.zza).toString();
    }

    private static List<zzca> zzc(zzwa zzwa2) {
        ArrayList<zzca> arrayList = new ArrayList<zzca>(zzwa2.zza());
        for (zzwa.zzb zzb2 : zzwa2.zze()) {
            int n = zzb2.zza();
            try {
                zzbp zzbp2 = zzbt.zza(zzb2);
                arrayList.add(new zzca(zzbp2, zzbt.zza(zzb2.zzc()), n, n == zzwa2.zzb(), null));
            }
            catch (GeneralSecurityException generalSecurityException) {
                arrayList.add(null);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    static /* synthetic */ void zzb(zzwa zzwa2) {
        zzbt.zzd(zzwa2);
    }

    private zzbt(zzwa zzwa2, List<zzca> list) {
        this.zza = zzwa2;
        this.zzb = list;
        this.zzc = zzng.zza;
    }

    private zzbt(zzwa zzwa2, List<zzca> list, zzng zzng2) {
        this.zza = zzwa2;
        this.zzb = list;
        this.zzc = zzng2;
    }

    /* synthetic */ zzbt(zzwa zzwa2, List list, zzng zzng2, zzbz zzbz2) {
        this(zzwa2, list, zzng2);
    }

    private static void zzd(zzwa zzwa2) throws GeneralSecurityException {
        if (zzwa2 == null || zzwa2.zza() <= 0) {
            throw new GeneralSecurityException("empty keyset");
        }
    }

    public final void zza(zzce zzce2) throws GeneralSecurityException, IOException {
        for (zzwa.zzb zzb2 : this.zza.zze()) {
            if (zzb2.zzb().zzb() != zzvq.zzb.zza && zzb2.zzb().zzb() != zzvq.zzb.zzb && zzb2.zzb().zzb() != zzvq.zzb.zzc) continue;
            throw new GeneralSecurityException(String.format("keyset contains key material of type %s for type url %s", zzb2.zzb().zzb().name(), zzb2.zzb().zzf()));
        }
        zzce2.zza(this.zza);
    }

    public final void zza(zzce zzce2, zzbg zzbg2, byte[] byArray) throws GeneralSecurityException, IOException {
        byte[] byArray2 = byArray;
        zzbg zzbg3 = zzbg2;
        zzwa zzwa2 = this.zza;
        byte[] byArray3 = zzbg3.zzb(zzwa2.zzk(), byArray2);
        zzuo zzuo2 = (zzuo)((zzajy)zzuo.zza().zza(zzaip.zza(byArray3)).zza(zzcs.zza(zzwa2)).zze());
        zzce2.zza(zzuo2);
    }
}

