/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.firebase-auth-api.zzadq;
import com.google.android.gms.internal.firebase-auth-api.zzahu;
import com.google.firebase.auth.internal.zzp;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="VerifyAssertionRequestCreator")
public final class zzahr
extends AbstractSafeParcelable
implements zzadq {
    public static final Parcelable.Creator<zzahr> CREATOR = new zzahu();
    @SafeParcelable.Field(id=2, getter="getRequestUri")
    private String zza;
    @SafeParcelable.Field(id=3, getter="getCurrentIdToken")
    private String zzb;
    @SafeParcelable.Field(id=4, getter="getIdToken")
    private String zzc;
    @SafeParcelable.Field(id=5, getter="getAccessToken")
    private String zzd;
    @SafeParcelable.Field(id=6, getter="getProviderId")
    private String zze;
    @Nullable
    @SafeParcelable.Field(id=7, getter="getEmail")
    private String zzf;
    @SafeParcelable.Field(id=8, getter="getPostBody")
    private String zzg;
    @SafeParcelable.Field(id=9, getter="getOauthTokenSecret")
    private String zzh;
    @SafeParcelable.Field(id=10, getter="getReturnSecureToken")
    private boolean zzi;
    @SafeParcelable.Field(id=11, getter="getAutoCreate")
    private boolean zzj;
    @SafeParcelable.Field(id=12, getter="getAuthCode")
    private String zzk;
    @SafeParcelable.Field(id=13, getter="getSessionId")
    private String zzl;
    @SafeParcelable.Field(id=14, getter="getIdpResponseUrl")
    private String zzm;
    @SafeParcelable.Field(id=15, getter="getTenantId")
    private String zzn;
    @SafeParcelable.Field(id=16, getter="getReturnIdpCredential")
    private boolean zzo;
    @SafeParcelable.Field(id=17, getter="getPendingToken")
    @Nullable
    private String zzp;

    public final zzahr zza(boolean bl) {
        this.zzj = false;
        return this;
    }

    public final zzahr zza(String string) {
        this.zzb = Preconditions.checkNotEmpty((String)string);
        return this;
    }

    public final zzahr zzb(boolean bl) {
        this.zzo = true;
        return this;
    }

    public final zzahr zzc(boolean bl) {
        this.zzi = true;
        return this;
    }

    public final zzahr zzb(@Nullable String string) {
        this.zzn = string;
        return this;
    }

    @Override
    public final String zza() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("autoCreate", this.zzj);
        jSONObject.put("returnSecureToken", this.zzi);
        if (this.zzb != null) {
            jSONObject.put("idToken", (Object)this.zzb);
        }
        if (this.zzg != null) {
            jSONObject.put("postBody", (Object)this.zzg);
        }
        if (this.zzn != null) {
            jSONObject.put("tenantId", (Object)this.zzn);
        }
        if (this.zzp != null) {
            jSONObject.put("pendingToken", (Object)this.zzp);
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzl)) {
            jSONObject.put("sessionId", (Object)this.zzl);
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzm)) {
            jSONObject.put("requestUri", (Object)this.zzm);
        } else if (this.zza != null) {
            jSONObject.put("requestUri", (Object)this.zza);
        }
        jSONObject.put("returnIdpCredential", this.zzo);
        return jSONObject.toString();
    }

    public zzahr() {
        this.zzi = true;
        this.zzj = true;
    }

    public zzahr(zzp zzp2, String string) {
        Preconditions.checkNotNull((Object)zzp2);
        this.zzl = Preconditions.checkNotEmpty((String)zzp2.zzd());
        this.zzm = Preconditions.checkNotEmpty((String)string);
        this.zze = Preconditions.checkNotEmpty((String)zzp2.zzc());
        this.zzi = true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("providerId=").append(this.zze);
        this.zzg = stringBuilder.toString();
    }

    public zzahr(@Nullable String string, @Nullable String string2, String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7, @Nullable String string8, @Nullable String string9) {
        this.zza = "http://localhost";
        this.zzc = string;
        this.zzd = string2;
        this.zzh = string5;
        this.zzk = string6;
        this.zzn = string7;
        this.zzp = string8;
        this.zzi = true;
        if (TextUtils.isEmpty((CharSequence)this.zzc) && TextUtils.isEmpty((CharSequence)this.zzd) && TextUtils.isEmpty((CharSequence)this.zzk)) {
            throw new IllegalArgumentException("idToken, accessToken and authCode cannot all be null");
        }
        this.zze = Preconditions.checkNotEmpty((String)string3);
        this.zzf = null;
        StringBuilder stringBuilder = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)this.zzc)) {
            stringBuilder.append("id_token=").append(this.zzc).append("&");
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzd)) {
            stringBuilder.append("access_token=").append(this.zzd).append("&");
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzf)) {
            stringBuilder.append("identifier=").append(this.zzf).append("&");
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzh)) {
            stringBuilder.append("oauth_token_secret=").append(this.zzh).append("&");
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzk)) {
            stringBuilder.append("code=").append(this.zzk).append("&");
        }
        if (!TextUtils.isEmpty((CharSequence)string9)) {
            stringBuilder.append("nonce=").append(string9).append("&");
        }
        stringBuilder.append("providerId=").append(this.zze);
        this.zzg = stringBuilder.toString();
        this.zzj = true;
    }

    @SafeParcelable.Constructor
    zzahr(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) String string3, @SafeParcelable.Param(id=5) String string4, @SafeParcelable.Param(id=6) String string5, @SafeParcelable.Param(id=7) String string6, @SafeParcelable.Param(id=8) String string7, @SafeParcelable.Param(id=9) String string8, @SafeParcelable.Param(id=10) boolean bl, @SafeParcelable.Param(id=11) boolean bl2, @SafeParcelable.Param(id=12) String string9, @SafeParcelable.Param(id=13) String string10, @SafeParcelable.Param(id=14) String string11, @SafeParcelable.Param(id=15) String string12, @SafeParcelable.Param(id=16) boolean bl3, @SafeParcelable.Param(id=17) String string13) {
        this.zza = string;
        this.zzb = string2;
        this.zzc = string3;
        this.zzd = string4;
        this.zze = string5;
        this.zzf = string6;
        this.zzg = string7;
        this.zzh = string8;
        this.zzi = bl;
        this.zzj = bl2;
        this.zzk = string9;
        this.zzl = string10;
        this.zzm = string11;
        this.zzn = string12;
        this.zzo = bl3;
        this.zzp = string13;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzahr zzahr2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzahr2.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzahr2.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)zzahr2.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)zzahr2.zzd, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)zzahr2.zze, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)zzahr2.zzf, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)zzahr2.zzg, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)9, (String)zzahr2.zzh, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)10, (boolean)zzahr2.zzi);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)11, (boolean)zzahr2.zzj);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)12, (String)zzahr2.zzk, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)13, (String)zzahr2.zzl, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)14, (String)zzahr2.zzm, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)15, (String)zzahr2.zzn, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)16, (boolean)zzahr2.zzo);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)17, (String)zzahr2.zzp, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

