/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase-auth-api.zzadx;
import com.google.android.gms.internal.firebase-auth-api.zzaen;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.appcheck.AppCheckTokenResult;
import com.google.firebase.appcheck.interop.InteropAppCheckTokenProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.heartbeatinfo.HeartBeatController;
import java.net.URLConnection;
import java.util.concurrent.ExecutionException;

public final class zzadu {
    private Context zza;
    private zzaen zzb;
    private String zzc;
    private final FirebaseApp zzd;
    private boolean zze = false;
    private String zzf;

    private static String zza(FirebaseApp firebaseApp) {
        InteropAppCheckTokenProvider interopAppCheckTokenProvider = (InteropAppCheckTokenProvider)FirebaseAuth.getInstance(firebaseApp).zzc().get();
        if (interopAppCheckTokenProvider == null) {
            return null;
        }
        try {
            AppCheckTokenResult appCheckTokenResult = (AppCheckTokenResult)Tasks.await((Task)interopAppCheckTokenProvider.getToken(false));
            if (appCheckTokenResult.getError() != null) {
                String string = String.valueOf(appCheckTokenResult.getError());
                Log.w((String)"LocalRequestInterceptor", (String)("Error getting App Check token; using placeholder token instead. Error: " + string));
            }
            return appCheckTokenResult.getToken();
        }
        catch (InterruptedException | ExecutionException exception) {
            String string = exception.getMessage();
            Log.e((String)"LocalRequestInterceptor", (String)("Unexpected error getting App Check token: " + string));
            return null;
        }
    }

    private static String zzb(FirebaseApp firebaseApp) {
        HeartBeatController heartBeatController = (HeartBeatController)FirebaseAuth.getInstance(firebaseApp).zzd().get();
        if (heartBeatController != null) {
            try {
                return (String)Tasks.await((Task)heartBeatController.getHeartBeatsHeader());
            }
            catch (InterruptedException | ExecutionException exception) {
                String string = exception.getMessage();
                Log.w((String)"LocalRequestInterceptor", (String)("Unable to get heartbeats: " + string));
                return null;
            }
        }
        return null;
    }

    public zzadu(FirebaseApp firebaseApp, String string) {
        this(firebaseApp.getApplicationContext(), firebaseApp, string);
    }

    public zzadu(Context context, FirebaseApp firebaseApp, String string) {
        this.zza = (Context)Preconditions.checkNotNull((Object)context);
        this.zzd = (FirebaseApp)Preconditions.checkNotNull((Object)firebaseApp);
        this.zzc = String.format("Android/%s/%s", "Fallback", string);
    }

    public final void zza(URLConnection uRLConnection) {
        String string;
        if (this.zze) {
            String string2 = this.zzc;
            string = string2 + "/FirebaseUI-Android";
        } else {
            String string3 = this.zzc;
            string = string3 + "/FirebaseCore-Android";
        }
        if (this.zzb == null) {
            this.zzb = new zzaen(this.zza);
        }
        uRLConnection.setRequestProperty("X-Android-Package", this.zzb.zzb());
        uRLConnection.setRequestProperty("X-Android-Cert", this.zzb.zza());
        uRLConnection.setRequestProperty("Accept-Language", zzadx.zza());
        uRLConnection.setRequestProperty("X-Client-Version", string);
        uRLConnection.setRequestProperty("X-Firebase-Locale", this.zzf);
        uRLConnection.setRequestProperty("X-Firebase-GMPID", this.zzd.getOptions().getApplicationId());
        uRLConnection.setRequestProperty("X-Firebase-Client", zzadu.zzb(this.zzd));
        String string4 = zzadu.zza(this.zzd);
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            uRLConnection.setRequestProperty("X-Firebase-AppCheck", string4);
        }
        this.zzf = null;
    }

    public final void zza(String string) {
        this.zze = !TextUtils.isEmpty((CharSequence)string);
    }

    public final void zzb(String string) {
        this.zzf = string;
    }
}

