/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.internal.firebase-auth-api.zzabg;
import com.google.android.gms.internal.firebase-auth-api.zzadi;
import com.google.android.gms.internal.firebase-auth-api.zzadl;
import com.google.android.gms.internal.firebase-auth-api.zzadr;
import com.google.android.gms.internal.firebase-auth-api.zzads;
import com.google.android.gms.internal.firebase-auth-api.zzadu;
import com.google.android.gms.internal.firebase-auth-api.zzagk;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.internal.zzaq;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public final class zzadj
extends AsyncTask<Void, Void, zzadi> {
    private static final Logger zza = new Logger("FirebaseAuth", new String[]{"GetAuthDomainTask"});
    private final String zzb;
    private final String zzc;
    private final WeakReference<zzadl> zzd;
    private final Uri.Builder zze;
    private final String zzf;
    private final FirebaseApp zzg;

    @Nullable
    private final zzadi zza(Void ... voidArray) {
        try {
            URL uRL = new URL(this.zzc);
            zzadl zzadl2 = (zzadl)this.zzd.get();
            HttpURLConnection httpURLConnection = zzadl2.zza(uRL);
            httpURLConnection.addRequestProperty("Content-Type", "application/json; charset=UTF-8");
            httpURLConnection.setConnectTimeout(60000);
            new zzadu(zzadl2.zza(), this.zzg, zzads.zza().zzb()).zza(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                String string = zzadj.zza(httpURLConnection);
                zza.e(String.format("Error getting project config. Failed with %s %s", string, n), new Object[0]);
                return zzadi.zzb(string);
            }
            zzagk zzagk2 = new zzagk();
            zzagk2.zza(new String(zzadj.zza(httpURLConnection.getInputStream(), 128)));
            if (!TextUtils.isEmpty((CharSequence)this.zzf)) {
                if (!zzagk2.zza().contains(this.zzf)) {
                    return zzadi.zzb("UNAUTHORIZED_DOMAIN");
                }
                return zzadi.zza(this.zzf);
            }
            for (String string : zzagk2.zza()) {
                if (!zzadj.zza(string)) continue;
                return zzadi.zza(string);
            }
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            zza.e("IOException occurred: " + string, new Object[0]);
        }
        catch (NullPointerException nullPointerException) {
            String string = nullPointerException.getMessage();
            zza.e("Null pointer encountered: " + string, new Object[0]);
        }
        catch (zzabg zzabg2) {
            String string = zzabg2.getMessage();
            zza.e("ConversionException encountered: " + string, new Object[0]);
        }
        return null;
    }

    @Nullable
    protected final /* synthetic */ Object doInBackground(Object[] objectArray) {
        return this.zza((Void[])objectArray);
    }

    @Nullable
    private static String zza(HttpURLConnection httpURLConnection) throws zzabg {
        try {
            if (httpURLConnection.getResponseCode() >= 400) {
                InputStream inputStream = httpURLConnection.getErrorStream();
                if (inputStream == null) {
                    String string = "Could not retrieve the authDomain for this project but did not receive an error response from the network request. Please try again.";
                    return "WEB_INTERNAL_ERROR:" + string;
                }
                return (String)zzadr.zza(new String(zzadj.zza(inputStream, 128)), String.class);
            }
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException);
            zza.w("Error parsing error message from response body in getErrorMessageFromBody. " + string, new Object[0]);
        }
        return null;
    }

    public zzadj(String string, String string2, Intent intent, FirebaseApp firebaseApp, zzadl zzadl2) {
        this.zzb = Preconditions.checkNotEmpty((String)string);
        this.zzg = (FirebaseApp)Preconditions.checkNotNull((Object)firebaseApp);
        Preconditions.checkNotEmpty((String)string2);
        Preconditions.checkNotNull((Object)intent);
        String string3 = Preconditions.checkNotEmpty((String)intent.getStringExtra("com.google.firebase.auth.KEY_API_KEY"));
        Uri.Builder builder = Uri.parse((String)zzadl2.zza(string3)).buildUpon();
        builder.appendPath("getProjectConfig").appendQueryParameter("key", string3).appendQueryParameter("androidPackageName", string).appendQueryParameter("sha1Cert", (String)Preconditions.checkNotNull((Object)string2));
        this.zzc = builder.build().toString();
        this.zzd = new WeakReference<zzadl>(zzadl2);
        this.zze = zzadl2.zza(intent, string, string2);
        this.zzf = intent.getStringExtra("com.google.firebase.auth.KEY_CUSTOM_AUTH_DOMAIN");
    }

    protected final /* synthetic */ void onCancelled(Object object) {
        zzadi cfr_ignored_0 = (zzadi)object;
        this.zza((zzadi)null);
    }

    protected final /* synthetic */ void onPostExecute(Object object) {
        this.zza((zzadi)object);
    }

    private final void zza(zzadi zzadi2) {
        zzadl zzadl2 = (zzadl)this.zzd.get();
        String string = null;
        String string2 = null;
        if (zzadi2 != null) {
            string = zzadi2.zza();
            string2 = zzadi2.zzb();
        }
        if (zzadl2 == null) {
            zza.e("An error has occurred: the handler reference has returned null.", new Object[0]);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string) && this.zze != null) {
            this.zze.authority(string);
            zzadl2.zza(this.zze.build(), this.zzb, FirebaseAuth.getInstance(this.zzg).zzc());
            return;
        }
        Status status = zzaq.zza(string2);
        zzadl2.zza(this.zzb, status);
    }

    @VisibleForTesting
    private static boolean zza(String string) {
        try {
            String string2 = string;
            String string3 = new URI("https://" + string2).getHost();
            if (string3 != null && (string3.endsWith("firebaseapp.com") || string3.endsWith("web.app"))) {
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            String string4 = uRISyntaxException.getMessage();
            String string5 = string;
            zza.e("Error parsing URL for auth domain check: " + string5 + ". " + string4, new Object[0]);
        }
        return false;
    }

    private static byte[] zza(InputStream inputStream, int n) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int n2;
            byte[] byArray = new byte[128];
            while ((n2 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }
}

