/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.fragment.app.FragmentActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.util.AndroidUtilsLight;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.Hex;
import com.google.android.gms.internal.firebase-auth-api.zzf;
import com.google.android.gms.internal.firebase-auth-api.zzwg;
import com.google.android.gms.internal.firebase-auth-api.zzwi;
import com.google.android.gms.internal.firebase-auth-api.zzwt;
import com.google.android.gms.internal.firebase-auth-api.zzyb;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.internal.zzai;
import com.google.firebase.auth.internal.zzbl;
import com.google.firebase.auth.internal.zzbm;
import com.google.firebase.auth.internal.zzj;
import com.google.firebase.auth.internal.zzk;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ExecutorService;

public class RecaptchaActivity
extends FragmentActivity
implements zzwi {
    private static final String zzb = RecaptchaActivity.class.getSimpleName();
    private static final ExecutorService zzc = com.google.android.gms.internal.firebase-auth-api.zzf.zza().zza(2);
    private static long zzd = 0L;
    private static final zzbm zze = zzbm.zzc();
    private boolean zzf = false;

    protected final void onCreate(@NonNull Bundle bundle) {
        super.onCreate(bundle);
        String string = this.getIntent().getAction();
        if ("com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA".equals(string) || "android.intent.action.VIEW".equals(string)) {
            long l = DefaultClock.getInstance().currentTimeMillis();
            if (l - zzd < 30000L) {
                Log.e((String)zzb, (String)"Could not start operation - already in progress");
                return;
            }
            zzd = l;
            if (bundle != null) {
                this.zzf = bundle.getBoolean("com.google.firebase.auth.internal.KEY_ALREADY_STARTED_RECAPTCHA_FLOW");
                return;
            }
            return;
        }
        Log.e((String)zzb, (String)"Could not do operation - unknown action: ".concat(String.valueOf(string)));
        this.zzg();
    }

    public final void onNewIntent(@NonNull Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void onResume() {
        block11: {
            String string;
            super.onResume();
            if ("android.intent.action.VIEW".equals(this.getIntent().getAction())) {
                Intent intent = this.getIntent();
                if (intent.hasExtra("firebaseError")) {
                    this.zzh(zzbl.zzb(intent.getStringExtra("firebaseError")));
                    return;
                }
                if (intent.hasExtra("link") && intent.hasExtra("eventId")) {
                    void var1_3;
                    String string2 = intent.getStringExtra("link");
                    String string3 = zzj.zzb().zzc(this.getApplicationContext(), this.getPackageName(), intent.getStringExtra("eventId"));
                    if (TextUtils.isEmpty((CharSequence)string3)) {
                        Log.e((String)zzb, (String)"Failed to find registration for this event - failing to prevent session injection.");
                        this.zzh(zzai.zza("Failed to find registration for this reCAPTCHA event"));
                    }
                    if (intent.getBooleanExtra("encryptionEnabled", true)) {
                        String string4 = zzk.zza(this.getApplicationContext(), FirebaseApp.getInstance((String)string3).getPersistenceKey()).zzb(string2);
                    } else {
                        String string5 = string2;
                    }
                    String string6 = Uri.parse((String)var1_3).getQueryParameter("recaptchaToken");
                    zzd = 0L;
                    this.zzf = false;
                    string2 = new Intent();
                    string2.putExtra("com.google.firebase.auth.internal.RECAPTCHA_TOKEN", string6);
                    string2.putExtra("com.google.firebase.auth.internal.OPERATION", "com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA");
                    string2.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
                    if (!LocalBroadcastManager.getInstance((Context)this).sendBroadcast((Intent)string2)) {
                        string2 = this.getApplicationContext().getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0).edit();
                        string2.putString("recaptchaToken", string6);
                        string2.putString("operation", "com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA");
                        string2.putLong("timestamp", DefaultClock.getInstance().currentTimeMillis());
                        string2.commit();
                    } else {
                        zze.zzd((Context)this);
                    }
                    this.finish();
                    return;
                }
                this.zzg();
                return;
            }
            if (this.zzf) {
                this.zzg();
                return;
            }
            Intent intent = this.getIntent();
            String string7 = this.getPackageName();
            try {
                string = Hex.bytesToStringUppercase((byte[])AndroidUtilsLight.getPackageCertificateHashBytes((Context)this, (String)string7)).toLowerCase(Locale.US);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                String string8 = zzb;
                String string9 = ((Object)((Object)nameNotFoundException)).toString();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Could not get package signature: ");
                stringBuilder.append(string7);
                stringBuilder.append(" ");
                stringBuilder.append(string9);
                Log.e((String)string8, (String)stringBuilder.toString());
                this.zze(string7, null);
                break block11;
            }
            String string10 = intent.getStringExtra("com.google.firebase.auth.internal.FIREBASE_APP_NAME");
            string10 = FirebaseApp.getInstance((String)string10);
            zzwg zzwg2 = new zzwg(string7, string, intent, (FirebaseApp)string10, this);
            zzwg2.executeOnExecutor(zzc, new Void[0]);
        }
        this.zzf = true;
    }

    protected final void onSaveInstanceState(@NonNull Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("com.google.firebase.auth.internal.KEY_ALREADY_STARTED_RECAPTCHA_FLOW", this.zzf);
    }

    @Override
    @NonNull
    public final Context zza() {
        return this.getApplicationContext();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public final Uri.Builder zzb(@NonNull Intent object, @NonNull String string, @NonNull String string2) {
        void var3_4;
        void var2_3;
        String string3 = object.getStringExtra("com.google.firebase.auth.KEY_API_KEY");
        String string4 = UUID.randomUUID().toString();
        String string5 = object.getStringExtra("com.google.firebase.auth.internal.CLIENT_VERSION");
        String string6 = object.getStringExtra("com.google.firebase.auth.internal.FIREBASE_APP_NAME");
        FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string6);
        FirebaseAuth firebaseAuth = FirebaseAuth.getInstance(firebaseApp);
        zzj.zzb().zze(string8.getApplicationContext(), (String)var2_3, string4, "com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA", string6);
        String string7 = zzk.zza(string8.getApplicationContext(), firebaseApp.getPersistenceKey()).zzc();
        if (TextUtils.isEmpty((CharSequence)string7)) {
            Log.e((String)zzb, (String)"Could not generate an encryption key for reCAPTCHA - cancelling flow.");
            ((RecaptchaActivity)((Object)string8)).zzh(zzai.zza("Failed to generate/retrieve public encryption key for reCAPTCHA flow."));
            return null;
        }
        String string8 = !TextUtils.isEmpty((CharSequence)firebaseAuth.getLanguageCode()) ? firebaseAuth.getLanguageCode() : zzwt.zza();
        firebaseAuth = new Uri.Builder();
        return firebaseAuth.scheme("https").appendPath("__").appendPath("auth").appendPath("handler").appendQueryParameter("apiKey", string3).appendQueryParameter("authType", "verifyApp").appendQueryParameter("apn", (String)var2_3).appendQueryParameter("hl", string8).appendQueryParameter("eventId", string4).appendQueryParameter("v", "X".concat(String.valueOf(string5))).appendQueryParameter("eid", "p").appendQueryParameter("appName", string6).appendQueryParameter("sha1Cert", (String)var3_4).appendQueryParameter("publicKey", string7);
    }

    @Override
    @NonNull
    public final String zzc(@NonNull String string) {
        return zzyb.zzb(string);
    }

    @Override
    @Nullable
    public final HttpURLConnection zzd(@NonNull URL uRL) {
        try {
            Object object = uRL.openConnection();
            object = (HttpURLConnection)object;
            return object;
        }
        catch (IOException iOException) {
            zza.e("Error generating connection", new Object[0]);
            return null;
        }
    }

    private final void zzg() {
        zzd = 0L;
        this.zzf = false;
        Intent intent = new Intent();
        intent.putExtra("com.google.firebase.auth.internal.EXTRA_CANCELED", true);
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
        zze.zzd((Context)this);
        this.finish();
    }

    private final void zzh(Status status) {
        zzd = 0L;
        this.zzf = false;
        Intent intent = new Intent();
        zzbl.zzc(intent, status);
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
        zze.zzd((Context)this);
        this.finish();
    }

    @Override
    public final void zze(@NonNull String string, @Nullable Status status) {
        if (status == null) {
            this.zzg();
            return;
        }
        this.zzh(status);
    }

    @Override
    public final void zzf(@NonNull Uri uri, @NonNull String string) {
        Object object = new Intent("android.intent.action.VIEW");
        if (this.getPackageManager().resolveActivity((Intent)object, 0) != null) {
            object = this.getPackageManager();
            Intent intent = new Intent("android.support.customtabs.action.CustomTabsService");
            if ((object = object.queryIntentServices(intent, 0)) != null && !object.isEmpty()) {
                string = new CustomTabsIntent.Builder();
                string = string.build();
                ((CustomTabsIntent)string).intent.addFlags(0x40000000);
                ((CustomTabsIntent)string).intent.addFlags(0x10000000);
                string.launchUrl((Context)this, uri);
                return;
            }
            object = new Intent("android.intent.action.VIEW", uri);
            object.putExtra("com.android.browser.application_id", string);
            object.addFlags(0x40000000);
            object.addFlags(0x10000000);
            this.startActivity((Intent)object);
            return;
        }
        Log.e((String)zzb, (String)"Device cannot resolve intent for: android.intent.action.VIEW");
        this.zze(string, null);
    }
}

