/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase-auth-api.zzlq;
import com.google.android.gms.internal.firebase-auth-api.zzwo;
import com.google.android.gms.internal.firebase-auth-api.zzxb;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.internal.zzu;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="DefaultAuthUserInfoCreator")
public final class zzt
extends AbstractSafeParcelable
implements UserInfo {
    public static final Parcelable.Creator<zzt> CREATOR;
    @SafeParcelable.Field(id=1, getter="getUid")
    @NonNull
    private final String zza;
    @SafeParcelable.Field(id=2, getter="getProviderId")
    @NonNull
    private final String zzb;
    @SafeParcelable.Field(id=3, getter="getDisplayName")
    @Nullable
    private final String zzc;
    @SafeParcelable.Field(id=4, getter="getPhotoUrlString")
    @Nullable
    private String zzd;
    @Nullable
    private Uri zze;
    @SafeParcelable.Field(id=5, getter="getEmail")
    @Nullable
    private final String zzf;
    @SafeParcelable.Field(id=6, getter="getPhoneNumber")
    @Nullable
    private final String zzg;
    @SafeParcelable.Field(id=7, getter="isEmailVerified")
    private final boolean zzh;
    @SafeParcelable.Field(id=8, getter="getRawUserInfo")
    @Nullable
    private final String zzi;

    @VisibleForTesting
    @SafeParcelable.Constructor
    public zzt(@SafeParcelable.Param(id=1) @NonNull String string, @SafeParcelable.Param(id=2) @NonNull String string2, @SafeParcelable.Param(id=5) @Nullable String string3, @SafeParcelable.Param(id=4) @Nullable String string4, @SafeParcelable.Param(id=3) @Nullable String string5, @SafeParcelable.Param(id=6) @Nullable String string6, @SafeParcelable.Param(id=7) boolean bl, @SafeParcelable.Param(id=8) @Nullable String string7) {
        this.zza = string;
        this.zzb = string2;
        this.zzf = string3;
        this.zzg = string4;
        this.zzc = string5;
        this.zzd = string6;
        if (!TextUtils.isEmpty((CharSequence)this.zzd)) {
            this.zze = Uri.parse((String)this.zzd);
        }
        this.zzh = bl;
        this.zzi = string7;
    }

    public zzt(zzwo zzwo2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzwo2));
        string = "firebase";
        Preconditions.checkNotEmpty((String)string);
        this.zza = Preconditions.checkNotEmpty((String)zzwo2.zzc());
        this.zzb = string;
        this.zzf = zzwo2.zza();
        this.zzc = zzwo2.zzd();
        string = zzwo2.zze();
        if (string != null) {
            this.zzd = string.toString();
            this.zze = string;
        }
        this.zzh = zzwo2.zzb();
        this.zzi = null;
        this.zzg = zzwo2.zzf();
    }

    public zzt(zzxb zzxb2) {
        Preconditions.checkNotNull((Object)((Object)zzxb2));
        this.zza = zzxb2.zza();
        this.zzb = Preconditions.checkNotEmpty((String)zzxb2.zzd());
        this.zzc = zzxb2.zzb();
        Uri uri = zzxb2.zzc();
        if (uri != null) {
            this.zzd = uri.toString();
            this.zze = uri;
        }
        this.zzf = zzxb2.zzh();
        this.zzg = zzxb2.zze();
        this.zzh = false;
        this.zzi = zzxb2.zzg();
    }

    @Override
    @NonNull
    public final String getUid() {
        return this.zza;
    }

    @Override
    @NonNull
    public final String getProviderId() {
        return this.zzb;
    }

    @Override
    @Nullable
    public final String getDisplayName() {
        return this.zzc;
    }

    @Override
    @Nullable
    public final Uri getPhotoUrl() {
        if (!TextUtils.isEmpty((CharSequence)this.zzd) && this.zze == null) {
            this.zze = Uri.parse((String)this.zzd);
        }
        return this.zze;
    }

    @Override
    @Nullable
    public final String getEmail() {
        return this.zzf;
    }

    @Override
    @Nullable
    public final String getPhoneNumber() {
        return this.zzg;
    }

    @Override
    public final boolean isEmailVerified() {
        return this.zzh;
    }

    @Nullable
    public final String zza() {
        return this.zzi;
    }

    @Nullable
    public final String zzb() {
        Object object = new JSONObject();
        try {
            object.putOpt("userId", (Object)((zzt)((Object)string)).zza);
            object.putOpt("providerId", (Object)((zzt)((Object)string)).zzb);
            object.putOpt("displayName", (Object)((zzt)((Object)string)).zzc);
            object.putOpt("photoUrl", (Object)((zzt)((Object)string)).zzd);
            object.putOpt("email", (Object)((zzt)((Object)string)).zzf);
            object.putOpt("phoneNumber", (Object)((zzt)((Object)string)).zzg);
            object.putOpt("isEmailVerified", (Object)((zzt)((Object)string)).zzh);
            object.putOpt("rawUserInfo", (Object)((zzt)((Object)string)).zzi);
            String string = object.toString();
        }
        catch (JSONException jSONException) {
            Log.d((String)"DefaultAuthUserInfo", (String)"Failed to jsonify this object");
            object = new zzlq(jSONException);
            throw object;
        }
        return string;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)1, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)4, (String)this.zzd, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)5, (String)this.zzf, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)6, (String)this.zzg, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)7, (boolean)this.zzh);
        SafeParcelWriter.writeString((Parcel)parcel, (int)8, (String)this.zzi, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    static {
        zzu zzu2;
        CREATOR = zzu2 = new zzu();
    }
}

