/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.fragment.app.FragmentActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.util.AndroidUtilsLight;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.Hex;
import com.google.android.gms.internal.firebase-auth-api.zzh;
import com.google.android.gms.internal.firebase-auth-api.zztw;
import com.google.android.gms.internal.firebase-auth-api.zzty;
import com.google.android.gms.internal.firebase-auth-api.zzus;
import com.google.android.gms.internal.firebase-auth-api.zzvw;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.internal.zzai;
import com.google.firebase.auth.internal.zzbl;
import com.google.firebase.auth.internal.zzbm;
import com.google.firebase.auth.internal.zzj;
import com.google.firebase.auth.internal.zzk;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ExecutorService;

public class RecaptchaActivity
extends FragmentActivity
implements zzty {
    private static final String zzb = RecaptchaActivity.class.getSimpleName();
    private static final ExecutorService zzc = zzh.zza().zza(2);
    private static long zzd = 0L;
    private boolean zze = false;
    private static final zzbm zzf = zzbm.zza();

    /*
     * Enabled aggressive block sorting
     */
    protected final void onCreate(Bundle object) {
        super.onCreate((Bundle)object);
        String string = this.getIntent().getAction();
        if (!"com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA".equals(string) && !"android.intent.action.VIEW".equals(string)) {
            String string2 = zzb;
            object = String.valueOf(string);
            string = "Could not do operation - unknown action: ";
            object = ((String)object).length() != 0 ? string.concat((String)object) : new String(string);
            Log.e((String)string2, (String)object);
            this.zzg();
            return;
        }
        long l = DefaultClock.getInstance().currentTimeMillis();
        if (l - zzd < 30000L) {
            Log.e((String)zzb, (String)"Could not start operation - already in progress");
            return;
        }
        zzd = l;
        if (object != null) {
            this.zze = object.getBoolean("com.google.firebase.auth.internal.KEY_ALREADY_STARTED_RECAPTCHA_FLOW");
            return;
        }
    }

    protected final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("com.google.firebase.auth.internal.KEY_ALREADY_STARTED_RECAPTCHA_FLOW", this.zze);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void onResume() {
        block11: {
            zztw zztw2;
            super.onResume();
            if ("android.intent.action.VIEW".equals(this.getIntent().getAction())) {
                Intent intent = this.getIntent();
                if (intent.hasExtra("firebaseError")) {
                    this.zzh(zzbl.zzd(intent.getStringExtra("firebaseError")));
                    return;
                }
                if (intent.hasExtra("link") && intent.hasExtra("eventId")) {
                    void var1_3;
                    String string = intent.getStringExtra("link");
                    String string2 = zzj.zza().zze(this.getApplicationContext(), this.getPackageName(), intent.getStringExtra("eventId"));
                    if (TextUtils.isEmpty((CharSequence)string2)) {
                        Log.e((String)zzb, (String)"Failed to find registration for this event - failing to prevent session injection.");
                        this.zzh(zzai.zza("Failed to find registration for this reCAPTCHA event"));
                    }
                    if (intent.getBooleanExtra("encryptionEnabled", true)) {
                        String string3 = zzk.zza(this.getApplicationContext(), FirebaseApp.getInstance((String)string2).getPersistenceKey()).zzc(string);
                    } else {
                        String string4 = string;
                    }
                    String string5 = Uri.parse((String)var1_3).getQueryParameter("recaptchaToken");
                    zzd = 0L;
                    this.zze = false;
                    Intent intent2 = new Intent();
                    intent2.putExtra("com.google.firebase.auth.internal.RECAPTCHA_TOKEN", string5);
                    intent2.putExtra("com.google.firebase.auth.internal.OPERATION", "com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA");
                    intent2.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
                    if (!LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent2)) {
                        SharedPreferences.Editor editor = this.getApplicationContext().getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0).edit();
                        editor.putString("recaptchaToken", string5);
                        editor.putString("operation", "com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA");
                        editor.putLong("timestamp", DefaultClock.getInstance().currentTimeMillis());
                        editor.commit();
                    } else {
                        zzf.zzh((Context)this);
                    }
                    this.finish();
                    return;
                }
                this.zzg();
                return;
            }
            if (this.zze) {
                this.zzg();
                return;
            }
            String string = this.getPackageName();
            try {
                byte[] byArray = AndroidUtilsLight.getPackageCertificateHashBytes((Context)this, (String)string);
                String string6 = Hex.bytesToStringUppercase((byte[])byArray).toLowerCase(Locale.US);
                zztw2 = new zztw(string, string6, this.getIntent(), this);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                String string7 = zzb;
                String string8 = String.valueOf((Object)nameNotFoundException);
                String string9 = String.valueOf(string);
                int n = string9.length();
                String string10 = String.valueOf(string8);
                int n2 = string10.length();
                StringBuilder stringBuilder = new StringBuilder(n + 34 + n2);
                stringBuilder.append("Could not get package signature: ");
                stringBuilder.append(string);
                stringBuilder.append(" ");
                stringBuilder.append(string8);
                Log.e((String)string7, (String)stringBuilder.toString());
                this.zze(string, null);
                break block11;
            }
            zztw2.executeOnExecutor(zzc, new Void[0]);
        }
        this.zze = true;
    }

    public final void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    @Override
    public final void zza(Uri uri, String string) {
        Object object = new Intent("android.intent.action.VIEW");
        if (this.getPackageManager().resolveActivity((Intent)object, 0) != null) {
            object = this.getPackageManager();
            Intent intent = new Intent("android.support.customtabs.action.CustomTabsService");
            if ((object = object.queryIntentServices(intent, 0)) != null && !object.isEmpty()) {
                string = new CustomTabsIntent.Builder();
                string = string.build();
                ((CustomTabsIntent)string).intent.addFlags(0x40000000);
                ((CustomTabsIntent)string).intent.addFlags(0x10000000);
                string.launchUrl((Context)this, uri);
                return;
            }
            object = new Intent("android.intent.action.VIEW", uri);
            object.putExtra("com.android.browser.application_id", string);
            object.addFlags(0x40000000);
            object.addFlags(0x10000000);
            this.startActivity((Intent)object);
            return;
        }
        Log.e((String)zzb, (String)"Device cannot resolve intent for: android.intent.action.VIEW");
        this.zze(string, null);
    }

    @Override
    @Nullable
    public final HttpURLConnection zzb(URL uRL) {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            return httpURLConnection;
        }
        catch (IOException iOException) {
            zza.e("Error generating connection", new Object[0]);
            return null;
        }
    }

    @Override
    public final String zzc(String string) {
        return zzvw.zze(string);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public final Uri.Builder zzd(Intent object, String string, String string2) {
        void var3_4;
        Uri.Builder builder;
        String string3 = object.getStringExtra("com.google.firebase.auth.KEY_API_KEY");
        String string4 = UUID.randomUUID().toString();
        String string5 = object.getStringExtra("com.google.firebase.auth.internal.CLIENT_VERSION");
        String string6 = object.getStringExtra("com.google.firebase.auth.internal.FIREBASE_APP_NAME");
        FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string6);
        FirebaseAuth firebaseAuth = FirebaseAuth.getInstance(firebaseApp);
        zzj.zza().zzc(object2.getApplicationContext(), (String)builder, string4, "com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA", string6);
        String string7 = zzk.zza(object2.getApplicationContext(), firebaseApp.getPersistenceKey()).zzb();
        if (TextUtils.isEmpty((CharSequence)string7)) {
            Log.e((String)zzb, (String)"Could not generate an encryption key for reCAPTCHA - cancelling flow.");
            ((RecaptchaActivity)object2).zzh(zzai.zza("Failed to generate/retrieve public encryption key for reCAPTCHA flow."));
            return null;
        }
        Object object2 = !TextUtils.isEmpty((CharSequence)firebaseAuth.getLanguageCode()) ? firebaseAuth.getLanguageCode() : zzus.zza();
        firebaseAuth = new Uri.Builder();
        builder = firebaseAuth.scheme("https").appendPath("__").appendPath("auth").appendPath("handler").appendQueryParameter("apiKey", string3).appendQueryParameter("authType", "verifyApp").appendQueryParameter("apn", (String)builder).appendQueryParameter("hl", (String)object2).appendQueryParameter("eventId", string4);
        object2 = String.valueOf(string5);
        string3 = "X";
        if (((String)object2).length() != 0) {
            object2 = string3.concat((String)object2);
            return builder.appendQueryParameter("v", (String)object2).appendQueryParameter("eid", "p").appendQueryParameter("appName", string6).appendQueryParameter("sha1Cert", (String)var3_4).appendQueryParameter("publicKey", string7);
        }
        object2 = new String(string3);
        return builder.appendQueryParameter("v", (String)object2).appendQueryParameter("eid", "p").appendQueryParameter("appName", string6).appendQueryParameter("sha1Cert", (String)var3_4).appendQueryParameter("publicKey", string7);
    }

    @Override
    public final void zze(String string, @Nullable Status status) {
        if (status == null) {
            this.zzg();
            return;
        }
        this.zzh(status);
    }

    @Override
    public final Context zzf() {
        return this.getApplicationContext();
    }

    private final void zzg() {
        zzd = 0L;
        this.zze = false;
        Intent intent = new Intent();
        intent.putExtra("com.google.firebase.auth.internal.EXTRA_CANCELED", true);
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
        zzf.zzh((Context)this);
        this.finish();
    }

    private final void zzh(Status status) {
        zzd = 0L;
        this.zze = false;
        Intent intent = new Intent();
        zzbl.zza(intent, status);
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
        zzf.zzh((Context)this);
        this.finish();
    }
}

