/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase-auth-api.zztn;
import com.google.android.gms.internal.firebase-auth-api.zztp;
import com.google.android.gms.internal.firebase-auth-api.zztt;
import com.google.android.gms.internal.firebase-auth-api.zzuj;
import com.google.android.gms.internal.firebase-auth-api.zzuk;
import com.google.android.gms.internal.firebase-auth-api.zzul;
import com.google.android.gms.internal.firebase-auth-api.zzus;
import com.google.android.gms.internal.firebase-auth-api.zzvm;
import com.google.android.gms.internal.firebase-auth-api.zzvw;
import com.google.android.gms.internal.firebase-auth-api.zzwv;
import com.google.android.gms.internal.firebase-auth-api.zzxi;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.ActionCodeUrl;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuthSettings;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.MultiFactor;
import com.google.firebase.auth.MultiFactorAssertion;
import com.google.firebase.auth.MultiFactorInfo;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthOptions;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.PhoneMultiFactorAssertion;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.auth.internal.zzag;
import com.google.firebase.auth.internal.zzay;
import com.google.firebase.auth.internal.zzbg;
import com.google.firebase.auth.internal.zzbi;
import com.google.firebase.auth.internal.zzbj;
import com.google.firebase.auth.internal.zzbk;
import com.google.firebase.auth.internal.zzbm;
import com.google.firebase.auth.internal.zzf;
import com.google.firebase.auth.internal.zzr;
import com.google.firebase.auth.internal.zzw;
import com.google.firebase.auth.internal.zzx;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzk;
import com.google.firebase.auth.zzl;
import com.google.firebase.auth.zzm;
import com.google.firebase.auth.zzn;
import com.google.firebase.auth.zzo;
import com.google.firebase.auth.zzp;
import com.google.firebase.auth.zzq;
import com.google.firebase.auth.zzs;
import com.google.firebase.auth.zzt;
import com.google.firebase.auth.zzu;
import com.google.firebase.internal.InternalTokenResult;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public abstract class FirebaseAuth
implements InternalAuthProvider {
    private FirebaseApp zza;
    private final List<IdTokenListener> zzb;
    private final List<com.google.firebase.auth.internal.IdTokenListener> zzc;
    private List<AuthStateListener> zzd;
    private zztn zze;
    private FirebaseUser zzf;
    private zzw zzg;
    private final Object zzh;
    private String zzi;
    private final Object zzj;
    private String zzk;
    private final zzbg zzl;
    private final zzbm zzm;
    private final zzf zzn;
    private zzbi zzo;
    private zzbj zzp;

    @NonNull
    @Keep
    public static FirebaseAuth getInstance() {
        return (FirebaseAuth)FirebaseApp.getInstance().get(FirebaseAuth.class);
    }

    @NonNull
    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseAuth)firebaseApp.get(FirebaseAuth.class);
    }

    public FirebaseAuth(FirebaseApp object) {
        Object object2;
        Object object3 = object.getOptions();
        object3 = object3.getApiKey();
        object3 = Preconditions.checkNotEmpty((String)object3);
        object3 = zzuj.zza((String)object3);
        Object object4 = object.getApplicationContext();
        object3 = zzul.zza(object4, (zzuk)object3);
        super(object.getApplicationContext(), object.getPersistenceKey());
        zzbm zzbm2 = zzbm.zza();
        zzf zzf2 = com.google.firebase.auth.internal.zzf.zza();
        super();
        this.zzh = object2 = new Object();
        this.zzj = object2 = new Object();
        this.zza = (FirebaseApp)Preconditions.checkNotNull((Object)object);
        this.zze = (zztn)Preconditions.checkNotNull((Object)object3);
        this.zzl = (zzbg)Preconditions.checkNotNull((Object)object4);
        super();
        this.zzg = object;
        this.zzm = (zzbm)Preconditions.checkNotNull((Object)zzbm2);
        this.zzn = (zzf)Preconditions.checkNotNull((Object)zzf2);
        super();
        this.zzb = object;
        super();
        this.zzc = object;
        super();
        this.zzd = object;
        this.zzp = zzbj.zza();
        this.zzf = this.zzl.zzb();
        object = this.zzf;
        if (object != null && (object = this.zzl.zzd((FirebaseUser)object)) != null) {
            this.zza(this.zzf, (zzwv)object, false, false);
        }
        this.zzm.zzf(this);
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzf;
    }

    @Nullable
    public final String getUid() {
        FirebaseUser firebaseUser = ((FirebaseAuth)((Object)firebaseUser)).zzf;
        if (firebaseUser == null) {
            return null;
        }
        return firebaseUser.getUid();
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.zza;
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzb.add(idTokenListener);
        zzbj zzbj2 = this.zzp;
        zzj zzj2 = new zzj(this, idTokenListener);
        zzbj2.execute(zzj2);
    }

    @KeepForSdk
    public void addIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener idTokenListener) {
        Preconditions.checkNotNull((Object)idTokenListener);
        this.zzc.add(idTokenListener);
        this.zzd().zza(this.zzc.size());
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzb.remove(idTokenListener);
    }

    @KeepForSdk
    public void removeIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener idTokenListener) {
        Preconditions.checkNotNull((Object)idTokenListener);
        this.zzc.remove(idTokenListener);
        this.zzd().zza(this.zzc.size());
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzd.add(authStateListener);
        zzbj zzbj2 = this.zzp;
        zzk zzk2 = new zzk(this, authStateListener);
        zzbj2.execute(zzk2);
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzd.remove(authStateListener);
    }

    @NonNull
    public final Task<GetTokenResult> getAccessToken(boolean bl) {
        return this.zzg(this.zzf, bl);
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential object) {
        Preconditions.checkNotNull((Object)object);
        object = object.zza();
        if (object instanceof EmailAuthCredential) {
            if (!((EmailAuthCredential)((Object)(object = (EmailAuthCredential)((Object)object)))).zzh()) {
                zztn zztn2 = firebaseAuth.zze;
                FirebaseApp firebaseApp = firebaseAuth.zza;
                String string = ((EmailAuthCredential)((Object)object)).zzb();
                object = ((EmailAuthCredential)((Object)object)).zzc();
                String string2 = firebaseAuth.zzk;
                zzs zzs2 = new zzs(firebaseAuth);
                return zztn2.zzq(firebaseApp, string, (String)object, string2, zzs2);
            }
            if (firebaseAuth.zzJ(((EmailAuthCredential)((Object)object)).zzd())) {
                FirebaseAuth firebaseAuth = new Status(17072);
                return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
            }
            zztn zztn3 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            zzs zzs3 = new zzs(firebaseAuth);
            return zztn3.zzr(firebaseApp, (EmailAuthCredential)((Object)object), zzs3);
        }
        if (object instanceof PhoneAuthCredential) {
            object = (PhoneAuthCredential)object;
            zztn zztn4 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            String string = firebaseAuth.zzk;
            zzs zzs4 = new zzs(firebaseAuth);
            return zztn4.zzw(firebaseApp, (PhoneAuthCredential)object, string, zzs4);
        }
        zztn zztn5 = firebaseAuth.zze;
        FirebaseApp firebaseApp = firebaseAuth.zza;
        String string = firebaseAuth.zzk;
        zzs zzs5 = new zzs(firebaseAuth);
        return zztn5.zzg(firebaseApp, (AuthCredential)((Object)object), string, zzs5);
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        String string2 = this.zzk;
        zzs zzs2 = new zzs(this);
        return zztn2.zzf(firebaseApp, string, string2, zzs2);
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        String string3 = this.zzk;
        zzs zzs2 = new zzs(this);
        return zztn2.zzq(firebaseApp, string, string2, string3, zzs2);
    }

    @NonNull
    public Task<AuthResult> signInWithEmailLink(@NonNull String string, @NonNull String string2) {
        return this.signInWithCredential(EmailAuthProvider.getCredentialWithLink(string, string2));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        Object object = ((FirebaseAuth)((Object)zzx2)).zzf;
        if (object != null && ((FirebaseUser)object).isAnonymous()) {
            zzx zzx2 = (zzx)((FirebaseAuth)((Object)zzx2)).zzf;
            zzx2.zzn(false);
            object = new zzr(zzx2);
            return Tasks.forResult((Object)object);
        }
        object = ((FirebaseAuth)((Object)zzx2)).zze;
        FirebaseApp firebaseApp = ((FirebaseAuth)((Object)zzx2)).zza;
        zzs zzs2 = new zzs((FirebaseAuth)((Object)zzx2));
        return ((zztn)object).zzj(firebaseApp, zzs2, ((FirebaseAuth)((Object)zzx2)).zzk);
    }

    @NonNull
    public Task<Void> updateCurrentUser(@NonNull FirebaseUser firebaseUser) {
        Object object;
        Object object2;
        if (firebaseUser == null) {
            object2 = new IllegalArgumentException("Cannot update current user with null user!");
            throw object2;
        }
        if ((firebaseUser.getTenantId() == null || firebaseUser.getTenantId().equals(((FirebaseAuth)object2).zzk)) && ((object = ((FirebaseAuth)object2).zzk) == null || ((String)object).equals(firebaseUser.getTenantId()))) {
            object = firebaseUser.zzd().getOptions().getApiKey();
            String string = ((FirebaseAuth)object2).zza.getOptions().getApiKey();
            if (firebaseUser.zze().zzb() && string.equals(object)) {
                ((FirebaseAuth)object2).zza(zzx.zzs(((FirebaseAuth)object2).zza, firebaseUser), firebaseUser.zze(), true, false);
                return Tasks.forResult(null);
            }
            object = new zzu((FirebaseAuth)object2);
            return ((FirebaseAuth)object2).zzl(firebaseUser, (zzbk)object);
        }
        object2 = new Status(17072);
        return Tasks.forException((Exception)zztt.zza((Status)object2));
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        String string3 = this.zzk;
        zzs zzs2 = new zzs(this);
        return zztn2.zzp(firebaseApp, string, string2, string3, zzs2);
    }

    @NonNull
    public Task<SignInMethodQueryResult> fetchSignInMethodsForEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzz(this.zza, string, this.zzk);
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.sendPasswordResetEmail(string, null);
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string, @Nullable ActionCodeSettings actionCodeSettings) {
        String string2;
        Preconditions.checkNotEmpty((String)string);
        if (actionCodeSettings == null) {
            actionCodeSettings = ActionCodeSettings.zza();
        }
        if ((string2 = this.zzi) != null) {
            actionCodeSettings.zzc(string2);
        }
        actionCodeSettings.zze(1);
        return this.zze.zzA(this.zza, string, actionCodeSettings, this.zzk);
    }

    @NonNull
    public Task<Void> sendSignInLinkToEmail(@NonNull String string, @NonNull ActionCodeSettings actionCodeSettings) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)actionCodeSettings));
        if (!actionCodeSettings.canHandleCodeInApp()) {
            Object object = new IllegalArgumentException("You must set canHandleCodeInApp in your ActionCodeSettings to true for Email-Link Sign-in.");
            throw object;
        }
        String string2 = ((FirebaseAuth)object).zzi;
        if (string2 != null) {
            actionCodeSettings.zzc(string2);
        }
        return ((FirebaseAuth)object).zze.zzB(((FirebaseAuth)object).zza, string, actionCodeSettings, ((FirebaseAuth)object).zzk);
    }

    public boolean isSignInWithEmailLink(@NonNull String string) {
        return EmailAuthCredential.zzi(string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzD(this.zza, string, this.zzk);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzE(this.zza, string, this.zzk);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzF(this.zza, string, this.zzk);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zze.zzG(this.zza, string, string2, this.zzk);
    }

    @NonNull
    public Task<AuthResult> startActivityForSignInWithProvider(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider) {
        FirebaseAuth firebaseAuth;
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)activity);
        if (!zztp.zza()) {
            firebaseAuth = new Status(17063);
            return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!firebaseAuth.zzm.zzi(activity, (TaskCompletionSource<AuthResult>)taskCompletionSource, firebaseAuth)) {
            firebaseAuth = new Status(17057);
            return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
        }
        firebaseAuth.zzm.zzb(activity.getApplicationContext(), firebaseAuth);
        federatedAuthProvider.zza(activity);
        return taskCompletionSource.getTask();
    }

    @Nullable
    public Task<AuthResult> getPendingAuthResult() {
        return this.zzm.zzd();
    }

    public void signOut() {
        ((FirebaseAuth)((Object)zzbi2)).zzb();
        zzbi zzbi2 = ((FirebaseAuth)((Object)zzbi2)).zzo;
        if (zzbi2 != null) {
            zzbi2.zzc();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLanguageCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Object object = this.zzh;
        synchronized (object) {
            this.zzi = string;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String getLanguageCode() {
        Object object = ((FirebaseAuth)string).zzh;
        synchronized (object) {
            return ((FirebaseAuth)string).zzi;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTenantId(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Object object = this.zzj;
        synchronized (object) {
            this.zzk = string;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String getTenantId() {
        Object object = ((FirebaseAuth)string).zzj;
        synchronized (object) {
            return ((FirebaseAuth)string).zzk;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void useAppLanguage() {
        Object object = this.zzh;
        synchronized (object) {
            this.zzi = zzus.zza();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @NonNull
    public FirebaseAuthSettings getFirebaseAuthSettings() {
        return this.zzg;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void useEmulator(@NonNull String string, int n) {
        Preconditions.checkNotEmpty((String)string);
        boolean bl = n >= 0 ? n <= 65535 : false;
        Preconditions.checkArgument((boolean)bl, (Object)"Port number must be in the range 0-65535");
        zzvw.zza(this.zza, string, n);
    }

    @NonNull
    public Task<Void> setFirebaseUIVersion(@Nullable String string) {
        return this.zze.zzL(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final void zza(FirebaseUser firebaseUser, zzwv zzwv2, boolean bl, boolean bl2) {
        boolean bl3;
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzwv2);
        boolean bl4 = this.zzf != null ? firebaseUser.getUid().equals(this.zzf.getUid()) : false;
        if (!bl4 && bl2) {
            return;
        }
        FirebaseUser firebaseUser2 = this.zzf;
        if (firebaseUser2 == null) {
            bl3 = true;
            bl4 = true;
        } else {
            bl3 = firebaseUser2.zze().zze().equals(zzwv2.zze()) ^ true;
            bl3 = bl4 ? bl3 : true;
            bl4 ^= true;
        }
        Preconditions.checkNotNull((Object)firebaseUser);
        List<MultiFactorInfo> list = this.zzf;
        if (list == null) {
            this.zzf = firebaseUser;
        } else {
            ((FirebaseUser)((Object)list)).zzb(firebaseUser.getProviderData());
            if (!firebaseUser.isAnonymous()) {
                this.zzf.zzc();
            }
            list = firebaseUser.getMultiFactor();
            list = ((MultiFactor)((Object)list)).getEnrolledFactors();
            this.zzf.zzi(list);
        }
        if (bl) {
            this.zzl.zza(this.zzf);
        }
        if (bl3) {
            FirebaseUser firebaseUser3 = this.zzf;
            if (firebaseUser3 != null) {
                firebaseUser3.zzf(zzwv2);
            }
            this.zze(this.zzf);
        }
        if (bl4) {
            this.zzf(this.zzf);
        }
        if (bl) {
            this.zzl.zzc(firebaseUser, zzwv2);
        }
        this.zzd().zzb(this.zzf.zze());
    }

    public final void zzb() {
        FirebaseUser firebaseUser = this.zzf;
        if (firebaseUser != null) {
            zzbg zzbg2 = this.zzl;
            Preconditions.checkNotNull((Object)firebaseUser);
            Object[] objectArray = new Object[]{firebaseUser.getUid()};
            zzbg2.zze(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", objectArray));
            this.zzf = null;
        }
        this.zzl.zze("com.google.firebase.auth.FIREBASE_USER");
        this.zze(null);
        this.zzf(null);
    }

    @VisibleForTesting
    public final synchronized void zzc(zzbi zzbi2) {
        this.zzo = zzbi2;
    }

    @VisibleForTesting
    public final synchronized zzbi zzd() {
        if (this.zzo == null) {
            zzbi zzbi2 = new zzbi(this.getApp());
            this.zzc(zzbi2);
        }
        return this.zzo;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zze(@Nullable FirebaseUser object) {
        String string;
        if (object != null) {
            string = ((FirebaseUser)object).getUid();
            String string2 = String.valueOf(string);
            int n = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n + 45);
            stringBuilder.append("Notifying id token listeners about user ( ");
            stringBuilder.append(string);
            stringBuilder.append(" ).");
            Log.d((String)"FirebaseAuth", (String)stringBuilder.toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        object = object != null ? ((FirebaseUser)object).zzh() : null;
        string = new InternalTokenResult((String)object);
        object = this.zzp;
        zzl zzl2 = new zzl(this, (InternalTokenResult)string);
        ((zzbj)object).execute(zzl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzf(@Nullable FirebaseUser object) {
        if (object != null) {
            object = ((FirebaseUser)object).getUid();
            String string = String.valueOf(object);
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n + 47);
            stringBuilder.append("Notifying auth state listeners about user ( ");
            stringBuilder.append((String)object);
            stringBuilder.append(" ).");
            Log.d((String)"FirebaseAuth", (String)stringBuilder.toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        object = this.zzp;
        zzm zzm2 = new zzm(this);
        ((zzbj)object).execute(zzm2);
    }

    @NonNull
    public final Task<GetTokenResult> zzg(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            FirebaseAuth firebaseAuth = new Status(17495);
            return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
        }
        Object object = firebaseUser.zze();
        if (((zzwv)object).zzb() && !bl) {
            return Tasks.forResult((Object)zzay.zza(((zzwv)object).zze()));
        }
        zztn zztn2 = firebaseAuth.zze;
        FirebaseApp firebaseApp = firebaseAuth.zza;
        object = ((zzwv)object).zzd();
        zzn zzn2 = new zzn(firebaseAuth);
        return zztn2.zze(firebaseApp, firebaseUser, (String)object, zzn2);
    }

    @NonNull
    public final Task<Void> zzh(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential object) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)object);
        object = object.zza();
        if (object instanceof EmailAuthCredential) {
            if ("password".equals(((EmailAuthCredential)((Object)(object = (EmailAuthCredential)((Object)object)))).getSignInMethod())) {
                zztn zztn2 = firebaseAuth.zze;
                FirebaseApp firebaseApp = firebaseAuth.zza;
                String string = ((EmailAuthCredential)((Object)object)).zzb();
                object = ((EmailAuthCredential)((Object)object)).zzc();
                String string2 = firebaseUser.getTenantId();
                zzt zzt2 = new zzt(firebaseAuth);
                return zztn2.zzs(firebaseApp, firebaseUser, string, (String)object, string2, zzt2);
            }
            if (firebaseAuth.zzJ(((EmailAuthCredential)((Object)object)).zzd())) {
                FirebaseAuth firebaseAuth = new Status(17072);
                return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
            }
            zztn zztn3 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            zzt zzt3 = new zzt(firebaseAuth);
            return zztn3.zzu(firebaseApp, firebaseUser, (EmailAuthCredential)((Object)object), zzt3);
        }
        if (object instanceof PhoneAuthCredential) {
            zztn zztn4 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            object = (PhoneAuthCredential)object;
            String string = firebaseAuth.zzk;
            zzt zzt4 = new zzt(firebaseAuth);
            return zztn4.zzx(firebaseApp, firebaseUser, (PhoneAuthCredential)object, string, zzt4);
        }
        zztn zztn5 = firebaseAuth.zze;
        FirebaseApp firebaseApp = firebaseAuth.zza;
        String string = firebaseUser.getTenantId();
        zzt zzt5 = new zzt(firebaseAuth);
        return zztn5.zzh(firebaseApp, firebaseUser, (AuthCredential)((Object)object), string, zzt5);
    }

    public final Task<AuthResult> zzi(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential object) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)object);
        object = object.zza();
        if (object instanceof EmailAuthCredential) {
            if ("password".equals(((EmailAuthCredential)((Object)(object = (EmailAuthCredential)((Object)object)))).getSignInMethod())) {
                zztn zztn2 = firebaseAuth.zze;
                FirebaseApp firebaseApp = firebaseAuth.zza;
                String string = ((EmailAuthCredential)((Object)object)).zzb();
                object = ((EmailAuthCredential)((Object)object)).zzc();
                String string2 = firebaseUser.getTenantId();
                zzt zzt2 = new zzt(firebaseAuth);
                return zztn2.zzt(firebaseApp, firebaseUser, string, (String)object, string2, zzt2);
            }
            if (firebaseAuth.zzJ(((EmailAuthCredential)((Object)object)).zzd())) {
                FirebaseAuth firebaseAuth = new Status(17072);
                return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
            }
            zztn zztn3 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            zzt zzt3 = new zzt(firebaseAuth);
            return zztn3.zzv(firebaseApp, firebaseUser, (EmailAuthCredential)((Object)object), zzt3);
        }
        if (object instanceof PhoneAuthCredential) {
            zztn zztn4 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            object = (PhoneAuthCredential)object;
            String string = firebaseAuth.zzk;
            zzt zzt4 = new zzt(firebaseAuth);
            return zztn4.zzy(firebaseApp, firebaseUser, (PhoneAuthCredential)object, string, zzt4);
        }
        zztn zztn5 = firebaseAuth.zze;
        FirebaseApp firebaseApp = firebaseAuth.zza;
        String string = firebaseUser.getTenantId();
        zzt zzt5 = new zzt(firebaseAuth);
        return zztn5.zzi(firebaseApp, firebaseUser, (AuthCredential)((Object)object), string, zzt5);
    }

    public final void zzj(@NonNull String object, long l, TimeUnit object2, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, @Nullable Activity activity, @NonNull Executor executor, boolean bl, @Nullable String string, @Nullable String string2) {
        long l2 = TimeUnit.SECONDS.convert(l, (TimeUnit)((Object)object2));
        if (l2 < 0L || l2 > 120L) {
            Object object3 = new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
            throw object3;
        }
        object2 = new zzxi((String)object, l2, bl, ((FirebaseAuth)object3).zzi, ((FirebaseAuth)object3).zzk, string, zztp.zza(), string2);
        object = super.zzI((String)object, onVerificationStateChangedCallbacks);
        ((FirebaseAuth)object3).zze.zzk(((FirebaseAuth)object3).zza, (zzxi)object2, (PhoneAuthProvider.OnVerificationStateChangedCallbacks)object, activity, executor);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzk(@NonNull PhoneAuthOptions object) {
        if (((PhoneAuthOptions)object).zzk()) {
            FirebaseAuth firebaseAuth = ((PhoneAuthOptions)object).zza();
            Object object2 = (zzag)((PhoneAuthOptions)object).zzg();
            if (((PhoneAuthOptions)object).zzf() != null && zzvm.zzb((String)(object2 = ((zzag)((Object)object2)).zze() ? ((PhoneAuthOptions)object).zzb() : ((PhoneAuthOptions)object).zzj().getUid()), ((PhoneAuthOptions)object).zzd(), ((PhoneAuthOptions)object).zzi(), ((PhoneAuthOptions)object).zze())) return;
            object2 = firebaseAuth.zzn;
            Object object3 = ((PhoneAuthOptions)object).zzb();
            Activity activity = ((PhoneAuthOptions)object).zzi();
            boolean bl = zztp.zza();
            object2 = ((zzf)object2).zzb(firebaseAuth, (String)object3, activity, bl);
            object3 = new zzp(firebaseAuth, (PhoneAuthOptions)object);
            object2.addOnCompleteListener((OnCompleteListener)object3);
            return;
        }
        FirebaseAuth firebaseAuth = ((PhoneAuthOptions)object).zza();
        String string = ((PhoneAuthOptions)object).zzb();
        long l = ((PhoneAuthOptions)object).zzc();
        TimeUnit timeUnit = TimeUnit.SECONDS;
        PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks = ((PhoneAuthOptions)object).zzd();
        Activity activity = ((PhoneAuthOptions)object).zzi();
        Executor executor = ((PhoneAuthOptions)object).zze();
        boolean bl = ((PhoneAuthOptions)object).zzf() != null;
        if (!bl && zzvm.zzb(string, onVerificationStateChangedCallbacks, activity, executor)) {
            return;
        }
        object = firebaseAuth.zzn;
        boolean bl2 = zztp.zza();
        object = ((zzf)object).zzb(firebaseAuth, string, activity, bl2);
        zzo zzo2 = new zzo(firebaseAuth, string, l, timeUnit, onVerificationStateChangedCallbacks, activity, executor, bl);
        object.addOnCompleteListener((OnCompleteListener)zzo2);
    }

    private final PhoneAuthProvider.OnVerificationStateChangedCallbacks zzI(String object, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
        if (this.zzg.zzc() && ((String)object).equals(this.zzg.zza())) {
            object = new zzq(this, onVerificationStateChangedCallbacks);
            return object;
        }
        return onVerificationStateChangedCallbacks;
    }

    @NonNull
    public final Task<Void> zzl(@NonNull FirebaseUser firebaseUser, zzbk zzbk2) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zze.zzJ(this.zza, firebaseUser, zzbk2);
    }

    @NonNull
    public final Task<AuthResult> zzm(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        Preconditions.checkNotNull((Object)firebaseUser);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        authCredential = authCredential.zza();
        zzt zzt2 = new zzt(this);
        return zztn2.zzH(firebaseApp, firebaseUser, authCredential, zzt2);
    }

    @NonNull
    public final Task<AuthResult> zzn(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)firebaseUser);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        zzt zzt2 = new zzt(this);
        return zztn2.zzI(firebaseApp, firebaseUser, string, zzt2);
    }

    @NonNull
    public final Task<Void> zzo(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)userProfileChangeRequest));
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        zzt zzt2 = new zzt(this);
        return zztn2.zzl(firebaseApp, firebaseUser, userProfileChangeRequest, zzt2);
    }

    @NonNull
    public final Task<Void> zzp(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        zzt zzt2 = new zzt(this);
        return zztn2.zzm(firebaseApp, firebaseUser, string, zzt2);
    }

    @NonNull
    public final Task<Void> zzq(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)phoneAuthCredential);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        phoneAuthCredential = phoneAuthCredential.zzi();
        zzt zzt2 = new zzt(this);
        return zztn2.zzo(firebaseApp, firebaseUser, phoneAuthCredential, zzt2);
    }

    @NonNull
    public final Task<Void> zzr(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        zzt zzt2 = new zzt(this);
        return zztn2.zzn(firebaseApp, firebaseUser, string, zzt2);
    }

    @NonNull
    public final Task<Void> zzs(@Nullable ActionCodeSettings actionCodeSettings, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        if (this.zzi != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.zza();
            }
            actionCodeSettings.zzc(this.zzi);
        }
        return this.zze.zzC(this.zza, actionCodeSettings, string);
    }

    public final Task<Void> zzt(FirebaseUser task, String object) {
        Preconditions.checkNotNull((Object)task);
        Preconditions.checkNotEmpty((String)object);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        zzt zzt2 = new zzt(this);
        task = zztn2.zzQ(firebaseApp, (FirebaseUser)task, (String)object, zzt2);
        object = new com.google.firebase.auth.zzr(this);
        return task.continueWithTask((Continuation)object);
    }

    public final Task<AuthResult> zzu(MultiFactorAssertion multiFactorAssertion, zzag object, @Nullable FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)multiFactorAssertion);
        Preconditions.checkNotNull((Object)object);
        zztn zztn2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        multiFactorAssertion = (PhoneMultiFactorAssertion)multiFactorAssertion;
        object = object.zzd();
        zzs zzs2 = new zzs(this);
        return zztn2.zzP(firebaseApp, firebaseUser, (PhoneMultiFactorAssertion)multiFactorAssertion, (String)object, zzs2);
    }

    public final Task<AuthResult> zzv(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider, @NonNull FirebaseUser firebaseUser) {
        FirebaseAuth firebaseAuth;
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)firebaseUser);
        if (!zztp.zza()) {
            firebaseAuth = new Status(17063);
            return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!firebaseAuth.zzm.zzj(activity, (TaskCompletionSource<AuthResult>)taskCompletionSource, firebaseAuth, firebaseUser)) {
            firebaseAuth = new Status(17057);
            return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
        }
        firebaseAuth.zzm.zzc(activity.getApplicationContext(), firebaseAuth, firebaseUser);
        federatedAuthProvider.zzb(activity);
        return taskCompletionSource.getTask();
    }

    public final Task<AuthResult> zzw(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider, @NonNull FirebaseUser firebaseUser) {
        FirebaseAuth firebaseAuth;
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)firebaseUser);
        if (!zztp.zza()) {
            firebaseAuth = new Status(17063);
            return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!firebaseAuth.zzm.zzj(activity, (TaskCompletionSource<AuthResult>)taskCompletionSource, firebaseAuth, firebaseUser)) {
            firebaseAuth = new Status(17057);
            return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
        }
        firebaseAuth.zzm.zzc(activity.getApplicationContext(), firebaseAuth, firebaseUser);
        federatedAuthProvider.zzc(activity);
        return taskCompletionSource.getTask();
    }

    @NonNull
    public final Task<Void> zzx(@NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        zztn zztn2 = this.zze;
        zzi zzi2 = new zzi(this, firebaseUser);
        return zztn2.zzK(firebaseUser, zzi2);
    }

    public final Task<Void> zzy(String string, String string2, @Nullable ActionCodeSettings actionCodeSettings) {
        String string3;
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        if (actionCodeSettings == null) {
            actionCodeSettings = ActionCodeSettings.zza();
        }
        if ((string3 = this.zzi) != null) {
            actionCodeSettings.zzc(string3);
        }
        return this.zze.zzR(string, string2, actionCodeSettings);
    }

    public final Task<Void> zzz(FirebaseUser firebaseUser, MultiFactorAssertion multiFactorAssertion, @Nullable String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)multiFactorAssertion);
        if (multiFactorAssertion instanceof PhoneMultiFactorAssertion) {
            zztn zztn2 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            multiFactorAssertion = (PhoneMultiFactorAssertion)multiFactorAssertion;
            zzs zzs2 = new zzs(firebaseAuth);
            return zztn2.zzN(firebaseApp, (PhoneMultiFactorAssertion)multiFactorAssertion, firebaseUser, string, zzs2);
        }
        FirebaseAuth firebaseAuth = new Status(17499);
        return Tasks.forException((Exception)zztt.zza((Status)firebaseAuth));
    }

    private final boolean zzJ(String object) {
        return (object = ActionCodeUrl.parseLink((String)object)) != null && !TextUtils.equals((CharSequence)this.zzk, (CharSequence)((ActionCodeUrl)object).zza());
    }

    static /* synthetic */ List zzA(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzc;
    }

    static /* synthetic */ List zzB(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzb;
    }

    static /* synthetic */ List zzC(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzd;
    }

    static /* synthetic */ PhoneAuthProvider.OnVerificationStateChangedCallbacks zzD(FirebaseAuth firebaseAuth, String string, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
        return firebaseAuth.zzI(string, onVerificationStateChangedCallbacks);
    }

    static /* synthetic */ String zzE(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzi;
    }

    static /* synthetic */ zztn zzF(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zze;
    }

    static /* synthetic */ zzw zzG(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzg;
    }

    static /* synthetic */ FirebaseUser zzH(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzf;
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }
}

