/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.auth.api.phone.SmsRetriever;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.firebase-auth-api.zzaf;
import com.google.android.gms.internal.firebase-auth-api.zzh;
import com.google.android.gms.internal.firebase-auth-api.zzq;
import com.google.android.gms.internal.firebase-auth-api.zztq;
import com.google.android.gms.internal.firebase-auth-api.zzvn;
import com.google.android.gms.internal.firebase-auth-api.zzvo;
import com.google.android.gms.internal.firebase-auth-api.zzvq;
import com.google.android.gms.internal.firebase-auth-api.zzvr;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.firebase.auth.PhoneAuthCredential;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class zzvs {
    private static final Logger zza;
    private final Context zzb;
    private final ScheduledExecutorService zzc;
    private final HashMap<String, zzvr> zzd;

    zzvs(@NonNull Context context) {
        HashMap hashMap = new HashMap();
        this.zzd = hashMap;
        this.zzb = (Context)Preconditions.checkNotNull((Object)context);
        zzh.zza();
        this.zzc = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(1));
    }

    final boolean zza(String string) {
        return this.zzd.get(string) != null;
    }

    final void zzb(String string, zztq object, long l, boolean bl) {
        Object object2 = this.zzd;
        zzvr zzvr2 = new zzvr(l, bl);
        ((HashMap)object2).put((String)string, (zzvr)zzvr2);
        this.zzc((zztq)object, string);
        object = this.zzd.get(string);
        if (((zzvr)object).zza <= 0L) {
            zza.w("Timeout of 0 specified; SmsRetriever will not start.", new Object[0]);
            return;
        }
        ScheduledExecutorService scheduledExecutorService = this.zzc;
        object2 = new zzvn(this, string);
        ((zzvr)object).zzf = scheduledExecutorService.schedule((Runnable)object2, ((zzvr)object).zza, TimeUnit.SECONDS);
        if (!((zzvr)object).zzc) {
            zza.w("SMS auto-retrieval unavailable; SmsRetriever will not start.", new Object[0]);
            return;
        }
        object = new zzvq(this, string);
        string = new IntentFilter();
        string.addAction("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
        this.zzb.getApplicationContext().registerReceiver((BroadcastReceiver)object, (IntentFilter)string);
        string = this.zzb;
        string = SmsRetriever.getClient((Context)string);
        string = string.startSmsRetriever();
        object = new zzvo(this);
        string.addOnFailureListener((OnFailureListener)object);
    }

    final void zzc(zztq zztq2, String string) {
        zzvr zzvr2 = ((zzvs)((Object)zzvr2)).zzd.get(string);
        if (zzvr2 == null) {
            return;
        }
        zzvr2.zzb.add(zztq2);
        if (zzvr2.zzg) {
            zztq2.zzh(zzvr2.zzd);
        }
        if (zzvr2.zzh) {
            zztq2.zzi(PhoneAuthCredential.zzb(zzvr2.zzd, zzvr2.zze));
        }
        if (zzvr2.zzi) {
            zztq2.zzj(zzvr2.zzd);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String zzd() {
        try {
            void var0_3;
            String string;
            String string2 = this.zzb.getPackageName();
            int n = Build.VERSION.SDK_INT;
            if (n < 28) {
                Context context = this.zzb;
                Signature[] signatureArray = Wrappers.packageManager((Context)context).getPackageInfo((String)string2, (int)64).signatures;
            } else {
                Context context = this.zzb;
                Signature[] signatureArray = Wrappers.packageManager((Context)context).getPackageInfo((String)string2, (int)0x8000000).signingInfo.getApkContentsSigners();
            }
            if ((string = zzvs.zzm(string2, var0_3[0].toCharsString())) != null) {
                return string;
            }
            zza.e("Hash generation failed.", new Object[0]);
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zza.e("Unable to find package to obtain hash.", new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String zzm(String string, String object) {
        MessageDigest messageDigest;
        String string2 = String.valueOf(string);
        int n = string2.length();
        String string3 = String.valueOf(object);
        int n2 = string3.length();
        StringBuilder stringBuilder = new StringBuilder(n + 1 + n2);
        stringBuilder.append(string);
        stringBuilder.append(" ");
        stringBuilder.append((String)object);
        object = stringBuilder.toString();
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(((String)object).getBytes(zzq.zzc));
            object = Arrays.copyOf(messageDigest.digest(), 9);
            object = Base64.encodeToString((byte[])object, (int)3).substring(0, 11);
            messageDigest = zza;
            n2 = String.valueOf(string).length();
            n2 += 19;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            object = zza;
            String string4 = String.valueOf(noSuchAlgorithmException.getMessage());
            String string5 = "NoSuchAlgorithm: ";
            string4 = string4.length() != 0 ? string5.concat(string4) : new String(string5);
            object.e(string4, new Object[0]);
            return null;
        }
        {
            int n3 = String.valueOf(object).length();
            StringBuilder stringBuilder2 = new StringBuilder(n2 += n3);
            stringBuilder2.append("Package: ");
            stringBuilder2.append(string);
            stringBuilder2.append(" -- Hash: ");
            stringBuilder2.append((String)object);
            messageDigest.d(stringBuilder2.toString(), new Object[0]);
            return object;
        }
    }

    private final void zzn(String string) {
        zzvr zzvr2 = this.zzd.get(string);
        if (zzvr2 == null) {
            return;
        }
        if (!zzvr2.zzi) {
            this.zzo(string);
        }
        this.zze(string);
    }

    private final void zzo(String object) {
        zzvr zzvr2 = ((zzvs)((Object)zzvr2)).zzd.get(object);
        if (zzvr2 == null) {
            return;
        }
        if (!zzvr2.zzh && !zzaf.zzb(zzvr2.zzd)) {
            zza.w("Timed out waiting for SMS.", new Object[0]);
            object = zzvr2.zzb.iterator();
            while (object.hasNext()) {
                ((zztq)object.next()).zzj(zzvr2.zzd);
            }
            zzvr2.zzi = true;
            return;
        }
    }

    final void zze(String string) {
        zzvr zzvr2 = this.zzd.get(string);
        if (zzvr2 == null) {
            return;
        }
        ScheduledFuture<?> scheduledFuture = zzvr2.zzf;
        if (scheduledFuture != null && !scheduledFuture.isDone()) {
            zzvr2.zzf.cancel(false);
        }
        zzvr2.zzb.clear();
        this.zzd.remove(string);
    }

    @VisibleForTesting
    static String zzf(String object) {
        object = Pattern.compile("(?<!\\d)\\d{6}(?!\\d)").matcher((CharSequence)object);
        if (((Matcher)object).find()) {
            return ((Matcher)object).group();
        }
        return null;
    }

    final /* synthetic */ void zzg(String string) {
        this.zzn(string);
    }

    static /* synthetic */ Logger zzh() {
        return zza;
    }

    static /* synthetic */ HashMap zzi(zzvs zzvs2) {
        return zzvs2.zzd;
    }

    static /* synthetic */ void zzj(zzvs object, String object2) {
        object = ((zzvs)object).zzd.get(object2);
        if (object == null || zzaf.zzb(((zzvr)object).zzd) || zzaf.zzb(((zzvr)object).zze) || ((zzvr)object).zzb.isEmpty()) {
            return;
        }
        object2 = ((zzvr)object).zzb.iterator();
        while (object2.hasNext()) {
            ((zztq)object2.next()).zzi(PhoneAuthCredential.zzb(((zzvr)object).zzd, ((zzvr)object).zze));
        }
        ((zzvr)object).zzh = true;
    }

    static /* synthetic */ void zzk(zzvs zzvs2, String string) {
        zzvs2.zzn(string);
    }

    static /* synthetic */ void zzl(zzvs zzvs2, String string) {
        zzvs2.zzo(string);
    }

    static {
        Logger logger;
        String[] stringArray = new String[]{"SmsRetrieverHelper"};
        zza = logger = new Logger("FirebaseAuth", stringArray);
    }
}

