/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.content.Context;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Log;
import com.google.android.gms.internal.firebase-auth-api.zzaal;
import com.google.android.gms.internal.firebase-auth-api.zzag;
import com.google.android.gms.internal.firebase-auth-api.zzai;
import com.google.android.gms.internal.firebase-auth-api.zzaq;
import com.google.android.gms.internal.firebase-auth-api.zzau;
import com.google.android.gms.internal.firebase-auth-api.zzav;
import com.google.android.gms.internal.firebase-auth-api.zzaw;
import com.google.android.gms.internal.firebase-auth-api.zzds;
import com.google.android.gms.internal.firebase-auth-api.zzdv;
import com.google.android.gms.internal.firebase-auth-api.zzdw;
import com.google.android.gms.internal.firebase-auth-api.zzdx;
import com.google.android.gms.internal.firebase-auth-api.zzih;
import com.google.android.gms.internal.firebase-auth-api.zzlg;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.annotation.concurrent.GuardedBy;
import javax.crypto.KeyGenerator;

public final class zzdr {
    private zzaw zza = null;
    private String zzb = null;
    private zzag zzc = null;
    private zzaq zzd = null;
    @GuardedBy(value="this")
    private zzav zze;
    private zzdw zzf = null;

    public final zzdr zza(Context context, String string, String string2) throws IOException {
        if (context == null) {
            Object object = new IllegalArgumentException("need an Android context");
            throw object;
        }
        string = "GenericIdpKeyset";
        Object object = new zzdw(context, string, string2);
        ((zzdr)object).zzf = object;
        ((zzdr)object).zza = object = new zzdx(context, string, string2);
        return object;
    }

    public final zzdr zzb(String string) {
        if (!string.startsWith("android-keystore://")) {
            Object object = new IllegalArgumentException("key URI must start with android-keystore://");
            throw object;
        }
        ((zzdr)object).zzb = string;
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    public final zzdr zzc(zzih object) {
        int n;
        String string = ((zzih)object).zza();
        byte[] byArray = ((zzih)object).zzb().zzp();
        object = ((zzih)object).zzc();
        switch (((Enum)object).ordinal()) {
            case 1: {
                n = 1;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            default: {
                Object object2 = new IllegalArgumentException("Unknown output prefix type");
                throw object2;
            }
            case 2: {
                n = 2;
            }
        }
        ((zzdr)object2).zzd = zzaq.zzb(string, byArray, n);
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized zzds zzd() throws GeneralSecurityException, IOException {
        Object object;
        if (((zzdr)object2).zzb != null) {
            ((zzdr)object2).zzc = ((zzdr)object2).zzh();
        }
        try {
            object = ((zzdr)object2).zzi();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.w((String)zzds.zzb(), (String)"keyset not found, will generate a new one", (Throwable)fileNotFoundException);
            if (((zzdr)object2).zzd == null) {
                Object object2 = new GeneralSecurityException("cannot read or generate keyset");
                throw object2;
            }
            object = zzav.zzb();
            ((zzav)object).zzd(((zzdr)object2).zzd);
            ((zzav)object).zzf(((zzav)object).zzc().zzc().zza(0).zza());
            if (((zzdr)object2).zzc != null) {
                ((zzav)object).zzc().zzd(((zzdr)object2).zza, ((zzdr)object2).zzc);
            }
            zzai.zza(((zzav)object).zzc(), ((zzdr)object2).zza);
        }
        ((zzdr)object2).zze = object;
        return new zzds((zzdr)object2, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final zzag zzh() throws GeneralSecurityException {
        Object[] objectArray;
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)zzds.zzb(), (String)"Android Keystore requires at least Android M");
            return null;
        }
        Object[] objectArray2 = new zzdv();
        boolean bl = objectArray2.zzc(((zzdr)object).zzb);
        if (!bl) {
            objectArray = ((zzdr)object).zzb;
            zzdv zzdv2 = new zzdv();
            boolean bl2 = zzdv2.zzc((String)objectArray);
            if (bl2) {
                objectArray2 = new Object[]{objectArray};
                Object object = new IllegalArgumentException(String.format("cannot generate a new key %s because it already exists; please delete it with deleteKey() and try again", objectArray2));
                throw object;
            }
            Object object = "android-keystore://";
            objectArray = zzlg.zzc((String)object, (String)objectArray);
            object = "AES";
            String[] stringArray = "AndroidKeyStore";
            object = KeyGenerator.getInstance((String)object, (String)stringArray);
            stringArray = new KeyGenParameterSpec.Builder((String)objectArray, 3);
            objectArray = stringArray.setKeySize(256);
            stringArray = new String[]{"GCM"};
            objectArray = objectArray.setBlockModes(stringArray);
            stringArray = new String[]{"NoPadding"};
            ((KeyGenerator)object).init((AlgorithmParameterSpec)objectArray.setEncryptionPaddings(stringArray).build());
            ((KeyGenerator)object).generateKey();
        }
        return objectArray2.zzb(((zzdr)object).zzb);
        catch (GeneralSecurityException | ProviderException exception) {
            Log.w((String)zzds.zzb(), (String)"cannot use Android Keystore, it'll be disabled", (Throwable)exception);
            return null;
        }
        catch (GeneralSecurityException | ProviderException exception) {
            if (bl) {
                objectArray = new Object[]{((zzdr)object).zzb};
                KeyStoreException keyStoreException = new KeyStoreException(String.format("the master key %s exists but is unusable", objectArray), exception);
                throw keyStoreException;
            }
            Log.w((String)zzds.zzb(), (String)"cannot use Android Keystore, it'll be disabled", (Throwable)exception);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final zzav zzi() throws GeneralSecurityException, IOException {
        zzag zzag2 = this.zzc;
        if (zzag2 == null) return zzav.zza(zzai.zzb(this.zzf));
        try {
            zzdw zzdw2 = this.zzf;
            return zzav.zza(zzau.zzi(zzdw2, zzag2));
        }
        catch (zzaal | GeneralSecurityException exception) {
            Log.w((String)zzds.zzb(), (String)"cannot decrypt keyset: ", (Throwable)exception);
            return zzav.zza(zzai.zzb(this.zzf));
        }
    }

    static /* synthetic */ zzaw zze(zzdr zzdr2) {
        return zzdr2.zza;
    }

    static /* synthetic */ zzag zzf(zzdr zzdr2) {
        return zzdr2.zzc;
    }

    static /* synthetic */ zzav zzg(zzdr zzdr2) {
        return zzdr2.zze;
    }
}

