/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzabg;
import com.google.android.gms.internal.firebase-auth-api.zzan;
import com.google.android.gms.internal.firebase-auth-api.zzat;
import com.google.android.gms.internal.firebase-auth-api.zzbd;
import com.google.android.gms.internal.firebase-auth-api.zzbe;
import com.google.android.gms.internal.firebase-auth-api.zzbf;
import com.google.android.gms.internal.firebase-auth-api.zzbg;
import com.google.android.gms.internal.firebase-auth-api.zzbh;
import com.google.android.gms.internal.firebase-auth-api.zzbi;
import com.google.android.gms.internal.firebase-auth-api.zzbj;
import com.google.android.gms.internal.firebase-auth-api.zzbk;
import com.google.android.gms.internal.firebase-auth-api.zzic;
import com.google.android.gms.internal.firebase-auth-api.zzih;
import com.google.android.gms.internal.firebase-auth-api.zzzb;
import java.security.GeneralSecurityException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class zzbl {
    private static final Logger zza = Logger.getLogger(zzbl.class.getName());
    private static final ConcurrentMap<String, zzbk> zzb;
    private static final ConcurrentMap<String, zzbj> zzc;
    private static final ConcurrentMap<String, Boolean> zzd;
    private static final ConcurrentMap<String, Object> zze;
    private static final ConcurrentMap<Class<?>, zzbe<?, ?>> zzf;

    /*
     * Enabled aggressive block sorting
     */
    private static synchronized zzbk zzn(String string) throws GeneralSecurityException {
        if (zzb.containsKey(string)) {
            return (zzbk)zzb.get(string);
        }
        string = String.valueOf(string);
        String string2 = "No key manager found for key type ";
        string = string.length() != 0 ? string2.concat(string) : new String(string2);
        GeneralSecurityException generalSecurityException = new GeneralSecurityException(string);
        throw generalSecurityException;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static synchronized void zzo(String string, Class<?> serializable, boolean bl) throws GeneralSecurityException {
        if (!zzb.containsKey(string)) {
            return;
        }
        zzbk zzbk2 = (zzbk)zzb.get(string);
        if (!zzbk2.zzc().equals(serializable)) {
            Object[] objectArray = zza;
            Level level = Level.WARNING;
            Object object = "Attempted overwrite of a registered key manager for key type ";
            if (string.length() != 0) {
                object = ((String)object).concat(string);
            } else {
                String string2 = new String((String)object);
                object = string2;
            }
            objectArray.logp(level, "com.google.crypto.tink.Registry", "ensureKeyManagerInsertable", (String)object);
            objectArray = new Object[]{string, zzbk2.zzc().getName(), ((Class)serializable).getName()};
            object = new GeneralSecurityException(String.format("typeUrl (%s) is already registered with %s, cannot be re-registered with %s", objectArray));
            throw object;
        }
        if (bl && !((Boolean)zzd.get(string)).booleanValue()) {
            String string3 = "New keys are already disallowed for key type ";
            string = string.length() != 0 ? string3.concat(string) : new String(string3);
            serializable = new GeneralSecurityException(string);
            throw serializable;
        }
    }

    public static synchronized <KeyProtoT extends zzabg> void zza(zzat<KeyProtoT> zzat2, boolean bl) throws GeneralSecurityException {
        String string = zzat2.zzb();
        zzbl.zzo(string, zzat2.getClass(), true);
        if (!zzb.containsKey(string)) {
            ConcurrentMap<String, Object> concurrentMap = zzb;
            Object object = new zzbh(zzat2);
            concurrentMap.put(string, (zzbk)object);
            concurrentMap = zzc;
            object = new zzbj(zzat2);
            concurrentMap.put(string, (zzbk)object);
        }
        zzd.put(string, true);
    }

    public static synchronized <KeyProtoT extends zzabg, PublicKeyProtoT extends zzabg> void zzb(zzbg<KeyProtoT, PublicKeyProtoT> object, zzat<PublicKeyProtoT> zzat2, boolean bl) throws GeneralSecurityException {
        ConcurrentMap<String, zzbj> concurrentMap;
        Object object2 = "type.googleapis.com/google.crypto.tink.EciesAeadHkdfPrivateKey";
        zzbl.zzo((String)object2, object.getClass(), true);
        Object[] objectArray = "type.googleapis.com/google.crypto.tink.EciesAeadHkdfPublicKey";
        zzbl.zzo((String)objectArray, zzat2.getClass(), false);
        if (!zzb.containsKey(object2) || (concurrentMap = ((zzbk)zzb.get(object2)).zze()) == null || concurrentMap.equals(zzat2.getClass())) {
            if (!zzb.containsKey(object2) || ((zzbk)zzb.get(object2)).zze() == null) {
                concurrentMap = zzb;
                Object object3 = new zzbi((zzbg)object, zzat2);
                concurrentMap.put((String)object2, (zzbj)object3);
                concurrentMap = zzc;
                object3 = new zzbj((zzat)object);
                concurrentMap.put((String)object2, (zzbj)object3);
            }
            zzd.put((String)object2, true);
            if (!zzb.containsKey(objectArray)) {
                object = zzb;
                object2 = new zzbh(zzat2);
                object.put(objectArray, object2);
            }
        } else {
            Logger logger = zza;
            Level level = Level.WARNING;
            StringBuilder stringBuilder = new StringBuilder(219);
            stringBuilder.append("Attempted overwrite of a registered key manager for key type ");
            stringBuilder.append((String)object2);
            stringBuilder.append(" with inconsistent public key type ");
            stringBuilder.append((String)objectArray);
            logger.logp(level, "com.google.crypto.tink.Registry", "registerAsymmetricKeyManagers", stringBuilder.toString());
            objectArray = new Object[]{object.getClass().getName(), ((Class)((Object)concurrentMap)).getName(), zzat2.getClass().getName()};
            object2 = new GeneralSecurityException(String.format("public key manager corresponding to %s is already registered with %s, cannot be re-registered with %s", objectArray));
            throw object2;
        }
        zzd.put((String)objectArray, false);
    }

    public static synchronized <B, P> void zzc(zzbe<B, P> object) throws GeneralSecurityException {
        if (object == null) {
            object = new IllegalArgumentException("wrapper must be non-null");
            throw object;
        }
        Class<P> clazz = object.zzb();
        if (zzf.containsKey(clazz)) {
            zzbe zzbe2 = (zzbe)zzf.get(clazz);
            if (!object.getClass().equals(zzbe2.getClass())) {
                Object object2 = zza;
                Object[] objectArray = Level.WARNING;
                String string = String.valueOf(clazz);
                String string2 = String.valueOf(string);
                int n = string2.length();
                StringBuilder stringBuilder = new StringBuilder(n + 56);
                stringBuilder.append("Attempted overwrite of a registered SetWrapper for type ");
                stringBuilder.append(string);
                ((Logger)object2).logp((Level)objectArray, "com.google.crypto.tink.Registry", "registerPrimitiveWrapper", stringBuilder.toString());
                objectArray = new Object[]{clazz.getName(), zzbe2.getClass().getName(), object.getClass().getName()};
                object2 = new GeneralSecurityException(String.format("SetWrapper for primitive (%s) is already registered to be %s, cannot be re-registered with %s", objectArray));
                throw object2;
            }
        }
        zzf.put(clazz, (zzbe<?, ?>)object);
    }

    public static zzan<?> zzd(String string) throws GeneralSecurityException {
        return zzbl.zzn(string).zzb();
    }

    private static <P> zzan<P> zzp(String set, Class<P> object) throws GeneralSecurityException {
        set = zzbl.zzn((String)((Object)set));
        if (object == null) {
            return set.zzb();
        }
        if (set.zzd().contains(object)) {
            return set.zza(object);
        }
        object = ((Class)object).getName();
        String string = String.valueOf(set.zzc());
        set = set.zzd();
        CharSequence charSequence = new StringBuilder();
        Object object2 = set.iterator();
        boolean bl = true;
        while (true) {
            Object object3;
            if (object2.hasNext()) {
                object3 = object2.next();
                if (!bl) {
                    ((StringBuilder)charSequence).append(", ");
                }
            } else {
                String string2 = ((StringBuilder)charSequence).toString();
                charSequence = String.valueOf(object);
                int n = ((String)charSequence).length();
                object2 = String.valueOf(string);
                int n2 = ((String)object2).length();
                object3 = String.valueOf(string2);
                int n3 = ((String)object3).length();
                StringBuilder stringBuilder = new StringBuilder(n + 77 + n2 + n3);
                stringBuilder.append("Primitive type ");
                stringBuilder.append((String)object);
                stringBuilder.append(" not supported by key manager of type ");
                stringBuilder.append(string);
                stringBuilder.append(", supported primitives: ");
                stringBuilder.append(string2);
                GeneralSecurityException generalSecurityException = new GeneralSecurityException(stringBuilder.toString());
                throw generalSecurityException;
            }
            ((StringBuilder)charSequence).append(((Class)object3).getCanonicalName());
            bl = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static synchronized zzic zze(zzih object) throws GeneralSecurityException {
        Object object2 = zzbl.zzd(((zzih)object).zza());
        if (((Boolean)zzd.get(((zzih)object).zza())).booleanValue()) {
            return object2.zzd(((zzih)object).zzb());
        }
        object = String.valueOf(((zzih)object).zza());
        String string = "newKey-operation not permitted for key type ";
        object = ((String)object).length() != 0 ? string.concat((String)object) : new String(string);
        object2 = new GeneralSecurityException((String)object);
        throw object2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static synchronized zzabg zzf(zzih object) throws GeneralSecurityException {
        Object object2 = zzbl.zzd(((zzih)object).zza());
        if (((Boolean)zzd.get(((zzih)object).zza())).booleanValue()) {
            return object2.zzc(((zzih)object).zzb());
        }
        object = String.valueOf(((zzih)object).zza());
        String string = "newKey-operation not permitted for key type ";
        object = ((String)object).length() != 0 ? string.concat((String)object) : new String(string);
        object2 = new GeneralSecurityException((String)object);
        throw object2;
    }

    public static zzic zzg(String string, zzzb serializable) throws GeneralSecurityException {
        zzan zzan2 = zzbl.zzp(string, null);
        if (!(zzan2 instanceof zzbf)) {
            zzan2 = String.valueOf(string);
            int n = ((String)((Object)zzan2)).length();
            StringBuilder stringBuilder = new StringBuilder(n + 48);
            stringBuilder.append("manager for key type ");
            stringBuilder.append(string);
            stringBuilder.append(" is not a PrivateKeyManager");
            serializable = new GeneralSecurityException(stringBuilder.toString());
            throw serializable;
        }
        return ((zzbf)zzan2).zze((zzzb)serializable);
    }

    public static <P> P zzh(String string, zzabg zzabg2, Class<P> clazz) throws GeneralSecurityException {
        return zzbl.zzp(string, clazz).zzb(zzabg2);
    }

    private static <P> P zzq(String string, zzzb zzzb2, Class<P> clazz) throws GeneralSecurityException {
        return zzbl.zzp(string, clazz).zza(zzzb2);
    }

    public static <P> P zzi(String string, byte[] byArray, Class<P> clazz) throws GeneralSecurityException {
        return zzbl.zzq(string, zzzb.zzm(byArray), clazz);
    }

    @Deprecated
    public static <P> P zzj(zzic zzic2) throws GeneralSecurityException {
        return zzbl.zzq(zzic2.zza(), zzic2.zzb(), null);
    }

    public static <P> P zzk(zzic zzic2, Class<P> clazz) throws GeneralSecurityException {
        return zzbl.zzq(zzic2.zza(), zzic2.zzb(), clazz);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <B, P> P zzl(zzbd<B> object, Class<P> object2) throws GeneralSecurityException {
        if ((object2 = (zzbe)zzf.get(object2)) == null) {
            object = String.valueOf(((zzbd)object).zze().getName());
            String string = "No wrapper found for ";
            object = ((String)object).length() != 0 ? string.concat((String)object) : new String(string);
            object2 = new GeneralSecurityException((String)object);
            throw object2;
        }
        if (!object2.zzc().equals(((zzbd)object).zze())) {
            object2 = String.valueOf(object2.zzc());
            object = String.valueOf(((zzbd)object).zze());
            String string = String.valueOf(object2);
            int n = string.length();
            String string2 = String.valueOf(object);
            int n2 = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n + 44 + n2);
            stringBuilder.append("Wrong input primitive class, expected ");
            stringBuilder.append((String)object2);
            stringBuilder.append(", got ");
            stringBuilder.append((String)object);
            GeneralSecurityException generalSecurityException = new GeneralSecurityException(stringBuilder.toString());
            throw generalSecurityException;
        }
        return object2.zza(object);
    }

    public static Class<?> zzm(Class<?> object) {
        if ((object = (zzbe)zzf.get(object)) == null) {
            return null;
        }
        return object.zzc();
    }

    private zzbl() {
    }

    static {
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        zzb = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        zzc = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        zzd = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        zze = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        zzf = concurrentHashMap;
    }
}

